// Persistence of Vision Ray Tracer Scene Description File
// File: domino.pov
// Vers: megapov 0.4
// Date: 04/02/2000
// Auth: Rodolphe
// Mail: rod.gelaude@infonie.fr


#version unofficial MegaPov 0.4;
global_settings {
  assumed_gamma 1.33
  //post_process {focal_blur{ 5.5, .1, 6, 1.0}}
  post_process {focal_blur{ 10, .3, 6, 1.0}}
}
 

//debut de fichier
camera {
    location <1.5, 3, -6> 
    direction <0, 0, 1.20711>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <00, .5, 0>
}

#default {
  pigment {rgb <1,1,1>}
 }
light_source {
    0*x 
    color rgb 1.0 
    area_light 
    <8,0,0> <0,0,8>
    4, 4 
    adaptive 0
    jitter 
    translate <-2000,4000,-2000> 
}    
#include "colors.inc"
//#include "crea_dom.pov"


//forme des dominos
#declare trou =
sphere {
  <0,0.25,-0.2> 0.09
  finish {
      ambient 0.1
      diffuse 0.6
      phong 0.8
      phong_size 80
    }
  pigment {Black}
  }
#declare sdom =
difference {
superellipsoid
{
  <0.1,0.1> 
  scale 0.5  scale <0.5,1,0.25> translate 0.5*y 
  finish {
      ambient 0.1
      diffuse 0.6
    }
  pigment {White}
}
cylinder {
<-0.2,0.5,-0.2><0.2,0.5,-0.2>0.08 
finish {
      ambient 0.1
      diffuse 0.6
    }
  pigment {Black}
}
}
#declare d1 =
object {trou}
#declare d2 =
union {
object {trou translate <-0.12,0.12,0>}
object {trou translate <0.12,-0.12,0>}
}
#declare d3 =
union {
object {trou }             
object {d2}
}
#declare d4 =
union {
object {trou translate <-0.12,0.12,0>}
object {trou translate <0.12,-0.12,0>}
object {trou translate <0.12,0.12,0>}
object {trou translate <-0.12,-0.12,0>}
}
#declare d5 =
union {
object {d4}
object {trou}
}
#declare d6 =
union {
object {d4}
object {trou translate -0.12*x}
object {trou translate 0.12*x}
}



//les dominos
#declare Domino =
difference {
object {sdom}
union {
object {d5}
object {d2 translate 0.5*y}
}scale 2}
#declare Domino1 =
difference {
object {sdom}
union {
object {d6}
object {d3 translate 0.5*y}
}scale 2}
#declare Domino2 =
difference {
object {sdom}
union {
object {d4}
object {d5 translate 0.5*y}
}scale 2}
#declare Domino3 =
difference {
object {sdom}
union {
object {d6}
object {d6 translate 0.5*y}
}scale 2}
#declare Domino4 =
difference {
object {sdom}
union {
object {d1 translate 0.5*y}
}scale 2}
#declare Domino5 =
difference {
object {sdom}
union {
object {d1}
object {d1 translate 0.5*y}
}scale 2}
#declare Domino6 =
difference {
object {sdom}
union {
object {d1}
object {d5 translate 0.5*y}
}scale 2}
#declare Domino7 =
difference {
object {sdom}
union {
object {d2}
object {d4 translate 0.5*y}
}scale 2}
#declare Domino8 =
difference {
object {sdom}
union {
object {d4}
object {d4 translate 0.5*y}
}scale 2}


//la scene
object {Domino}
object {Domino1 rotate 12*y translate <2,0,4>}
object {Domino2 rotate -7*y translate <-3,0,6>}
object {Domino3 rotate -9.5*y translate <2.7,0,7>}
object {Domino4 rotate 4.2*y translate <-5,0,9>}
object {Domino5 rotate -5*y translate <.3,0,10.2>}
object {Domino6 rotate 18*y translate <-12,0,18>}
object {Domino7 translate <5,0,18.3>}
object {Domino8 rotate <90,48,0> translate <1,0.20,-3>}
//le sol
plane{
  y,  0 
texture {
    pigment {
        bozo
        color_map {
            [ 0.000 rgb <0.55, 0.32, 0.20> ] 
            [ 0.100 rgb <0.55, 0.32, 0.20> ] 
            [ 0.101 rgb <0.55, 0.35, 0.20> ] 
            [ 0.200 rgb <0.88, 0.60, 0.40> ] 
            [ 0.201 rgb <0.88, 0.60, 0.40> ] 
            [ 0.300 rgb <0.60, 0.30, 0.20> ] 
            [ 0.301 rgb <0.60, 0.30, 0.20> ] 
            [ 0.400 rgb <0.60, 0.30, 0.20> ] 
            [ 0.401 rgb <0.60, 0.30, 0.20> ] 
            [ 0.900 rgb <0.88, 0.60, 0.40> ] 
            [ 0.901 rgb <0.88, 0.60, 0.40> ] 
            [ 1.000 rgb <0.55, 0.32, 0.20> ] 
        }turbulence <.25,.2,.2>
    }
    scale 10
    scale <35,.125,1>
    scale .05
finish {ambient .3 diffuse .7 reflection .2 crand .1}    
}
}
