//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

/*

UV Mapping Demo Scene
Created Feb 20, 1999

This contains 4 shapes that currently support uv mapping.  (This
does not have a mesh object).

All of these objects use the same hexagon texture.  Change the
line below to read "#declare USE_UV_MAPPING=yes;" to see what
the difference is without uv mapping.

This was originally created in moray.

*/

#declare USE_UV_MAPPING=yes;

camera {  //  Camera StdCam
  location  <     -4.042,      -8.503,       9.486>
  direction <        0.0,         0.0,      1.8317> // Aperture is 0.53 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.000,       0.000,       0.000>
}

light_source {  <0.000, -20.000, 20.000> color rgb <1.000, 1.000, 1.000>}

#include "demouv.inc"

/* background sphere */
sphere { // Sphere002
  <0,0,0>,1
  material {
    Material2
  }
  scale 36.904232
}

/*
  Bezier patch
  
  This shows how uv mapping stretches textures on patch objects.
  
*/
  
object { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3 uv_vectors <0,0>,<1,1>
      <-1.405520, -1.320594, -2.802548>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.679406, -4.292994, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-0.830149, 6.029724, 4.840764>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  #if(USE_UV_MAPPING) uv_mapping #end
  material {
    Material1
  }
  rotate 90.0*z
  translate  <-2.7761, -0.740293, 0.0>
}

/*
  Lathe object
  
  This is a linear sweep lathe, with points close together near the top
  and far apart near the bottom, showing how the spacing of the control
  points affects the stretching and squishing of the surface-mapped
  texture.
  
  (An SOR object would look exactly the same.)
  
*/
lathe { // RotSweep001
  linear_spline
  7  // control points
  <1.467091, -1.997877>,
  <0.978344, -1.385828>,
  <0.651805, -0.35138>,
  <0.577495, 0.638004>,
  <0.544586, 1.217091>,
  <0.532909, 1.679406>,
  <0.532909, 2.046709>
  rotate <90,0,90>
  #if(USE_UV_MAPPING) uv_mapping #end
  material {
    Material1
  }
  translate  <2.405954, -0.925367, 0.0>
}

/*
  Sphere
  
  The sphere uses the same algorithm as image_map type 2 (spherical
  mapping).  This squishes the texture at the poles and stretches
  it at the equator.
*/
sphere { // Sphere001
  <0,0,0>,1
  #if(USE_UV_MAPPING) uv_mapping #end
  material {
    Material1
  }
  translate  <2.035807, 2.961174, 0.0>
}

/*
  Box
  
  The texture gets wrapped around the box just like you would wrap
  a gift. But with no tape, of course.  ;)
*/
box { // Cube001
  <-1, -1, -1>, <1, 1, 1>
  #if(USE_UV_MAPPING) uv_mapping #end
  material {
    Material1
  }
  translate  <-1.850734, 3.33132, 0.0>
}




