// DensityMacroFunction returns an isosurface
// function based on the array reading mode of
// the dat_3D_3 function.
//
// Arguments: 
//	minV is a vector holding the minimum ends of the
//	     sampling region <minx,miny,minz>
//
//	maxV is a vector holding the maximum ends of the
//	     sampling region <maxx,maxy,maxz>
//
//	SampleV is a vector holding the number of samples
//	     to be taken in the sampling region 
//             <x_direction_samples,y_direction_samples,z_direction_samples>
//
//        Amplitude is a float that will multiply the calculated densities
//
//	SampleScaleV is a vector holding the scaling factors for the
//	     x, y, and z samples. If SampleScaleV is not <1,1,1>
//             the resulting surface is a sort of 'folding' of the
//	     the original.

#macro DensityMacroFunction(minV,maxV,SampleV,Amplitude,SampleScaleV)
                                               
        #local xmin=minV.x;#local xmax=maxV.x;
        #local ymin=minV.y;#local ymax=maxV.y;
        #local zmin=minV.z;#local zmax=maxV.z;
        #local xsamples=SampleV.x;
        #local ysamples=SampleV.y;
        #local zsamples=SampleV.z;                                                                           
        #local dxx=(xmax-xmin)/xsamples;
        #local dyy=(ymax-ymin)/ysamples; 
        #local dzz=(zmax-zmin)/zsamples;
        #declare density_array=array[xsamples][ysamples][zsamples]

        #local xx=xmin;
        #local xi=0;
        #while(xi<xsamples)
            #local yy=ymin;
            #local yi=0;
            #while(yi<ysamples)
                #local zz=zmin;
                #local zi=0;
                #while(zi<zsamples)   
                    // DensityMacro(xx,yy,zz) needs to have 
                    // been previously defined
                    #declare density_array[xi][yi][zi]=DensityMacro(xx,yy,zz);
                    
                    #local zz=zz+dzz;
                    #local zi=zi+1;                        
                #end
                #local yy=yy+dyy;
                #local yi=yi+1;
            #end
            #local xx=xx+dxx;              
            #local xi=xi+1;
        #end
        
        function {"data_3D_3", <Amplitude>, library   "i_dat3d", density_array, 
                               <SampleScaleV.x*xsamples,SampleScaleV.y*ysamples,SampleScaleV.z*zsamples,0>}  
        
#end

