 //filename="make-df3.pov"

//	Persistence of Vision Ray Tracer Scene Description File

//	Needs MegaPov 0.6

//	Date: august 10  2000

//	Author: Ren Smellenbergh

//	This demo shows how to create a df3 file from textures and objects

//	Use an image size with ratio of 1 and set  the clock on with number

//	of frames equal to the image size. Image 100*100 and 100 frames.

//	Note: a 100*100*100 df3 file uses 980 KB, a 300*300*300 file 25.7MB

//	Don't forget to save as df3 file. Use +fd or Output_File_Type=d as the output file type.



#version unofficial MegaPov 0.6;



#if (clock_on = 0)

	#error "This scene is designed to be used with the clock: please read the header and turn your clock on"

#end



global_settings { assumed_gamma 1.8 } //Adjust the gamma if necessary



camera {

	orthographic 

	location <0.0, 0.0, -10>

	up y*2.1

	right x*2.1

	look_at <0.0, 0.0, 0.0>

}



//*********** The object to be sliced *************

#declare Object =

union {

	sphere {	//left_top

		0.0, 0.5

		pigment {

			crackle

			color_map { [0 rgb 0] [0.3 rgb 0] [0.3 rgb 1.5] [1 rgb 1.5] }

			scale 0.18

		}

		finish {ambient 1}

		translate <-0.5, 0.5, 0>

	}

	sphere {	//left_bottom

		0.0, 0.5

		pigment {

			granite

			color_map { [0 rgb 0] [0.3 rgb 0] [0.3 rgb 1.5] [1 rgb 1.5] }

			scale 0.2

		}

		finish {ambient 1}

		translate <-0.5, -0.5, 0>

	}

	sphere {	//right_top

		0.0, 0.5

		pigment {

			leopard

			color_map { [0 rgbt <1, 1, 1, 1>] [0.4 rgbt <1, 1, 1, 1>] [0.4 rgb 1.0] [1 rgb 0.8] }

			scale 0.05

			warp { turbulence 0.05 }

		}

		finish {ambient 1}

		rotate y*-2

		translate <0.5, 0.5, 0>

	}

	//a row of 4 cylinders

	#declare C = 0;

	#declare Copies = 4;

	#while ( C < Copies)

		cylinder {

			<0, -0.45, 0.0>, <0, 0.45, 0.0>, 0.1

			texture {

				pigment {

					cylindrical

					color_map { [ 0.0 rgb 0 ] [ 0.3 rgb 0.3 ] [ 0.9 rgb 1 ] [ 1.0 rgb 2 ] }

					ramp_wave

					scale <0.1001, 0.45, 0.1001>

				}

				finish { ambient 1.5 }

			}

			rotate x*(C*-90/(Copies -1))

			translate x*(-0.35 + (C*(0.35 - (-0.35))/(Copies -1)))

			translate <0.5, -0.5, 0>

		} //object

		#declare C = C +1;

	#end  //while (C < Copies)

}



//******** Creating a subsequent slice of the objects with each new clock value ****************

intersection {

	box { <-1, -1, (clock*2-1)-0.01>, <1, 1, (clock*2-1)+0.01>}

	object { Object }

	cutaway_textures //to make sure we get the objects' texture at the sliced surface

}

