// Persistence Of Vision raytracer version 3.1e (isosurface patch)
// sample file by R.Suzuki   <rsuzuki@etl.go.jp>  Apr.'99
#version unofficial MegaPov 0.4;

#include "isocom.inc"
camera { location <0, 15, -50>  direction <0, 0,  3.2> look_at <0,0,0>}


#declare R0=1;
#declare R1=0.1;

#declare T1=object{isosurface
 {
     function {"torus",<R0,R1>}
     contained_by{ box {<-R0-R1,-R1,-R0-R1>,<R0+R1,R1,R0+R1>}} 
     texture {ComBl}
 }  
 no_shadow
}

#declare Count=5;
#while (Count>0)  
  isosurface
  {
     function {"helix1",<Count,2,R1,R0,1,1,0>}
     contained_by{ box {<-R0-R1,-R0*2,-R0-R1>,<R0+R1,R0*2,R0+R1>}} 
     texture {ComYw}
     translate <-12+Count*4,R0*3,0>
     no_shadow
  }
  object{T1   translate <-12+Count*4,R0*5,0>}
  object{T1   translate <-12+Count*4,R0,0>}
  #declare Count=Count-1;
#end


#declare Count=5;
#while (Count>0)  
  isosurface
  {
     function {"helix1",<1,Count+1,R1,R0,1,1,0>}
     contained_by{ box {<-R0-R1,-R0*2,-R0-R1>,<R0+R1,R0*2,R0+R1>}} 
     texture {ComYw}
     translate <-12+Count*4,-R0*3,0>
     no_shadow
  }
  object{T1   translate <-12+Count*4,-R0*5,0>}
  object{T1   translate <-12+Count*4,-R0,0>}
  #declare Count=Count-1;
#end
