//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;
global_settings {
	ini_option "-uv"
}

#declare Brown = rgb <0.647059, 0.164706, 0.164706>;
#declare SkyBlue = rgb <0.196078, 0.6, 0.8>;
camera {
	location <0.0, 0.0, -20>
	up y*image_height right x*image_width
	angle 50
	look_at <0.0, 0.0, 0.0>
	matrix < 1, 0, 0, 0, 1, -0.5, 0, 0, 1, 0, 0, 0 >	//shears camera
	rotate x*30
}

light_source{ <-100,700,-400> rgb 1}
light_source{ <-200, 700,-400> rgb 1}

#declare MG=10;

#declare H=1.0;
#declare Lac=2.0;
#declare Octs=5;
#declare Offset=0.0;


#declare T = 0; // '1/f'
#declare F0 = function {"heteroMF", <H, Lac, Octs, Offset, T> }
isosurface{
	function{y-F0(x,0,z)}
//	function{.5-F0(x,y,z)}
	eval
	max_gradient MG
	contained_by{box{<-2, -2, -4>, <2, 2, 8>}}
	pigment {Brown}	
	translate x*-4.5
}
text {
	ttf "arial.ttf",
	"1/f"
	0.2, <0.0, 0.0, 0.0>
	align_center
	texture { pigment { rgb <0.976471, 0.890196, 0.207843> } }
	scale 0.7
	translate <-4.5, -1.5, -4.2>
	no_shadow
}
text {
	ttf "arial.ttf",
	"T = 0"
	0.15, <0.0, 0.0, 0.0>
	align_center
	texture { pigment { Brown } }
	translate <-4.5, -3.0, -4.2>
}


#declare T = 1; // 'hetero mf'
#declare F1 = function {"heteroMF", <H, Lac, Octs, Offset, T> }
isosurface{
	function{y-F1(x,0,z)}
//	function{.5-F0(x,y,z)}
	eval
	max_gradient MG
	contained_by{box{<-2, -2, -4>, <2, 2, 8>}}
	pigment {Brown}	
}
text {
	ttf "arial.ttf",
	"hetero mf"
	0.2, <0.0, 0.0, 0.0>
	align_center
	texture { pigment { rgb <0.976471, 0.890196, 0.207843> } }
	scale 0.7
	translate <0, -1.5, -4.2>
	no_shadow
}
text {
	ttf "arial.ttf",
	"T = 1"
	0.15, <0.0, 0.0, 0.0>
	align_center
	texture { pigment { Brown } }
	translate <0, -3.0, -4.2>
}

#declare T = 2; // 'hybrid mf'
#declare F2 = function {"heteroMF", <H, Lac, Octs, Offset, T> }
isosurface{
	function{y-F2(x,0,z)}
//	function{.5-F2(x,y,z)}
	eval
	max_gradient MG
	contained_by{box{<-2, -2, -4>, <2, 2, 8>}}
	pigment {Brown}	
	translate x*4.5
}	
text {
	ttf "arial.ttf",
	"hybrid mf"
	0.2, <0.0, 0.0, 0.0>
	align_center
	texture { pigment { rgb <0.976471, 0.890196, 0.207843> } }
	scale 0.7
	translate <4.5, -1.5, -4.2>
	no_shadow
}
text {
	ttf "arial.ttf",
	"T = 2"
	0.15, <0.0, 0.0, 0.0>
	align_center
	texture { pigment { Brown } }
	translate <4.5, -3.0, -4.2>
}

background {color SkyBlue}