// Persistence of Vision Ray Tracer Scene Description File
//
//     File Name: reflector.pov
//       Version: MegaPOV 0.4
//   Description: photons media and mirrors
//  Date Started: 24 MAR 00
// Date Finished: 06 APR 00
//        Author: Eric L. Freeman
//   Render Size: 
//            AA: 
//   Miscelanous: Possible v.0.5 Demo

// SCENE SET-UP
#version unofficial MegaPov 0.4;

$ TextureQ = 1; // 0=low qual texture,     1=hi qual texture
$PhotonsOn = 1; // 0=no photons/media,     1=photons/media
$ AreaLite = 1; // 0=point lites,          1=area lites
$   CamNum = 2; // 1=straight-on,          2=angle
$   Loader = 1; // 0=make/save photon map, 1=load photon map

$MediaOn = PhotonsOn;
#if (PhotonsOn) $TargetNum = 1; #end
global_settings {
  max_trace_level 167
  #if (PhotonsOn)
    photons {
      count 4000
      gather 20, 100
      max_trace_level 167
      autostop 0
      jitter 0.4
      expand_thresholds 0.2, 40
      #if (MediaOn) media 100 #end
      //#if (Loader) load_file "reflector.ph"
      //#else save_file "reflector.ph" #end
    }
  #end //photonson
} //global_settings

#include "colors.inc"
$LaserLiteColor = Maroon*15.3;
$   MediaFactor = 0.00125;
$       RoomPig = rgb <0.4219, 0.4805, 0.5430>*1.4;
$    MachinePig = rgb <0.60, 0.30, 0.15>;
$    CeilingPig = rgb <1.0000, 0.9800, 0.8430>*1.5;

$      ColorOne = rgb <0.5430, 0.0000, 0.5430>;
$      ColorTwo = rgb <1.0000, 0.9180, 0.8008>*1.5;
$       CheckSc = 6;
$FloorPig = pigment {
  checker
  pigment {
    checker
    pigment {color ColorOne}
    pigment {color ColorTwo}
    scale sqrt(2)/2
    rotate y*45
    translate z/2
  }
  pigment {color ColorTwo}
}

$HoleRad = 1.5;
$MirrorTh = 1.6;
$MirrorGap = 13.5;
$MirrorRad = HoleRad*1.95;
$MirrorStretch = sqrt(2);
$MirrorMat = material {
  texture {
    pigment {White}
    finish {
      ambient 0
      diffuse 0
      reflection 1
      brilliance 6
      metallic
      reflect_metallic
    }
  }
} //mirrormat

#if (TextureQ)
  $Amber = 0.125;
  $RoomMat = material {
    texture {
      pigment {RoomPig}
      finish {
        ambient 0.20
        brilliance 2
        diffuse 0.3
        metallic
        reflect_metallic
        blinn 0.5 facets 0.48
        reflection 0.045
      } //finish
    } //texture
    interior {ior 20}
  } //roommat
  $FloorMat = material {
    texture {
      pigment {FloorPig scale CheckSc}
      finish {
        ambient 0.20
        brilliance 2
        diffuse 0.3
        metallic
        reflect_metallic
        blinn 2.0 facets 0.28
        reflection 0.15
      } //finish
    } //texture
    interior {ior 20}
  } //floormat
  $CeilingMat = material {
    texture {
      pigment {CeilingPig}
      finish {
        ambient 0.20
        brilliance 2
        diffuse 0.3
        metallic
        reflect_metallic
        blinn 0.5 facets 0.48
        reflection 0.045
      } //finish
    } //texture
    interior {ior 20}
  } //ceilingmat
  $MachineMat = material {
    texture {
      pigment {MachinePig}
      finish {
        ambient 0.20
        brilliance 3
        diffuse 0.4
        metallic
        reflect_metallic
        blinn 2.3 facets 0.24
        reflection 0.4
      } //finish
    } //texture
    interior {ior 20}
  } //machinemat
#else
  $RoomMat = material {texture {pigment {RoomPig}}}
  $FloorMat = material {texture {pigment {RoomPig}}}
  $CeilingMat = material {texture {pigment {CeilingPig}}}
  $MachineMat = material {texture {pigment {MachinePig}}}
#end //if textureq

$MainLiteTrans = <999900,0,0>;

// THE ROOM
// room variables
$RoomX1 = 35;
$RoomX2 = 90;
$RoomY = 30;
$RoomZ1 = -72;
$RoomZ2 = 30;
// the room
$TheRoom = union {
  box { // the floor
    <-RoomX1,-RoomY-0.0001,RoomZ1>,
    <RoomX2,-RoomY,RoomZ2>
    material {FloorMat}
  }
  box { // the ceiling
    <-RoomX1,RoomY,RoomZ1>,
    <RoomX2,RoomY+0.0001,RoomZ2>
    material {CeilingMat}
  }
  difference {
    box { // room box
      <-RoomX1-0.1,-RoomY-0.1,RoomZ1+0.1>,
      <(RoomX2)+1.1,RoomY+0.1,RoomZ2+0.1>
    }
    box { // room cut-out
      <-RoomX1,-RoomY-0.0001,RoomZ1>,
      <RoomX2,RoomY+0.0001,RoomZ2>
    }
    cylinder { // laser hole
      <RoomX2-0.2,0,0>,
      <RoomX2+1.2,0,0>
      HoleRad
    }
    material {RoomMat}
  }
} //theroom
// MEDIA BOX
#if (MediaOn)
  box {
    <-RoomX1+0.001,-RoomY+0.001,-HoleRad*2>,
    <999990,RoomY-0.001,HoleRad*2>
    pigment {rgbf 1.0}
    hollow
    interior {
      ior 1
      media {
        intervals 3        //10
        samples 1, 1       //1,1
        confidence 0.995   //higher=better  0.9
        variance 1/256   //lower=better   1/128
        scattering {
          1, //1-5
          LaserLiteColor*MediaFactor
          extinction 0
        }
      } //media
    } //interior
  } //media box
#end //if mediaon

//  MIRROR
#macro BuildMirror (StemLen)
  //variables
  $MirrorTh = 1.6;
  $MirrorRad = HoleRad*1.95;
  $MountRad = HoleRad*3.6;
  $MirrorStretch = sqrt(2);
  $MirrorMat = material {
    texture {
      pigment {White}
      finish {
        ambient 0
        diffuse 0
        reflection 1
        brilliance 6
        metallic
        reflect_metallic
      } //finish
    } //texture
  } //mirrormat
  // textures
  $MirrorUnit = cylinder { //mirror surface
    <-MirrorTh*0.5,0,0>,
    <0,0,0>
    MirrorRad
    scale <1,MirrorStretch,1>
    material {MirrorMat}
    #if (PhotonsOn)
      photons {
        target TargetNum
        refraction off
        reflection on
      }
    #end //if photonson
    rotate z*45
    translate <0,StemLen,0>
  }
  $MirrorFrame = difference { // rim
    cylinder {
      <-MirrorTh,0,0>,
      <0,0,0>
      MirrorRad+(MirrorTh*0.75)
    }
    cylinder {
      <-MirrorTh*0.51,0,0>,
      <0.01,0,0>
      MirrorRad+0.00001
    }
    scale <1,MirrorStretch,1>
    rotate z*45
    translate <0,StemLen,0>
  } //mirrorframe
  $Stand = difference {
    cylinder {
      <0,0.0001,0>,
      <0,StemLen+MirrorRad,0>
      MirrorRad*0.35
    }
    box {
      <-MirrorRad*4,-0.001,-MirrorRad*4>,
      <MirrorRad*4,MirrorRad*8,MirrorRad*4>
      rotate z*-45
      translate <0,StemLen,0>
    }
  } //stand
  $Mount = cylinder {
    <0,0.1,0>,
    <0,MirrorTh+0.1,0>
    MountRad
  }
  $FrameUnit = union {
    object {MirrorFrame}
    object {Stand}
    object {Mount}
    material {MachineMat}
  }

  $AMirror = union {
    object {MirrorUnit}
    object {FrameUnit}
  }
#end //macro buildmirror

// mirror one
$MirrorX = MirrorGap*1.5;
$MirrorY = RoomY;
$MirrorZ = 0;
BuildMirror (MirrorY)
$MirrorOne = object {
  AMirror
  translate <MirrorX,-RoomY,MirrorZ>
}

// mirror two
$MirrorX = MirrorX;
$MirrorY = 12;
$MirrorZ = MirrorZ;
BuildMirror (MirrorY)
$MirrorTwo = object {
  AMirror
  rotate x*180
  rotate y*180
  translate <MirrorX,RoomY,MirrorZ>
}

$Mover = 20;
// mirror three
$MirrorX = MirrorX-Mover;
$MirrorY = MirrorY;
$MirrorZ = MirrorZ;
BuildMirror (MirrorY)
$MirrorThree = object {
  AMirror
  rotate x*180
  translate <MirrorX,RoomY,MirrorZ>
}

// mirror four
$MirrorX = MirrorX;
$MirrorY = MirrorY;
$MirrorZ = MirrorZ;
BuildMirror (MirrorY)
$MirrorFour = object {
  AMirror
  rotate y*180
  translate <MirrorX,-RoomY,MirrorZ>
}

// mirror five
$MirrorX = MirrorX-Mover;
$MirrorY = MirrorY;
$MirrorZ = MirrorZ;
BuildMirror (MirrorY)
$MirrorFive = object {
  AMirror
  translate <MirrorX,-RoomY,MirrorZ>
}

// mirror six
$MirrorX = MirrorX;
$MirrorY = 29;
$MirrorZ = MirrorZ;
BuildMirror (MirrorY)
$MirrorSix = object {
  AMirror
  rotate x*180
  rotate y*180
  translate <MirrorX,RoomY,MirrorZ>
}

$Catcher = object {
  Mount
  material {MachineMat}
  rotate z*-90
  translate <-RoomX1,RoomY-MirrorY,0>
}

// LASER GUN
$LaserX1 = 40;
$LaserX2 = LaserX1+40;
$HandleX1 = LaserX1+25;
$HandleX2 = LaserX1+27;
$HandleAngle = 50;
$BarrelRing = union {
  cylinder {
    <LaserX1+2,0,0>,
    <LaserX1+3,0,0>
    HoleRad*2
  }
  torus {
    HoleRad*2, 0.5
    sturm
    rotate x*90
    rotate y*90
    translate <LaserX1+2.5,0,0>
  }
} //barrelring
$LaserGun = union {
  difference {
    union {
      cylinder {
        <LaserX1,0,0>,
        <LaserX2,0,0>
        HoleRad*1.6
      }
      torus {
        HoleRad*1.3, HoleRad*0.3
        sturm
        rotate z*90
        translate <LaserX1,0,0>
      }
      object {BarrelRing}
      object {BarrelRing translate <4,0,0>}
      object {BarrelRing translate <8,0,0>}
      sphere {<LaserX1+20,0,0>, HoleRad*4} // scuba tank
      difference {
        cylinder { // scuba tank
          <LaserX1+20,0,0>,
          <LaserX2,0,0>
          HoleRad*4
        }
        difference { // handle cut-out
          cylinder {
            <HandleX1,0,0>,
            <HandleX2,0,0>
            HoleRad*4.1
          }
          cylinder {
            <HandleX1-0.1,0,0>,
            <HandleX2+0.1,0,0>
            HoleRad*2
          }
          box {
            <HandleX1-0.1,0,0,>,
            <HandleX2+0.1,HoleRad*6,HoleRad*6>
            rotate x*HandleAngle
          }
          box {
            <HandleX1-0.1,0,0,>,
            <HandleX2+0.1,HoleRad*6,-HoleRad*6>
            rotate x*-HandleAngle
          }
        }
      }
      cylinder { // handle stick
        <(HandleX1+HandleX2)/2,0,0>,
        <(HandleX1+HandleX2)/2,HoleRad*7,0>
        (HandleX2-HandleX1)/2
        rotate x*-HandleAngle
      }
      difference { // stand
        box {
          <LaserX1+20,-RoomY,-0.6>,
          <LaserX2,0,0.6>
        }
        cylinder {
          <LaserX1+4,-RoomY/2,-0.7>,
          <LaserX1+4,-RoomY/2,0.7>
          20
        }
      }
      box { // base
        <LaserX1+17,-RoomY+0.1,-3>,
        <LaserX2,-RoomY+3,3>
      }
    }
    cylinder {
      <LaserX1-0.1,0,0>,
      <LaserX2+0.1,0,0>
      HoleRad
    }
    material {MachineMat}
  }
  text {
    ttf "arial.ttf" "ACME"
    1, 0
    align_center
    scale 4.5
    pigment {White}
    translate <72.5,-12,-0.7>
  }
  text {
    ttf
    "arial.ttf" "Laser Co."
    1, 0
    align_center
    scale 3.2
    pigment {White}
    translate <72.5,-16,-0.7>
  }
  union { // handle tip
    cylinder {
      <(HandleX1+HandleX2)/2,HoleRad*7,0>,
      <(HandleX1+HandleX2)/2,HoleRad*8.5,0>
      (HandleX2-HandleX1)*0.7
    }
    sphere {
      <(HandleX1+HandleX2)/2,HoleRad*8.5,0>,
      (HandleX2-HandleX1)*0.7
    }
    material {
      texture {pigment {rgb <1.0000, 0.1875, 0.1875>}}
      interior {ior 20}
    }
    rotate x*-HandleAngle
  }
} //lasergun

// camera variables
#switch (CamNum)
  #case (1)
    $ CamPosX = 21;
    $ CamPosY = 0;
    $ CamPosZ = -RoomZ-14;
    $CamLookX = CamPosX;
    $CamLookY = 0;
    $CamLookZ = 0;
//    $CamAngle = 70;
  #break
  #case (2)
    $ CamPosX = 31;
    $ CamPosY = 10;
    $ CamPosZ = RoomZ1-13;
    $CamLookX = CamPosX-9.24;
    $CamLookY = 0;
    $CamLookZ = 0;
    $CamAngle = 69.5;
  #break
#end
// camera
#$ CamPos = <CamPosX,CamPosY,CamPosZ>;
#$CamLook = <CamLookX,CamLookY,CamLookZ>;
camera {
  location CamPos
  look_at CamLook
  angle CamAngle
}

// LIGHTS
// secondary lite
#switch (CamNum)
  #case (1)
    light_source {
      CamPos, White*0.37
      media_interaction off
      photons {
        refraction off
        reflection on
      }
    }
  #break
  #case (2)
    $LiteZ = -45;
    $ASize = -LiteZ*0.12;
    $ANum = 4;
    light_source { // left lite
      0, White*0.3
      #if (AreaLite)
        area_light
        <ASize,0,0> <0,ASize,0>
        ANum,ANum
        adaptive 4          // 0,1,2,3... 
        jitter
      #end
      circular
      media_interaction off
      photons {
        refraction off
        reflection on
      }
      translate <0,0,LiteZ>
      rotate x*05
      rotate y*35
    }
    light_source { // rite lite
      0, White*0.6
      #if (AreaLite)
        area_light
        <ASize,0,0> <0,ASize,0>
        ANum,ANum
        adaptive 4          // 0,1,2,3... 
        jitter
      #end
      circular
      media_interaction off
      photons {
        refraction off
        reflection on
      }
      translate <0,0,LiteZ>
      rotate x*14
      rotate y*-20
      translate <34,0,0>
    }
  #break
#end
// laser lite
light_source {
  MainLiteTrans, LaserLiteColor
  media_attenuation on
  photons {
    refraction off
    reflection on
  }
}

// PLACE OBJECTS
background {RoomPig*0.25}

object {TheRoom}
object {MirrorOne}
object {MirrorTwo}
object {MirrorThree}
object {MirrorFour}
object {MirrorFive}
object {MirrorSix}
object {Catcher}
object {LaserGun}
