//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

camera {
  location <0,-5, -10>
  direction 2*z
  look_at <0,0,0>
  }

global_settings {
  string_encoding "ISO8859_1"
}

light_source {<-20,20,-20> rgb 1}
light_source {<7,-5,-10> rgb 1}
light_source {<10,-10,10> rgb 1}

sphere_sweep {
  linear_sphere_sweep,
  6,
  <-1,1.5,0>, .2
  <1,1.5,0>, .2
  <2,.5,0>, .2
  <0,-1.5,0>, .2
  <-2,.5,0>, .2
  <-1,1.5,0>,  .2

  texture {
    pigment {
      color rgb <1,1,0>
    }
    finish {
      diffuse .5
      specular .5 roughness .001
    }
  }
}


// create a TrueType text shape
#declare myP = text {
  ttf "times.ttf", "P", .4, 0
  scale <.7,.7,1>
  texture {pigment {color rgb <1,1,0>}}
}


#declare myO = text {
  ttf "times.ttf", "O", .4, 0
  scale <1.5,1.5,1>
  texture {pigment {color rgb <1,1,0>}}
}
#declare myV = text {
  ttf "times.ttf", "V", .4, 0
  scale <4.5,2,1>
  texture {pigment {color rgb <1,1,0>}}
}

object {myP translate .5*y-(max_extent(myP).x/2)*x
//                          +(max_extent(myP).y/2)*y
                          -(max_extent(myO).y/2)*y
                          -(max_extent(myP).z/2)*z}
object {myO translate .5*y-max_extent(myO)/2}
object {myV translate -.25*y-max_extent(myV)/2}

#declare superpatch = text {
  ttf "arial.ttf", "SUPERPATCH", 15, 0
  texture {
    pigment {
      gradient z
      color_map {
        [0 rgb 1]
        [.01 rgb <.5,.5,1>]
        [.1 rgb <.5,.5,1>]
        [1 rgb 0]
      }
      scale <1,1,15>
    }
  }
}

object {superpatch translate 2*y-(max_extent(superpatch).x/2)*x}

#declare text1 = text {
  ttf "arial.ttf", "This is an unofficial build of POV-Ray 3.1e", .2, 0
  scale .2
}
#declare text2 = text {
  ttf "arial.ttf", "by Ronald L. Parker (parkerr@fwi.com)", .2, 0
  scale .2
}
#declare text3 = text {
  ttf "arial.ttf", concat("based on POV-Ray for Windows v3.1a ",chr(169)," 1999 POV-Team"), .2, 0
  scale .2
}
#declare text4 = text {
  ttf "arial.ttf", concat("and POV-Ray for DOS v3.1e ",chr(169)," 1999 POV-Team"), .2, 0
  scale .2
}
#declare text5 = text {
  ttf "arial.ttf", "The POV-Team will NOT provide support for this version.", .2, 0
  scale .2
}

union {
  object {text1 translate .8*y-x*max_extent(text1).x/2}
  object {text2 translate .6*y-x*max_extent(text2).x/2}
  object {text3 translate .4*y-x*max_extent(text3).x/2}
  object {text4 translate .2*y-x*max_extent(text4).x/2}
  object {text5 translate -x*max_extent(text5).x/2}

  texture {pigment {color rgb 1}}
  translate -2.7*y
}

intersection {
  height_field {
    pattern 200,200 {
      bozo
      color_map {
        [0 rgb 0]
        [1 rgb 1]
      }
      scale .1
    }
    rotate -90*x
    scale <4,4,.15>
    translate <-2,-2,0>
    smooth
  }
  plane {z,.1}
  plane {y+x,2.5/sqrt(2)}
  plane {y-x,2.5/sqrt(2)}
  plane {x-y,1.5/sqrt(2)}
  plane {-x-y,1.5/sqrt(2)}
  plane {y,1.5}

  texture {
    pigment {
      color red 1
    }
    finish {
      diffuse .5
      specular .5 roughness .001
    }
  }
}
