//	Persistence of Vision Ray Tracer Scene Description File
//	File: var_refl.pov
//	Date: 11-05-2000 updated 26-09-2000
//	Author: Ren Smellenbergh
// Demo: showing one of the most probable uses of angle dependent reflection:
//            reflective water

#version unofficial MegaPov 0.5;

camera {
	location <0.0, 0.0, -50>
	up y*image_height right x*image_width
	look_at <0.0, 0.0, 0.0>
	angle 50
	rotate x*20
}

light_source { <-1000, 300, -850> rgb 1.2 }
light_source { <0, 0, -50> rgb 0.2 rotate x*20 shadowless}	

//*********** Water surface with angle-dependent reflection ************
plane {
	<0.0, 1.0, 0.0>, 0
	texture{
		pigment { rgbft <1.0, 1.0, 1.2, 0.4, 0.7> }
		normal {
			average
			normal_map {
				[ 40 ripples 0.06 turbulence 0.5 scale 0.45 ]
				[ 30 granite 0.8 scale <5, 0.3, 5> ]
			}
		}
		finish {
			ambient 0.05
			brilliance 1
			diffuse 0.2
			phong 1.0 phong_size 600
			reflection_type 0
			reflection_min 0.0
			reflection_max 1.4
			reflection_falloff 0.85
			conserve_energy
	   }
	}
	interior {ior 1.3}
}

//******************** START OBJECT SPLINE ********************
#declare SplineScale = 40;
#declare Stretch = 6;
#declare POINTS = array [6] 
{
	<0.95968, 0.01210* Stretch > * SplineScale,
	<0.92742, 0.06452* Stretch > * SplineScale,
	<0.32258, 0.25403* Stretch > * SplineScale,
	<0.58871, 0.66935* Stretch > * SplineScale,
	<0.10887, 0.93145* Stretch > * SplineScale,
	<0.15323, 0.61694* Stretch > * SplineScale
}

#declare Numbers = 5;
#declare Segmts = dimension_size (POINTS,1)-3;
#declare Copies =  ((Numbers)*Segmts)+1;	
#declare Pass = 0;
#while ( Pass < Segmts)
	#local Va = 1 + Pass;
	#local To = 0 + (1/Numbers);
	#local LoopEnd = 1.00000001;
	#while (To < LoopEnd)
	union {
		cylinder {
			<0, 0, 40>, <0, 0, -9>, 0.6
			texture {
				pigment {
					agate
					agate_turb 0.8
					color_map {
						[ 0.0 rgb <0.923308, 0.882429, 0.816678> ]
						[ 0.12 rgb <0.915007, 0.866819, 0.744991> ]
						[ 0.23 rgb <0.929503, 0.852628, 0.770474> ]
						[ 0.5 rgb <0.920699, 0.861540, 0.819287> ]
						[ 0.7 rgb <0.962203, 0.922469, 0.897780> ]
						[ 1.0 rgb <0.926406, 0.808301, 0.753582> ]
					}
					scallop_wave
					scale 0.1
				}
				normal {
					wood 0.7
					frequency 4
					warp { turbulence <0.3, 0.4, 0.3> }
				}
				finish { ambient 0.05 }
			}
			rotate y*20
			#local As = -0.5 *POINTS [Va-1].x + 1.5 *POINTS [Va].x - 1.5 *POINTS [Va+1].x + 0.5 *POINTS [Va+2].x;
			#local Bs = POINTS [Va-1].x - 2.5 *POINTS [Va].x + 2.0 *POINTS [Va+1].x - 0.5 *POINTS [Va+2].x;
			#declare Cs = -0.5 * POINTS [Va-1].x + 0.5 *POINTS [Va+1].x;
			#declare Ds = POINTS [Va].x;
			#declare As2 = -0.5 *POINTS [Va-1].y + 1.5 *POINTS [Va].y - 1.5 *POINTS [Va+1].y + 0.5 *POINTS [Va+2].y;
			#declare Bs2 = POINTS [Va-1].y - 2.5 *POINTS [Va].y + 2.0 *POINTS [Va+1].y - 0.5 *POINTS [Va+2].y;
			#declare Cs2 = -0.5 *POINTS [Va-1].y + 0.5 *POINTS [Va+1].y;
			#declare Ds2 = POINTS [Va].y;
				#declare Tu = As*To*To*To+Bs*To*To+Cs*To+Ds;
				#declare Tv = As2*To*To*To+Bs2*To*To+Cs2*To+Ds2;
				#declare Tw = 5.8;
			} //object
			sphere {
				<0.0, 0.0, -10.1>, 1.5
				texture {
					pigment { rgb 1.0 }
					finish {
						phong 1.0 phong_size 600
						ambient 0.0
						reflection_type 0
						reflection_min 0.8
						reflection_max 0.15
						reflection_falloff 1
						diffuse 0.0
					}
				}
				rotate y*20
			}
		translate <Tu, Tv, Tw> 
		rotate x*90	//flip to XZ-plane
		translate <-24, 0, -40>
	}
	#declare To = To +(1/Numbers);
	#end	//while To < LoopEnd
	#declare Pass = Pass + 1;
#end  //while  Pass < Segmts
//******************** END OBJECT SPLINE ********************

//************** Sandy bottom underwather *******************
plane {
	<0.0, 1.0, 0.0>, -10
	texture {
		pigment  {
			crackle
			color_map {
				[ 0.0 rgb < 0.98, 0.88, 0.78 > ]
				[ 0.8 rgb < 0.925002, 0.829969, 0.774975 > ]
				[ 1.0 rgb < 0.895003, 0.658137, 0.404974 > ]
			}
			ramp_wave
			scale 0.15
		}
		normal  {
			marble //< 0.0, 0.0, 1.0 >
			0.8 //amount
			slope_map {
				[ 0.0,  < 0.0,  0 > ]
				[ 0.74444,  < 0.14444,  -0.22222 > ]
				[ 1,  < -0.00227,  -0.44655 > ]
			}
			frequency 1.7
			turbulence <0.4, 0.5, 0.3>
			scale <5, 5, 5>
		}
		finish {
			diffuse 0.7
			ambient 0.3
			roughness 0.05
			crand 0.08
		}
		rotate y*99
	}
	rotate x*3
}

//******************* Sky to reflect in water *********************
sky_sphere {
	pigment { rgb <0.258, 0.258, 0.435> }
    pigment {
        bozo
        turbulence 1.5
        octaves 10 omega .5 lambda 2.5
        color_map {
            [0.0, 0.5 color rgbf<.75, .75, .75, 0> color rgbf<.9, .9, .9, .9> ]
            [0.5, 0.7 color rgbf<.9, .9, .9, .9> color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1> color rgbf<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
    pigment {
        bozo
        turbulence 0.6
        octaves 10 omega .5 lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<.75, .75, .75, 0> color rgbf<.9, .9, .9, .9> ]
            [0.4, 0.7 color rgbf<.9, .9, .9, .9> color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1> color rgbf<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
    pigment {
        bozo
        turbulence 0.8
        octaves 10 omega .5 lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<.75, .75, .75, 0> color rgbf<.9, .9, .9, .9> ]
            [0.4, 0.6 color rgbf<.9, .9, .9, .9> color rgbf<1, 1, 1, 1> ]
            [0.6, 1.0 color rgbf<1, 1, 1, 1> color rgbf<1, 1, 1, 1> ]
        }
    scale <1, 0.3, 10>
    }
	scale 2
	rotate y*30
}
