//	Persistence of Vision Ray Tracer Scene Description File
//	File: bloblattice.pov
//	Date: 26-09-2000
//	Author: Smellenbergh Ren
//	Demo: cylinder-components in blob pattern

#version unofficial MegaPov 0.6;

camera {
	location <0.0, 0.0, -42>
	up y*image_height right x*image_width
	look_at <0.0, 0.0, 0.0>
	angle 35
	rotate x*15
}

#declare Func = 0;
#declare falloffAmt = 2;

box {< -10, -10, 0>, < 10, 10, 1>
	texture {
		pigment {
			blob {
				threshold 0
				max_density 1.0
				#declare C = 0;
				#declare Copies = 10;
				#while ( C < Copies)
					cylinder {
						<0, -8, 0>, <0, 8, 0>, 0.5, strength 0.6
						density_function Func, falloffAmt
						translate x * (-8 + (C * (8 - (-8))/(Copies -1)))
					} //cylinder-component
					#declare C = C +1;
				#end  //while (C < Copies)
				#declare C2 = 0;
				#while ( C2 < Copies)
					cylinder {
						<-8, 0, 0>, <8, 0, 0>, 0.5, strength 0.6
						density_function Func, falloffAmt
						translate y * (-8 + (C2 * (8 - (-8))/(Copies -1)))
					} //cylinder-component
					#declare C2 = C2 +1;
				#end  //while (C2 < Copies)
			} //blob-pattern
			ramp_wave
			color_map {
				[0.00 rgb <1, 0, 0>]
				[0.33 rgb <0, 0, 1>]
				[0.66 rgb <1, 1, 0>]
				[1.00 rgb <1, 0, 0>]
			}
		} //pigment
		finish {ambient 1}
	} //texture
} //object-box
