//	Persistence of Vision Ray Tracer Scene Description File
// pigment_pattern demo

#version unofficial MegaPov 0.5;

//#default { texture { pigment { color rgb < 1, 0, 0 > } finish { phong 0.8 phong_size 450 } } }

camera {
	location <0.0, 0.0, -2.5>
	up y*image_height right x*image_width
	angle 40*1.25
	look_at <0.0, 0.0, 0.0>
}

light_source {
	<10000, 6000, -8000>
	rgb <1.0, 1.0, 1.0>
	parallel point_at <0, 0, 0>
}

// standard turbulated pigment
box {
	<-0.8, -0.5, -0.25>, <0.8, 0.0, 0.25>
	texture {
		pigment {
			checker pigment { radial frequency 12}, pigment { gradient x scale 0.05 }
			translate 0.5 scale 10 warp{turbulence 2} scale 0.05
		}
		scale 0.5
		translate y*0.33
	}
	rotate x*-90
	translate y*0.6
}
text {
	ttf "crystal",
	"standard"
	0.2, <0.0, 0.0, 0.0>
	align_left
	no_shadow
	texture { pigment { rgb <1.0, 1.0, 1.0> } finish { ambient 0.8 }}
	scale 0.1
	translate <-0.72, 0.37, -0.1>
}

// turbulation of the child pigments (radial & gradient) are reset with "reset_children"
box {
	<-0.8, -0.5, -0.25>, <0.8, 0.0, 0.25>
	texture {
		pigment {
			checker pigment { radial frequency 12}, pigment { gradient x scale 0.05 }
			translate 0.5 scale 10 warp{turbulence 2} scale 0.05
			warp {reset_children }
		}
		scale 0.5
		translate y*0.33
	}
	rotate x*-90
}
text {
	ttf "crystal",
	"reset_children"
	0.2, <0.0, 0.0, 0.0>
	align_left
	no_shadow
	texture { pigment { rgb <1.0, 1.0, 1.0> } finish { ambient 0.8 }}
	scale 0.1
	translate <-0.72, -0.22, -0.1>
}

// only the checker pattern has turbulence by using the "pigment_pattern"
// each of the children patterns can be controlled individually
box {
  <-0.8, -0.5, -0.25>, <0.8, 0.0, 0.25>
    texture {
      pigment {
        pigment_pattern {
          checker   0.0, 1.0
          translate 0.5 scale 10 warp{turbulence 2} scale 0.05
       }
       pigment_map {
         [0.0 radial frequency 12
//           translate 0.5 scale 10 warp{turbulence 2} scale 0.05	// uncomment to get turbulence 
         ]
         [1.0 gradient x scale 0.05
//         translate 0.5 scale 10 warp{turbulence 2} scale 0.05	// uncomment to get turbulence 
         ]
      }
    }
    scale 0.5
    translate y*0.33
  }
  rotate x*-90
  translate y*-0.6
}
text {
	ttf "crystal",
	"pigment_pattern"
	0.2, <0.0, 0.0, 0.0>
	align_left
	no_shadow
	texture { pigment { rgb <1.0, 1.0, 1.0> } finish { ambient 0.8 }}
	scale 0.1
	translate <-0.72, -0.78, -0.1>
}

