//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.6;

/*

UV Mapping Demo Scene
Created September 28 2000

This contains a bicubic_patch that supports uv mapping.

It uses the image "congo4.png' which can be found in this folder.
Change the line below to read "#declare USE_UV_MAPPING=no;" to see what
the difference is without uv mapping.

Change the line "#declare SET_VECTORS =1;"  with another number to see
what happens when the uv_vectors pick other points on the image.

*/

#declare USE_UV_MAPPING=yes;
#declare SET_VECTORS =1;	//1= four corners:
                                            //2= points on the middle of each side
                                            //3= left half of the image
	
camera {  //  Camera StdCam
	location  <     -4.042,      -8.503,       9.486>
	sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
	up        <        0.0,         0.0,         1.0> // Where Z is up
	right     <    1.33333,         0.0,         0.0> // Aspect ratio
	look_at   0
	angle 50
}

light_source {  <0.000, -20.000, 20.000> rgb 1}

// background sphere 
sphere {
	<0,0,0>,1
   material {   
      texture {      
         pigment {
            gradient z
            color_map {
               [ 0.0     rgbft <0.0, 0.0, 0.501961, 0.0, 0.0> ]
               [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            }
         }      
         finish { ambient 1.0  diffuse 0.0 }
      }
   }
	scale 36.904232
	hollow
}

bicubic_patch {
	type 2
	accuracy 0.001
	<-3, 3, -1>, <-1, 3, -1>, <1, 3, -1>, <3, 3, -1>,
	<-3, 1, -1>, <-1, 1, -1>, <1, 1, -1>, <3, 1, -1>,
	<-3, -1, -1>, <-1, -1, -1>, <1, -1, -1>, <3, -1, -1>,
	<-3, -3, -1>, <-1, -3, -1>, <1, -3, -1>, <3, -3, -1>
	
	#if (SET_VECTORS =1) uv_vectors <0, 1>,<1, 1>, <1, 0>, <0, 0> #end
	#if (SET_VECTORS =2) uv_vectors <0, 0.5>,<0.5, 1>, <1, 0.5>, <0.5, 0> #end
	#if (SET_VECTORS =3) uv_vectors <0, 0>,<0, 1>, <0.5, 1>, <0.5, 0> #end
	
	scale .2
	#if (USE_UV_MAPPING) uv_mapping #end
	texture {
		pigment { 
			image_map { png "congo4.png" }
			rotate 90*z
		}
	}
	scale 5
}

