//	Persistence of Vision Ray Tracer Scene Description File
//	File: uv_mapping.pov
//	Date: 15/11/99
//	Demo showing uv_mapping
	
#version unofficial MegaPov 0.6;

camera {
	location <0.0,3.5, -7>
	angle 40
	look_at <0.0, 0.0, -0.5>
}

//light_source { < 30, 60, -60 > rgb 1.2 }
light_source {
	<-500, 2000, -1000>
	rgb <1.0, 1.0, 1.0>
}

background { rgb < 0.874601, 0.905394, 0.896666 > }

#declare Offset = 4.2;
#declare OffsetUV = 2.8;
#declare DownUV = 1.2;

//******** BICUBIC PATCH *************
bicubic_patch  {
	type 1
	flatness 0.0 u_steps 4 v_steps 4
	<-0.25, 0.25, -0.35 >, <-0.166667,0.500000, 0.000000 >,<0.166667, 0.500000, 0.000000 >,<0.500000, 0.500000, 0.000000 >,
	<-0.500000,0.166667,0.000000 >,<-0.166667,0.166667,0.000000 >,<0.166667,0.166667,0.000000 >,<0.500000,0.166667,0.000000 >,
	<-0.500000,-0.166667,0.000000 >,<-0.166667,-0.166667, 0.000000 >,<0.166667, -0.166667,0.000000 >,<0.500000,-0.166667,0.000000 >,
	<-0.500000,-0.500000,0.000000 >,<-0.166667,-0.500000,0.000000 >,<0.166667,-0.500000,0.000000 >,<0.25,-0.25, -0.25 >
	uv_vectors  <0, 1>,<1, 1>, <1, 0>, <0, 0>
	uv_mapping
	texture {
		pigment  {
			image_map { png "congo4.png" }
		}
	}
	rotate x*90
	scale <2.5, 2.0, 2.0>
	translate <0, -DownUV, -0.5>
}

//****** *LATHE ************
lathe  {			//without uv_mapping
	quadratic_spline
	6, 
	<0.0, 0.000000 >,
	<0.00000, 0.00645>,
	<0.86452, 0.09677>,
	<0.28387, 0.35484>,
	<0.24516, 0.63871>,
	<0.00000, 1.00645>
	sturm
	texture {
		pigment  {
			gradient x
			color_map {
				[ 0.0 rgb <1.000000, 1.000000, 1.000000> ]
				[ 0.3 rgb <1.0, 1.0, 1.0> ]
				[ 0.3 rgb <1.0, 0.0, 0.0> ]
				[ 0.6 rgb <1.0, 0.0, 0.0> ]
				[ 0.6 rgb <0.211505, 0.530358, 0.728481> ]
				[ 1.0 rgb <0.211505, 0.530358, 0.728481> ]
			}
			scale <0.5, 0.5, 0.5>
		}
		finish { phong 0.8  phong_size 150 }
	}
	translate <0, -0.3, Offset>
}
lathe  {		//with uv_mapping
	quadratic_spline
	6, 
	<0.0, 0.000000>,
	<0.00000, 0.00645>,
	<0.86452, 0.09677>,
	<0.28387, 0.35484>,
	<0.24516, 0.63871>,
	<0.00000, 1.00645>
	sturm
	uv_mapping
	texture {
		pigment  {
			gradient x
			color_map {
				[ 0.0 color rgb < 1.000000, 1.000000, 1.000000 > ]
				[ 0.3 color rgb < 1.0, 1.0, 1.0 > ]
				[ 0.3 color rgb < 1.0, 0.0, 0.0 > ]
				[ 0.6 color rgb < 1.0, 0.0, 0.0 > ]
				[ 0.6 color rgb < 0.211505, 0.530358, 0.728481 > ]
				[ 1.0 color rgb < 0.211505, 0.530358, 0.728481 > ]
			}
			scale < 0.5, 0.5, 0.5 >
		}
		finish  { phong 0.8  phong_size 150 }
	}
	translate <0, -DownUV, OffsetUV>
}
//*************SPHERE *******************
sphere  {
	< 0.0, 0.0, 0.0 >, 0.5
	texture {
		pigment  {
			crackle
			color_map {
				[ 0.0 color rgb < 1.000000, 1.000000, 1.000000 > ]
				[ 0.3 color rgb < 1.0, 1.0, 1.0 > ]
				[ 0.3 color rgb < 1.0, 0.0, 0.0 > ]
				[ 0.6 color rgb < 1.0, 0.0, 0.0 > ]
				[ 0.6 color rgb < 0.211505, 0.530358, 0.728481 > ]
				[ 1.0 color rgb < 0.211505, 0.530358, 0.728481 > ]
			}
			poly_wave 0.5
			scale  0.25
		}
		finish  { phong 0.8  phong_size 150 }
	}
	translate <0, -0.3, Offset>
	rotate y*-35
}

sphere  {
	< 0.0, 0.0, 0.0 >, 0.5
	uv_mapping
	texture {
		pigment  {
			crackle
			color_map {
				[ 0.0 color rgb < 1.000000, 1.000000, 1.000000 > ]
				[ 0.3 color rgb < 1.0, 1.0, 1.0 > ]
				[ 0.3 color rgb < 1.0, 0.0, 0.0 > ]
				[ 0.6 color rgb < 1.0, 0.0, 0.0 > ]
				[ 0.6 color rgb < 0.211505, 0.530358, 0.728481 > ]
				[ 1.0 color rgb < 0.211505, 0.530358, 0.728481 > ]
			}
			poly_wave 0.5
			scale  0.25
		}
		finish  { phong 0.8  phong_size 150 }
	}
	translate <0, -DownUV, OffsetUV>
	rotate y*-35
}

//************BOX******************
box  {
	< -0.5, -0.5, -0.5 >, < 0.5, 0.5, 0.5 >
	texture {
		pigment  {
			gradient y
			color_map {
				[ 0.001 color rgb < 1.000000, 1.000000, 1.000000 > ]
				[ 0.3 color rgb < 1.0, 1.0, 1.0 > ]
				[ 0.3 color rgb < 1.0, 0.0, 0.0 > ]
				[ 0.6 color rgb < 1.0, 0.0, 0.0 > ]
				[ 0.6 color rgb < 0.211505, 0.530358, 0.728481 > ]
				[ 0.9999 color rgb < 0.211505, 0.530358, 0.728481 > ]
			}
			scale < 0.5, 0.51, 0.5 >
		}
		finish  { phong 0.8  phong_size 150 }
	}
	translate <0, -0.3, Offset>
	rotate y*35
}

box  {
	< -0.5, -0.5, -0.5 >, < 0.5, 0.5, 0.5 >
	uv_mapping
	texture {
		pigment  {
			gradient y
			color_map {
				[ 0.0 color rgb < 1.000000, 1.000000, 1.000000 > ]
				[ 0.3 color rgb < 1.0, 1.0, 1.0 > ]
				[ 0.3 color rgb < 1.0, 0.0, 0.0 > ]
				[ 0.6 color rgb < 1.0, 0.0, 0.0 > ]
				[ 0.6 color rgb < 0.211505, 0.530358, 0.728481 > ]
				[ 1.0 color rgb < 0.211505, 0.530358, 0.728481 > ]
			}
			scale < 0.5, 0.5, 0.5 >
		}
		finish  { phong 0.8  phong_size 150 }
	}
	translate <0, -DownUV, OffsetUV>
	rotate y*35
}
