
#include "stdafx.h"


///////////////////////////////////////////////////////////////////////
//
BOOL CBreezePlugin::IsValidData()
{
	if (m_pPluginData == NULL || m_pPluginData->lpData == NULL)
		{
		TRACE("invalid plugin argument\n");

		return FALSE;
		}
	return TRUE;
}

///////////////////////////////////////////////////////////////////////
//
LPPLUGINDATA CBreezePlugin::GetPluginData() 
{ 
	ASSERT( m_pPluginData );

	return m_pPluginData; 
};

///////////////////////////////////////////////////////////////////////
//
LPPIPROPERTY CBreezePlugin::GetPropertyTable( )
{
	ASSERT( m_pPropertyTable );

	return m_pPropertyTable;
}

///////////////////////////////////////////////////////////////////////
//
BOOL CBreezePlugin::SetPropertyTable( LPPIPROPERTY pPropertyTable )
{
	ASSERT( pPropertyTable );

	m_pPropertyTable = pPropertyTable;

	return TRUE;
}

///////////////////////////////////////////////////////////////////////
//
LPSTR CBreezePlugin::GetPropertyString( UINT nValue )
{
	ASSERT( m_pPropertyTable );

	return BDVAR_GETSTRING(m_pPropertyTable[nValue].varValue);
}

///////////////////////////////////////////////////////////////////////
//
UINT CBreezePlugin::GetPropertyInt( UINT nValue )
{
	ASSERT( m_pPropertyTable );

	return BDVAR_GETUINT(m_pPropertyTable[nValue].varValue);
}

///////////////////////////////////////////////////////////////////////
//
double CBreezePlugin::GetPropertyDouble( UINT nValue )
{
	ASSERT( m_pPropertyTable );

	return BDVAR_GETDOUBLE(m_pPropertyTable[nValue].varValue);
}

///////////////////////////////////////////////////////////////////////
//
BOOL CBreezePlugin::SetProperty( UINT nIndex, LPCSTR szValue )
{
	ASSERT( m_pPropertyTable );

	strcpy( BDVAR_GETSTRING(m_pPropertyTable[nIndex].varValue), szValue );

	return TRUE;
}

///////////////////////////////////////////////////////////////////////
//
BOOL CBreezePlugin::SetProperty( UINT nIndex, UINT nValue )
{
	ASSERT( m_pPropertyTable );

	BDVAR_GETUINT(m_pPropertyTable[nIndex].varValue) = nValue;

	return TRUE;
}

///////////////////////////////////////////////////////////////////////
//
BOOL CBreezePlugin::SetProperty( UINT nIndex, int nValue )
{
	ASSERT( m_pPropertyTable );

	BDVAR_GETUINT(m_pPropertyTable[nIndex].varValue) = nValue;

	return TRUE;
}

///////////////////////////////////////////////////////////////////////
//
BOOL CBreezePlugin::SetProperty( UINT nIndex, double nValue )
{
	ASSERT( m_pPropertyTable );

	BDVAR_GETDOUBLE(m_pPropertyTable[nIndex].varValue) = nValue;

	return TRUE;
}

///////////////////////////////////////////////////////////////////////
//
BOOL CBreezePlugin::IsValidObject()
{
	if (m_pPluginData == NULL || m_pPluginData->hObject == PI_ERROR)
		{
		TRACE("invalid plugin object\n");

		return FALSE;
		}
	return TRUE;
}

///////////////////////////////////////////////////////////////////////
//
LPSTR CBreezePlugin::OnGetInfo()
{
	// Return plugin name, credits, etc

	return NULL;
}

///////////////////////////////////////////////////////////////////////
//
LPSTR CBreezePlugin::OnGetFilter()
{
	// Return file filter string(s)

	return NULL;
}


///////////////////////////////////////////////////////////////////////
//
LPSTR CBreezePlugin::OnGetIcon()
{
	// Return resource identifier to plugin icon

	return NULL;
}

///////////////////////////////////////////////////////////////////////
//
BOOL CBreezePlugin::OnConfig()
{
	// Create and dispatch configuration dialog

	return FALSE;
}

///////////////////////////////////////////////////////////////////////
//
BOOL CBreezePlugin::OnSetProperty()
{
	// Handle property change events

	ASSERT( m_pPropertyTable );

	return piSetLocalPluginProperty( (LPPIPROPERTY)m_pPluginData->lpData, m_pPropertyTable );
}

///////////////////////////////////////////////////////////////////////
//
BOOL CBreezePlugin::OnSetFrame( HCADOBJECT hObject, UINT nFrame )
{
	// Called on frame changes for each animated plugin object

	return FALSE;
}

///////////////////////////////////////////////////////////////////////
//
BOOL CBreezePlugin::OnRelease( HCADOBJECT hObject )
{
	// Called on object delete or scene delete

	return FALSE;
}

///////////////////////////////////////////////////////////////////////
//
BOOL CBreezePlugin::OnData()
{
	// Called to create plugin scene object (if applicable)

	return FALSE;
}

///////////////////////////////////////////////////////////////////////
//
UINT CBreezePlugin::OnEventCommon( DWORD nOperation, LPVOID lpLocalData  )
{
	LPSTR szString = NULL;

	switch (nOperation)
		{
		/*
		case PI_GETCAPS:
			return OnGetCaps( lpCall );
			break;
		*/

		case PI_GETINFO:

			szString = OnGetInfo();

			if (szString!= NULL)
				{
				//
				// Return file filter informatoin
				//
				m_pPluginData->nDataType = PIDATA_STRING;
				m_pPluginData->nDataSize = lstrlen(szString);
				m_pPluginData->lpData    = szString;

				return TRUE;
				}
			return FALSE;
			break;

		case PI_GETFILTER:

			szString = OnGetFilter();

			if (szString!= NULL)
				{
				//
				// Return file filter informatoin
				//
				m_pPluginData->nDataType = PIDATA_STRING;
				m_pPluginData->nDataSize = lstrlen(szString);
				m_pPluginData->lpData    = szString;

				return TRUE;
				}
			return FALSE;
			break;


		case PI_GETICON:

			szString = OnGetIcon();

			if (szString!= NULL)
				{
				//
				// Return function icon string. This function should return
				// the name of a bitmap resource.
				//
				m_pPluginData->nDataType = PIDATA_HANDLE;
				m_pPluginData->nDataSize = sizeof(DWORD);
				m_pPluginData->lpData    = (LPSTR)szString;

				return TRUE;
				}
			break;

		case PI_GETDATA:

			if (IsValidData() == FALSE) 
				return FALSE;

			return OnData();
			break;

		case PI_CONFIG:
			return OnConfig();
			break;


		case PI_SETPROPERTY:

			if (IsValidData() == FALSE) 
				return FALSE;

			return OnSetProperty();
			break;

		case PI_SETFRAME:

			if (IsValidData() == FALSE || IsValidObject() == FALSE) 
				return FALSE;

			return OnSetFrame( m_pPluginData->hObject, (UINT)m_pPluginData->lpData );
			break;

		case PI_RELEASE:

			if (IsValidObject() == FALSE) 
				return FALSE;

			return OnRelease( m_pPluginData->hObject );
			break;

		default:
			return FALSE;
			break;
		}
	return FALSE;
}

///////////////////////////////////////////////////////////////////////
//
UINT CBreezePlugin::OnEvent( DWORD nOperation, LPVOID lpLocalData, LPVOID lpData  )
{
	m_pPluginData = (LPPLUGINDATA)lpData;

	if ( piLibFuncInit( nOperation, lpLocalData, lpData, PIFUNC_ADVANCED ) == FALSE )
		{
		return FALSE;
		}

	return OnEventCommon( nOperation, lpLocalData );
}

///////////////////////////////////////////////////////////////////////
//
LPSTR CBreezePlugin::GetObjectNameFromFileName( LPCSTR szFileName )
{
	static char szName[255];
	int i;

	strcpy( szName, szFileName );

	for (i=strlen(szFileName); i>0; i--)
		{
		if (szFileName[i] == '/' || szFileName[i] == '\\')
			{
			strcpy( szName, &szFileName[i+1] );

			break;
			}
		}

	for (i=0; i<strlen(szName); i++)
		{
		if (szName[i] == '.')
			{
			szName[i] = 0;
			}
		}

	return szName;
}

///////////////////////////////////////////////////////////////////////
//
HCADOBJECT CBreezePlugin::CreatePluginBaseObject( LPSTR szName, LPSTR szDescription )
{
	HCADOBJECT hObject;
	char szMsg[80];

	// This function creates a base user defined object

	hObject = piCreateObject( szName, OBJECT_USERDEFINED );

	if ( hObject == PI_ERROR)
		{
		return PI_ERROR;
		}

	//
	// Add comment
	//
	wsprintf( szMsg, "%s", szDescription );

	piSetObjectProperty( hObject, OBJPROP_EXTRA_COMMENT, piReturnBdVarPtr(szMsg));

	//
	// Add object code for POV-Ray export
	//
	// piSetObjectProperty( hObject, OBJPROP_EXTRA_USER_INLINE, piReturnBdVarPtr(szString));

	//
	// Set object plugin signature to allow plugin re-editing this object
	//
	piBind( hObject, szDescription );

	return hObject;
}

