/* ANSI-C code produced by gperf version 2.7 */
/* Command-line: gperf -j1 -CEITcot -k1-4,$ -e	 -LANSI-C -Nopsearch opcodes.gperf  */
#include "asm.h"
#include <string.h>
/* maximum key range = 220, duplicates = 0 */

#ifdef __GNUC__
__inline
#endif
static unsigned int
hash (register const char *str, register unsigned int len)
{
  static const unsigned char asso_values[] =
    {
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233,  79,  86,
       89,  55,  37,  53,  47,  14, 233, 233, 233, 233,
      233, 233, 233, 233, 233,   5,   0,   4,  45,  56,
      233,   3,  76,  42,  11, 233,   9,  69,  68,  55,
        9,   0,   0,  17,  65,   6, 233,   5,   9, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233, 233, 233, 233, 233,
      233, 233, 233, 233, 233, 233
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 4:
        hval += asso_values[(unsigned char)str[3]];
      case 3:
        hval += asso_values[(unsigned char)str[2]];
      case 2:
        hval += asso_values[(unsigned char)str[1]];
      case 1:
        hval += asso_values[(unsigned char)str[0]];
        break;
    }
  return hval + asso_values[(unsigned char)str[len - 1]];
}

#ifdef __GNUC__
__inline
#endif
const struct opcdata *
opsearch (register const char *str, register unsigned int len)
{
  enum
    {
      TOTAL_KEYWORDS = 120,
      MIN_WORD_LENGTH = 3,
      MAX_WORD_LENGTH = 6,
      MIN_HASH_VALUE = 13,
      MAX_HASH_VALUE = 232
    };

  static const struct opcdata wordlist[] =
    {
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"BRA",0x20, t_rel},
      {""},
      {"BCC",0x24, t_rel},
      {"CLR",0x2F, t_rmw},
      {""}, {""}, {""},
      {"BSR",0xAD, t_rel},
      {""}, {""}, {""},
      {"CLC",0x98, t_inh},
      {"ASR",0x27, t_rmw},
      {"SUB",0xA0, t_rmi},
      {"CLRA",0x4F, t_inh},
      {"SBC",0xA2, t_rmi},
      {"LSR",0x24, t_rmw},
      {"BPL",0x2A, t_rel},
      {"JSR",0xAD, t_rm},
      {"BCLR7",0x1F, t_dir},
      {"BRCLR7",0x0F, t_dirrel},
      {"CPX",0xA3, t_rmi},
      {"CLRX",0x5F, t_inh},
      {"ASRA",0x47, t_inh},
      {""},
      {"RSP",0x9C, t_inh},
      {""},
      {"LSRA",0x44, t_inh},
      {"BCS",0x25, t_rel},
      {""},
      {"ASL",0x28, t_rmw},
      {"ASRX",0x57, t_inh},
      {"ASLA",0x48, t_inh},
      {"BLS",0x23, t_rel},
      {"LSL",0x28, t_rmw},
      {"LSRX",0x54, t_inh},
      {"LSLA",0x48, t_inh},
      {""}, {""}, {""},
      {"ASLX",0x58, t_inh},
      {"DBG",0x2B, t_rmw},
      {"BCLR4",0x19, t_dir},
      {"BRCLR4",0x09, t_dirrel},
      {"LSLX",0x58, t_inh},
      {"ROR",0x26, t_rmw},
      {"BEQ",0x27, t_rel},
      {""},
      {"ADC",0xA9, t_rmi},
      {"DBGA",0x4B, t_inh},
      {"BIL",0x2E, t_rel},
      {""},
      {"BCLR6",0x1D, t_dir},
      {"BRCLR6",0x0D, t_dirrel},
      {"LDA",0xA6, t_rmi},
      {"ORA",0xAA, t_rmi},
      {"RORA",0x46, t_inh},
      {"DBGX",0x5B, t_inh},
      {"BCLR5",0x1B, t_dir},
      {"BRCLR5",0x0B, t_dirrel},
      {"BCLR3",0x17, t_dir},
      {"BRCLR3",0x07, t_dirrel},
      {"LDX",0xAE, t_rmi},
      {"ROL",0x29, t_rmw},
      {"RORX",0x56, t_inh},
      {"ROLA",0x49, t_inh},
      {""},
      {"BMC",0x2C, t_rel},
      {""}, {""}, {""},
      {"SEC",0x99, t_inh},
      {""},
      {"ROLX",0x59, t_inh},
      {"TXA",0x9F, t_inh},
      {""}, {""}, {""},
      {"TAX",0x97, t_inh},
      {"BHCC",0x28, t_rel},
      {"BRSET7",0x0E, t_dirrel},
      {"CMP",0xA1, t_rmi},
      {"STA",0xA7, t_rm},
      {"MUL",0x42, t_inh},
      {"BCLR0",0x11, t_dir},
      {"BRCLR0",0x01, t_dirrel},
      {""},
      {"CLI",0x9A, t_inh},
      {"JMP",0xAC, t_rm},
      {"RTS",0x81, t_inh},
      {"STX",0xAF, t_rm},
      {"BCLR1",0x13, t_dir},
      {"BRCLR1",0x03, t_dirrel},
      {"BMS",0x2D, t_rel},
      {"BCLR2",0x15, t_dir},
      {"BRCLR2",0x05, t_dirrel},
      {"SWI",0x83, t_inh},
      {""}, {""},
      {"DEC",0x2A, t_rmw},
      {"BHS",0x24, t_rel},
      {"EOR",0xA8, t_rmi},
      {""},
      {"BRSET4",0x08, t_dirrel},
      {""},
      {"BHCS",0x29, t_rel},
      {"DECA",0x4A, t_inh},
      {""},
      {"INC",0x2C, t_rmw},
      {"BLO",0x25, t_rel},
      {""}, {""}, {""},
      {"BRSET6",0x0C, t_dirrel},
      {"DECX",0x5A, t_inh},
      {"INCA",0x4C, t_inh},
      {""}, {""}, {""},
      {"BRSET5",0x0A, t_dirrel},
      {"NEG",0x20, t_rmw},
      {"BRSET3",0x06, t_dirrel},
      {""},
      {"INCX",0x5C, t_inh},
      {""}, {""},
      {"BRN",0x21, t_rel},
      {""},
      {"NEGA",0x40, t_inh},
      {"COMA",0x43, t_inh},
      {"ADD",0xAB, t_rmi},
      {"NOP",0x9D, t_inh},
      {""}, {""}, {""}, {""},
      {"NEGX",0x50, t_inh},
      {"COMX",0x53, t_inh},
      {""},
      {"RTI",0x80, t_inh},
      {""}, {""}, {""},
      {"BMI",0x2B, t_rel},
      {"BSET7",0x1E, t_dir},
      {"BRSET0",0x00, t_dirrel},
      {"STOP",0x8E, t_inh},
      {"SEI",0x9B, t_inh},
      {"TSTA",0x4D, t_inh},
      {""},
      {"BHI",0x22, t_rel},
      {""},
      {"BRSET1",0x02, t_dirrel},
      {"AND",0xA4, t_rmi},
      {""},
      {"BRSET2",0x04, t_dirrel},
      {"TSTX",0x5D, t_inh},
      {""}, {""}, {""}, {""}, {""},
      {"BIT",0xA5, t_rmi},
      {""}, {""}, {""}, {""},
      {"BSET4",0x18, t_dir},
      {""}, {""},
      {"BNE",0x26, t_rel},
      {""}, {""},
      {"WAIT",0x8F, t_inh},
      {""}, {""}, {""},
      {"BSET6",0x1C, t_dir},
      {""}, {""}, {""}, {""}, {""},
      {"BSET5",0x1A, t_dir},
      {"BIH",0x2F, t_rel},
      {"BSET3",0x16, t_dir},
      {""},
      {"COM",0x23, t_rmw},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"TST",0x2D, t_rmw},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"BSET0",0x10, t_dir},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"BSET1",0x12, t_dir},
      {""}, {""},
      {"BSET2",0x14, t_dir}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = wordlist[key].name;

          if (*str == *s && !strncmp (str + 1, s + 1, len - 1))
            return &wordlist[key];
        }
    }
  return 0;
}
