dnl -*- mode: m4; comment-start: "%" -*-
include(`macros.m4')divert(-1)
% $Id: rijndael-d.m4,v 1.5 1999/03/18 09:10:25 geoffk Exp $

define(v_K, 0xC0)	The key, stored big-endian.
define(v_state, 0xD0)	The block to encrypt
define(v_W, 0xE0)	The current round keys.
define(v_round, 0xF0)	The round number.
define(v_mixc_tmp, 0xF1)Temporary for MixColumn
define(v_mixc_xe, 0xF2)	Temp. for MixColumn, contains xtime(a[0]^a[2]).
define(v_mixc_xo, 0xF3)	Temp. for MixColumn, contains xtime(a[1]^a[3]).
define(v_mixc_tmp2, 0xF4)
			Temp. for MixColumn, contains v_mixc_tmp ^ a[*]
define(test_ram, 0xF5)	Memory for the test program.

define(NUMROUNDS,10)

divert`'dnl

const_RC:
	bytes(0x36,0x1B,0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01)

% The main Rijndael routine.
% Inputs:  ciphertext in v_state, scheduled key in v_K
% Outputs: plaintext in v_state.
rijndael_d:
% Perform the initial key XOR, copy the key into v_W.
	ldx	#0x10-1
d_key_copy_loop:
	lda	v_K,X
	sta	v_W,X
	eor	v_state,X
	sta	v_state,X
	decx
	bpl	d_key_copy_loop
	
	clr	v_round
	jmp	d_done_mixcolumn
d_round_loop:
% Do the InvMixColumn transformation, except during the first round
define(`xtime',`lsla
newlabel`'dnl
	bcs	Tlbl`'_0
	nop
Tlbl`'_0:
	bcc	Tlbl`'_1
	eor	#0x1B
Tlbl`'_1:')dnl
dnl
	ldx	#v_state
d_mixcolumn_loop:
	lda	,X
	eor	1,X
	eor	2,X
	eor	3,X
	sta	v_mixc_tmp
	lda	,X
	eor	2,X
	xtime
	sta	v_mixc_xe
	lda	1,X
	eor	3,X
	xtime
	sta	v_mixc_xo
	eor	v_mixc_xe
	xtime
	xtime
	eor	v_mixc_tmp
	sta	v_mixc_tmp2

forloop(`i',0,2,`dnl
	lda	i,X
	eor	i+1,X
	eor	ifelse(i,1,v_mixc_xo,v_mixc_xe)
	xtime
	eor	v_mixc_tmp2
	eor	i,X
	sta	i,X
')dnl

% Do the last word specially
% Here, the accumulator contains the appropriate byte of the previous word.
	eor	,X
	eor	1,X
	eor	v_mixc_tmp
	sta	3,X

	txa
	add	#4
	tax
	cpx	#v_state+16
	beq	d_done_mixcolumn
	jmp	d_mixcolumn_loop

d_done_mixcolumn:

% Do the InvByteSub and InvShiftRow transformations
% First row:
forloop(`i',0,3,`dnl
	ldx	v_state+eval(i*4)
	ldx	rijndael_sbox_d,X
	stx	v_state+eval(i*4)
')dnl
% Fourth row:
	ldx	v_state+3+0
	lda	rijndael_sbox_d,X
forloop(`i',1,3,`dnl
	ldx	v_state+3+eval(i*4)
	ldx	rijndael_sbox_d,X
	stx	v_state+3+eval((i-1)*4)
')dnl
	sta	v_state+3+eval(3*4)
% Third row:
forloop(`i',0,1,`dnl
	ldx	v_state+2+eval(i*4)
	lda	rijndael_sbox_d,X
	ldx	v_state+2+eval((i+2)*4)
	ldx	rijndael_sbox_d,X
	stx	v_state+2+eval(i*4)
	sta	v_state+2+eval((i+2)*4)
')dnl
% Second row:
	ldx	v_state+1+eval(3*4)
	lda	rijndael_sbox_d,X
foreach(`i',`2,1,0',`dnl
	ldx	v_state+1+eval(i*4)
	ldx	rijndael_sbox_d,X
	stx	v_state+1+eval((i+1)*4)
')dnl
	sta	v_state+1+eval(0*4)

% Update the key schedule and perform the key XOR
forloop(`i',0,3,`dnl
	lda	v_W+12+i
	eor	v_W+8+i
	sta	v_W+12+i
	eor	v_state+12+i
	sta	v_state+12+i
	lda	v_W+8+i
	eor	v_W+4+i
	sta	v_W+8+i
	eor	v_state+8+i
	sta	v_state+8+i
	lda	v_W+4+i
	eor	v_W+i
	sta	v_W+4+i
	eor	v_state+4+i
	sta	v_state+4+i
')

forloop(`i',0,3,`dnl
	ldx	v_W+eval(3*4)+eval((i+1)&3)
	lda	rijndael_sbox_e,X
ifelse(i,0,`dnl
	ldx	v_round
	eor	const_RC,X
')dnl
	eor	v_W+i
	sta	v_W+i
	eor	v_state+i
	sta	v_state+i
')dnl
	
% Perhaps that was the last round.
	inc	v_round
	lda	v_round
	cmp	#NUMROUNDS
	bne	d_more_round_loop
	
% We're done!
	rts

d_more_round_loop:
	jmp	d_round_loop

% These are the rijndael S-boxes.
define(`pow_tab',quote(define(`p',1)`'dnl
forloop(`i',0,254,`p, dnl
define(`log_tab_'p,i)dnl
define(`p',eval(p ^ ((p << 1) & 0xFF) ifelse(eval(p&0x80),0,`',^ 0x1b)))dnl
')p))dnl
define(`sbox_d_'eval(0x63),0)dnl
define(`sbox_e_0',eval(0x63))dnl
forloop(`i',1,255,`dnl
define(`p',choosei(eval(255-first(`log_tab_'i)), `pow_tab'))dnl
define(`t',eval(0x63^p
	forloop(`j',1,4,`^eval(((p >> (8-j)) | (p << j)) & 0xFF)')))
define(`sbox_d_'t,i)dnl
define(`sbox_e_'i,t)dnl
')dnl
rijndael_sbox_d:
forloop(`i',0,255,`dnl
	byte first(`sbox_d_'i)
')dnl
rijndael_sbox_e:
forloop(`i',0,255,`dnl
	byte first(`sbox_e_'i)
')dnl

% Create the `decryption key' for rijndael.  Do it in-place.
% Input: Key in v_K
% Output: Decryption key in v_K
rijndael_sched_d:
	lda	#NUMROUNDS-1
	sta	v_round

sch_round_loop:
forloop(`i',0,3,`dnl
	ldx	v_K+eval(3*4)+eval((i+1)&3)
	lda	rijndael_sbox_e,X
ifelse(i,0,`dnl
	ldx	v_round
	eor	const_RC,X
')dnl
	eor	v_K+i
	sta	v_K+i
')dnl
	
	ldx	#3
sch_e_keysched_loop:
	lda	v_K,X
	eor	v_K+4,X
	sta	v_K+4,X
	eor	v_K+8,X
	sta	v_K+8,X
	eor	v_K+12,X
	sta	v_K+12,X
	decx
	bpl	sch_e_keysched_loop

sch_e_rc_done:
	dec	v_round
	bpl	sch_round_loop
	rts
	

test_program(test_ram,v_K,16,v_state,v_state,16,jsr rijndael_sched_d,dnl
jsr rijndael_d)

test_data:
xbytes(00000000000000000000000000000000
	66e94bd4ef8a2c3b884cfa59ca342b2e 00000000000000000000000000000000)
xbytes(00000000000000000000000000000000
	f795bd4a52e29ed713d313fa20e98dbc 66e94bd4ef8a2c3b884cfa59ca342b2e)
xbytes(00000000000000000000000000000000
	a10cf66d0fddf3405370b4bf8df5bfb3 f795bd4a52e29ed713d313fa20e98dbc)
xbytes(a10cf66d0fddf3405370b4bf8df5bfb3
	d6f6a9c7e08242fc7e0c6eacd7257837 00000000000000000000000000000000)
xbytes(a10cf66d0fddf3405370b4bf8df5bfb3
	6e3187c0e66f5bf72554093c6f4a03f4 d6f6a9c7e08242fc7e0c6eacd7257837)
test_data_end:
