-- *************************************************************************
-- DISCLAIMER. THIS SOFTWARE WAS WRITTEN BY EMPLOYEES OF THE U.S.
-- GOVERNMENT AS A PART OF THEIR OFFICIAL DUTIES AND, THEREFORE, IS NOT
-- PROTECTED BY COPYRIGHT. HOWEVER, THIS SOFTWARE CODIFIES THE FINALIST
-- CANDIDATE ALGORITHMS (i.e., MARS, RC6tm, RIJNDAEL, SERPENT, AND
-- TWOFISH) IN THE ADVANCED ENCRYPTION STANDARD (AES) DEVELOPMENT EFFORT
-- SPONSORED BY THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY (NIST)
-- AND MAY BE PROTECTED BY ONE OR MORE FORMS OF INTELLECTUAL PROPERTY. THE
-- U.S. GOVERNMENT MAKES NO WARRANTY, EITHER EXPRESSED OR IMPLIED,
-- INCLUDING BUT NO LIMITED TO ANY IMPLIED WARRANTIES OF MERCHANTABILITY
-- OR FITNESS FOR A PARTICULAR PURPOSE, REGARDING THIS SOFTWARE. THE U.S.
-- GOVERNMENT FURTHER MAKES NO WARRANTY THAT THIS SOFTWARE WILL NOT
-- INFRINGE ANY OTHER UNITED STATES OR FOREIGN PATENT OR OTHER
-- INTELLECTUAL PROPERTY RIGHT. IN NO EVENT SHALL THE U.S. GOVERNMENT BE
-- LIABLE TO ANYONE FOR COMPENSATORY, PUNITIVE, EXEMPLARY, SPECIAL,
-- COLLATERAL, INCIDENTAL, CONSEQUENTIAL, OR ANY OTHER TYPE OF DAMAGES IN
-- CONNECTION WITH OR ARISING OUT OF COPY OR USE OF THIS SOFTWARE.
-- *************************************************************************

-- ===========================================================================
-- File Name : twofish_round.vhdl
-- Author    : NSA
-- Date      : December 1999
-- Project   : AES Candidate Evaluation - TWOFISH
-- Purpose   : This block implements the TWOFISH algorithm round
-- Notes     :
-- ===========================================================================

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use WORK.twofish_pack.all;

-- ===========================================================================
-- =========================== Interface Description =========================
-- ===========================================================================

entity TWOFISH_ROUND is

  port (datain         :  in SLV_128;
        enc_key1       :  in SLV_32;
        enc_key2       :  in SLV_32;
        dec_key1       :  in SLV_32;
        dec_key2       :  in SLV_32;
        cv_length      :  in CV_SIZE_TYPE;
        S              :  in S_ARRAY_TYPE;
        round          :  in SLV_5;
        enc_dec_b      :  in std_logic;
        dataout        :  out SLV_128    );

end TWOFISH_ROUND;

architecture TWOFISH_ROUND_RTL of TWOFISH_ROUND is


begin

  dataout <= TWOFISH_ROUND_FUNCT(cv_length,
                                 datain,
                                 dec_key1,
                                 dec_key2,
                                 enc_dec_b,
                                 enc_key1,
                                 enc_key2,
                                 round,
                                 S );

end TWOFISH_ROUND_RTL;


-- ===========================================================================
-- ============================ Configuration ================================
-- ===========================================================================

configuration CFG_TWOFISH_ROUND of TWOFISH_ROUND is

   for TWOFISH_ROUND_RTL

   end for;

end CFG_TWOFISH_ROUND;

