-- *************************************************************************
-- DISCLAIMER. THIS SOFTWARE WAS WRITTEN BY EMPLOYEES OF THE U.S.
-- GOVERNMENT AS A PART OF THEIR OFFICIAL DUTIES AND, THEREFORE, IS NOT
-- PROTECTED BY COPYRIGHT. HOWEVER, THIS SOFTWARE CODIFIES THE FINALIST
-- CANDIDATE ALGORITHMS (i.e., MARS, RC6tm, RIJNDAEL, SERPENT, AND
-- TWOFISH) IN THE ADVANCED ENCRYPTION STANDARD (AES) DEVELOPMENT EFFORT
-- SPONSORED BY THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY (NIST)
-- AND MAY BE PROTECTED BY ONE OR MORE FORMS OF INTELLECTUAL PROPERTY. THE
-- U.S. GOVERNMENT MAKES NO WARRANTY, EITHER EXPRESSED OR IMPLIED,
-- INCLUDING BUT NO LIMITED TO ANY IMPLIED WARRANTIES OF MERCHANTABILITY
-- OR FITNESS FOR A PARTICULAR PURPOSE, REGARDING THIS SOFTWARE. THE U.S.
-- GOVERNMENT FURTHER MAKES NO WARRANTY THAT THIS SOFTWARE WILL NOT
-- INFRINGE ANY OTHER UNITED STATES OR FOREIGN PATENT OR OTHER
-- INTELLECTUAL PROPERTY RIGHT. IN NO EVENT SHALL THE U.S. GOVERNMENT BE
-- LIABLE TO ANYONE FOR COMPENSATORY, PUNITIVE, EXEMPLARY, SPECIAL,
-- COLLATERAL, INCIDENTAL, CONSEQUENTIAL, OR ANY OTHER TYPE OF DAMAGES IN
-- CONNECTION WITH OR ARISING OUT OF COPY OR USE OF THIS SOFTWARE.
-- *************************************************************************
--
-- File Name : create_roundkey_block.vhdl
-- Author    : NSA
-- Date      : 07 October 99
-- Project   : AES Candidate Evaluation --RC6
-- Purpose   : This block creates and stores the array of subkeys
-- Notes     : Only used in Pipelined case
-- ===========================================================================

library IEEE;
library DWDL;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use WORK.rc6_pack.all;

entity CREATE_ROUNDKEY_BLOCK is
  port (
        cv_in    : in  L_ARRAY_TYPE;
        roundkey : out S_ARRAY_TYPE );

end CREATE_ROUNDKEY_BLOCK;

architecture rtl of CREATE_ROUNDKEY_BLOCK is 


component CR_ROUND_BLOCK
  port (
    A       : in SLV_32;
    B       : in L_ARRAY_TYPE;
    S_IN    : in SLV_32;
    L_IN    : in L_ARRAY_TYPE;
    V       : in SLV_8;

    S_OUT   : out SLV_32;
    L_OUT   : out L_ARRAY_TYPE
  );

end component;

type ROUND_VEC_TYPE is array(0 to 131) of SLV_8;

  constant ROUND_VEC : ROUND_VEC_TYPE := ( 
"00000000", 
"00000001", 
"00000010", 
"00000011", 
"00000100", 
"00000101", 
"00000110", 
"00000111", 
"00001000", 
"00001001", 
"00001010",
 
"00001011", 
"00001100",
"00001101", 
"00001110", 
"00001111", 
"00010000", 
"00010001", 
"00010010", 
"00010011", 
"00010100", 

"00010101", 
"00010110", 
"00010111", 
"00011000", 
"00011001",
"00011010", 
"00011011", 
"00011100", 
"00011101", 
"00011110", 

"00011111", 
"00100000", 
"00100001", 
"00100010", 
"00100011", 
"00100100", 
"00100101", 
"00100110",
"00100111", 
"00101000", 

"00101001", 
"00101010", 
"00101011", --43
"00101100", 
"00101101", 
"00101110", 
"00101111", 
"00110000", 
"00110001", 
"00110010", 
"00110011", 
"00110100", 

"00110101", 
"00110110", 
"00110111", 
"00111000", 
"00111001",
"00111010", 
"00111011", 
"00111100", 
"00111101", 
"00111110", 
"00111111", --63
"01000000",
"01000001", 
"01000010", 
"01000011", 
"01000100", 
"01000101", 
"01000110", 
"01000111", 
"01001000", 
"01001001", 
"01001010",
 
"01001011", 
"01001100",
"01001101", 
"01001110", 
"01001111", 
"01010000", 
"01010001", 
"01010010", 
"01010011", 
"01010100", 

"01010101", 
"01010110", 
"01010111", 
"01011000", 
"01011001",
"01011010", 
"01011011", 
"01011100", 
"01011101", 
"01011110", 

"01011111", 
"01100000", 
"01100001", 
"01100010", 
"01100011", 
"01100100", 
"01100101", 
"01100110",
"01100111", 
"01101000", 

"01101001", 
"01101010", 
"01101011", 
"01101100", 
"01101101", 
"01101110", 
"01101111", 
"01110000", 
"01110001", 
"01110010", 
"01110011", 
"01110100", 

"01110101", 
"01110110", 
"01110111", 
"01111000", 
"01111001",
"01111010", 
"01111011", 
"01111100", 
"01111101", 
"01111110", 
"01111111", --127
"10000000",
"10000001",
"10000010",
"10000011" );

signal L             : L_ARRAY_TYPE;
signal S             : S_ARRAY_TYPE;
signal cv_in_int     : L_ARRAY_TYPE;
signal NEW_S         : NEW_S_ARRAY_TYPE;
signal NEW_L         : L_PIPE_TYPE;
signal X             : SLV_32;
signal Y             : L_ARRAY_TYPE;
signal round_num     : ROUND_VEC_TYPE;
signal S_INIT        : SLV_32;



begin

G0: for CV_INDEX in 0 to 3 generate

  SWAP: BYTESWAP32( cv_in(CV_INDEX),
                    cv_in_int(CV_INDEX) );

end generate; --G0


  L    <= cv_in_int;                 -- assign CV input to working variable
                                     -- Initialize S array with constant
  S(0)    <= Pw;                     -- Assign starting value for array
 
  X <= ( others => '0' );            -- Clear temporary variable

 -- SINIT: INIT_S_VALUE(S_INIT,S);

G0a: for i in 1 to 43 generate           -- Add in constant and generate next S
   
    S(i) <= std_logic_vector(unsigned(S(i-1)) + unsigned(Qw));

end generate; --G0a

 
G1a: for i in 0 to 3 generate        -- Clear temporary variable

    Y(i) <= ( others => '0' ); 

end generate; --G1a  
          
G1b: for round in 0 to 131 generate

      round_num(round) <= ROUND_VEC(round);

end generate; --G1b

G2: for v in 0 to 43 generate

   G3: if v = 0 generate

      
      CR: CR_ROUND_BLOCK port map ( X, Y, 
                                    S(v), L,
                                    round_num(v), 
                                    NEW_S(v), NEW_L(v) 
                                   );

   end generate; -- G3

   G4: if v > 0 generate

      CR: CR_ROUND_BLOCK port map ( NEW_S(v-1), NEW_L(v-1), 
                                    S(v), NEW_L(v-1),
                                    round_num(v),
                                    NEW_S(v), NEW_L(v)
                                   );

   end generate; -- G4

end generate; -- G2

G5: for v in 44 to 87 generate

   G6: if v = 44 generate

      CR: CR_ROUND_BLOCK port map ( NEW_S(43), NEW_L(43), 
                                    NEW_S(v-44), NEW_L(43), 
                                    round_num(v),
                                    NEW_S(v), NEW_L(v) 
                                   );

   end generate; -- G6

   G7: if v > 44 generate

      CR: CR_ROUND_BLOCK port map ( NEW_S(v-1), NEW_L(v-1), 
                                    NEW_S(v-44), NEW_L(v-1),
                                    round_num(v),
                                    NEW_S(v), NEW_L(v) 
                                   );

   end generate; -- G7

end generate; -- G5

G8: for v in 88 to 131 generate

   G9: if v = 88 generate

      CR: CR_ROUND_BLOCK port map ( NEW_S(87), NEW_L(87), 
                                    NEW_S(v-44), NEW_L(87),  
                                    round_num(v),
                                    NEW_S(v), NEW_L(v)
                                   );

   end generate; -- G9

   G10: if v > 88 generate

      CR: CR_ROUND_BLOCK port map ( NEW_S(v-1), NEW_L(v-1), 
                                    NEW_S(v-44), NEW_L(v-1),         
                                    round_num(v),
                                    NEW_S(v), NEW_L(v)
                                   );

   end generate; -- G10

end generate; -- G8

G11: for i in 0 to 43 generate

    roundkey(i) <= NEW_S(i+88);

end generate; --G11

end rtl;
