-- *************************************************************************
-- DISCLAIMER. THIS SOFTWARE WAS WRITTEN BY EMPLOYEES OF THE U.S.
-- GOVERNMENT AS A PART OF THEIR OFFICIAL DUTIES AND, THEREFORE, IS NOT
-- PROTECTED BY COPYRIGHT. HOWEVER, THIS SOFTWARE CODIFIES THE FINALIST
-- CANDIDATE ALGORITHMS (i.e., MARS, RC6tm, RIJNDAEL, SERPENT, AND
-- TWOFISH) IN THE ADVANCED ENCRYPTION STANDARD (AES) DEVELOPMENT EFFORT
-- SPONSORED BY THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY (NIST)
-- AND MAY BE PROTECTED BY ONE OR MORE FORMS OF INTELLECTUAL PROPERTY. THE
-- U.S. GOVERNMENT MAKES NO WARRANTY, EITHER EXPRESSED OR IMPLIED,
-- INCLUDING BUT NO LIMITED TO ANY IMPLIED WARRANTIES OF MERCHANTABILITY
-- OR FITNESS FOR A PARTICULAR PURPOSE, REGARDING THIS SOFTWARE. THE U.S.
-- GOVERNMENT FURTHER MAKES NO WARRANTY THAT THIS SOFTWARE WILL NOT
-- INFRINGE ANY OTHER UNITED STATES OR FOREIGN PATENT OR OTHER
-- INTELLECTUAL PROPERTY RIGHT. IN NO EVENT SHALL THE U.S. GOVERNMENT BE
-- LIABLE TO ANYONE FOR COMPENSATORY, PUNITIVE, EXEMPLARY, SPECIAL,
-- COLLATERAL, INCIDENTAL, CONSEQUENTIAL, OR ANY OTHER TYPE OF DAMAGES IN
-- CONNECTION WITH OR ARISING OUT OF COPY OR USE OF THIS SOFTWARE.
-- *************************************************************************
--
-- File Name : register_delay_s.vhdl
-- Author    : NSA
-- Date      : 04 October 1999
-- Project   : AES Candidate Evaluation --RC6
-- Purpose   : This block stores the generated round keys for the pipelined 
--             case.  It dictates the motion of round keys through the
--             pipeline based on the latch signal.
-- Notes     : Used for pipeline case only.
-- ===========================================================================

library ieee;
use ieee.std_logic_1164.all;
use WORK.rc6_pack.all;

-- ===========================================================================
-- =========================== Interface Description =========================
-- ===========================================================================

entity REGISTER_DELAY_S is

  port (clock    :  in std_logic;   -- clock signal
        reset    :  in std_logic;   -- active high reset (asynchronous)
    
        LATCH    :  in std_logic;
        DATA_IN  :  in SLV_32;      -- input data bus

        DATA_OUT :  out SLV_32      -- output data bus

  );

end REGISTER_DELAY_S;

architecture REGISTER_DELAY_S_RTL of REGISTER_DELAY_S is

-- ===========================================================================
-- =========================== Signal Definition =============================
-- ===========================================================================

signal DATA_OUT_INT : SLV_32;

begin

-- ===========================================================================
-- =========================== Data Movement =================================
-- ===========================================================================

DATA_OUT <= DATA_OUT_INT;

DATA_FLOW : process( clock, reset )

begin

   if reset = '1' then

      DATA_OUT_INT <= ( others => '0' );

   elsif clock'event and clock = '1' then

      if LATCH = '1' then
         DATA_OUT_INT <= DATA_IN;       -- latch input data
      else
         DATA_OUT_INT <= DATA_OUT_INT;  -- hold data
      end if;

   end if;

end process; -- DATA_FLOW

end REGISTER_DELAY_S_RTL;
