
; Example IDEA Encryption Program
; (C) Fauzan Mirza 1995

; Link with IDEA/CFB object file

        .model  tiny
        .code

        extrn   expandkey:near
        extrn   encrypt:near
        extrn   decrypt:near
        extrn   cfbbuffer:near

        org     100h

BufLen  equ     16384

Start:
        mov     si,80h
        lodsb
        or      al,al
        jnz     Begin

PrintUsage:
        mov     ah,9
        mov     dx,offset Usage
        int     21h

        mov     ax,4c01h
        int     21h

SkipSpaces:
        lodsb
        cmp     al,0dh
        jz      PrintUsage
        cmp     al,20h
        jz      SkipSpaces
        dec     si
        ret

AddZero:
        lodsb
        cmp     al,0dh
        jz      AddZ2
        cmp     al,20h
        jnz     AddZero
AddZ2:
        mov     byte ptr [si-1],0
        ret

Begin:
        call    SkipSpaces
        lodsb
        cmp     al,'-'
        jz      DeMode
        cmp     al,'+'
        jz      EnMode
        jmp     PrintUsage
DeMode:
        mov     byte ptr [Mode],255
EnMode:
        call    SkipSpaces
        mov     word ptr [Infile],si
        call    AddZero

        call    SkipSpaces
        mov     word ptr [Outfile],si
        call    AddZero
   
        mov     ah,9
        mov     dx,offset Enterkey
        int     21h

        mov     ah,0ah
        mov     dx,offset Password
        int     21h

        mov     si,offset Userkey
        mov     di,offset Key
        call    Expandkey

        mov     si,offset IV
        mov     di,offset CFBBuffer
        mov     cx,4
        repnz   movsw

        mov     ax,3d00h
        mov     dx,word ptr [Infile]
        int     21h
        jc      Error
        mov     word ptr [Infile],ax

        mov     ah,3ch
        xor     cx,cx
        mov     dx,word ptr [Outfile]
        int     21h
        jc      Error
        mov     word ptr [Outfile],ax

Again:
        mov     ah,3fh
        mov     bx,word ptr [Infile]
        mov     cx,BufLen
        mov     dx,offset Buffer
        int     21h
        jc      Error

        or      ax,ax
        jz      Done

        push    ax
        call    DoCrypt
        pop     cx

        mov     ah,40h
        mov     bx,word ptr [Outfile]
        mov     dx,offset Buffer
        int     21h
        jc      Error

        cmp     cx,BufLen
        jz      Again

Done:

        mov     ah,3eh
        mov     bx,word ptr [Outfile]
        int     21h

        mov     ah,3eh
        mov     bx,word ptr [Infile]
        int     21h

        mov     ax,4c00h
        int     21h

Error:
        mov     ah,09
        mov     dx,offset Message
        int     21h

        mov     ax,4c01h
        int     21h

DoCrypt:
        mov     si,offset Key
        mov     di,offset Buffer
        add     ax,7
        mov     cl,3
        shr     ax,cl
        mov     cx,ax
Block:
        push    cx
        push    si di
        cmp     byte ptr [Mode],0
        jnz     DoDecrypt
        call    Encrypt
        jmp     DoNextBlock
DoDecrypt:
        call    Decrypt
DoNextBlock:
        pop     di si
        add     di,8
        pop     cx
        loop    Block
        ret

Usage:
        db      "Usage: CRYPT [+|-] <InFile> <OutFile>",10,13,36

Enterkey:
        db      "Enter Key: ",36

Message:
        db      "File Access Error",10,13,36

Mode:
        db      0

Infile:
        dw      0

Outfile:
        dw      0

Password:
        db      16,0

Userkey:
        db      16 dup(?)

IV:
        dw      9d73h,1a08h,0f25eh,0b46ch

Key:
        dw      52 dup(?)

Buffer:
        db      BufLen dup(?)

        end     Start

