/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.Hex;
import java.security.Cipher;
import java.security.Key;

public final class TestSPEED {
    private static final String[][] testData1 = new String[][]{{"64", "0000000000000000", "0000000000000000", "6D8526BC1980002E"}, {"128", "00000000000000000000000000000000", "00000000000000000000000000000000", "09B96371D5DFA2D7F8CBF6ED29BF4FA4"}, {"128", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "E8C45B9116D854AB711517C3B9E4136C"}, {"48", "4142434445464748494A4B4C4D4E4F50", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F", "92363E88EDF53BA775E86E0AB7CD512E9BF36BADCDCA78C11BD2A3F61E98C590"}, {"256", "0000000000000000000000000000000000000000000000000000000000000000", "0000000000000000000000000000000000000000000000000000000000000000", "F59BB02EA027DF8C29568D300117FA0A2C3A71AFC4D15FE9A76ABC492B4DD46C"}, {"256", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", "C5D093BAA39B1BCA81FB89CE0E9A4ACF22C0EB7B22382E2224AF3F2664E8F3C8"}, {"256", "4142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F60", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F", "681031BACC31B108D7616B298A55AA3F1BEC3F6974154E434768629AFA6CE13D"}};

    private TestSPEED() {
        System.out.println("*** SPEED:\n");
        try {
            this.test1();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static final void main(String[] stringArray) {
        try {
            new TestSPEED();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void test1() throws Exception {
        System.out.println("*** SPEED in ECB mode\n");
        int n = 0;
        int n2 = 0;
        while (n2 < testData1.length) {
            Cipher cipher = Cipher.getInstance((String)"SPEED", (String)"Cryptix");
            cipher.setParameter("rounds", (Object)new Integer(testData1[n2][0]));
            cipher.setParameter("blockSize", (Object)new Integer(testData1[n2][2].length() / 2));
            RawSecretKey rawSecretKey = new RawSecretKey("SPEED", Hex.fromString((String)testData1[n2][1]));
            cipher.initEncrypt((Key)rawSecretKey);
            byte[] byArray = cipher.crypt(Hex.fromString((String)testData1[n2][2]));
            String string = Hex.toString((byte[])byArray);
            cipher.initDecrypt((Key)rawSecretKey);
            byte[] byArray2 = cipher.crypt(byArray);
            String string2 = Hex.toString((byte[])byArray2);
            System.out.println("     plain:  " + testData1[n2][2]);
            System.out.println("     cipher: " + string);
            System.out.println("     cert:   " + testData1[n2][3]);
            if (string.equals(testData1[n2][3])) {
                System.out.println("   * Encrypt GOOD");
            } else {
                System.out.println("===> Encrypt (#" + ++n + ") FAILED <===");
            }
            System.out.println("     cipher: " + Hex.toString((byte[])byArray));
            System.out.println("     plain:  " + string2);
            System.out.println("     cert:   " + testData1[n2][2]);
            if (string2.equals(testData1[n2][2])) {
                System.out.println("   * Decrypt GOOD");
            } else {
                System.out.println("===> Decrypt (#" + ++n + ") FAILED <===");
            }
            System.out.println("");
            ++n2;
        }
        if (n != 0) {
            throw new Exception("SPEED  failed: " + n + " times");
        }
        System.out.println("\nSPEED succeeded (" + n2 + " tests)");
    }
}

