/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.EncryptedPrivateKeyInfo;
import com.sun.crypto.provider.KeyProtector;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.crypto.SealedObject;

public final class JceKeyStore
extends KeyStoreSpi {
    private static final int JCEKS_MAGIC = -825307442;
    private static final int JKS_MAGIC = -17957139;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private Hashtable entries = new Hashtable();

    public Enumeration engineAliases() {
        return this.entries.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string.toLowerCase());
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            this.entries.remove(string.toLowerCase());
        }
    }

    public Certificate engineGetCertificate(String string) {
        Certificate certificate = null;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof TrustedCertEntry) {
                certificate = ((TrustedCertEntry)v).cert;
            } else if (v instanceof PrivateKeyEntry && ((PrivateKeyEntry)v).chain != null) {
                certificate = ((PrivateKeyEntry)v).chain[0];
            }
        }
        return certificate;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object v = this.entries.get(string);
            if (v instanceof TrustedCertEntry) {
                certificate2 = ((TrustedCertEntry)v).cert;
            } else {
                if (!(v instanceof PrivateKeyEntry) || ((PrivateKeyEntry)v).chain == null) continue;
                certificate2 = ((PrivateKeyEntry)v).chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Certificate[] certificateArray = null;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof PrivateKeyEntry && ((PrivateKeyEntry)v).chain != null) {
            certificateArray = (Certificate[])((PrivateKeyEntry)v).chain.clone();
        }
        return certificateArray;
    }

    public Date engineGetCreationDate(String string) {
        Date date = null;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null) {
            date = v instanceof TrustedCertEntry ? new Date(((TrustedCertEntry)v).date.getTime()) : (v instanceof PrivateKeyEntry ? new Date(((PrivateKeyEntry)v).date.getTime()) : new Date(((SecretKeyEntry)v).date.getTime()));
        }
        return date;
    }

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Key key = null;
        Object v = this.entries.get(string.toLowerCase());
        if (v == null || v instanceof TrustedCertEntry) {
            return null;
        }
        KeyProtector keyProtector = new KeyProtector(cArray);
        if (v instanceof PrivateKeyEntry) {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
            byte[] byArray = ((PrivateKeyEntry)v).protectedKey;
            try {
                encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
            }
            catch (IOException iOException) {
                throw new UnrecoverableKeyException("Private key not stored as PKCS #8 EncryptedPrivateKeyInfo");
            }
            key = keyProtector.recover(encryptedPrivateKeyInfo);
        } else {
            key = keyProtector.unseal(((SecretKeyEntry)v).sealedKey);
        }
        return key;
    }

    public boolean engineIsCertificateEntry(String string) {
        boolean bl = false;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof TrustedCertEntry) {
            bl = true;
        }
        return bl;
    }

    public boolean engineIsKeyEntry(String string) {
        boolean bl = false;
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && (v instanceof PrivateKeyEntry || v instanceof SecretKeyEntry)) {
            bl = true;
        }
        return bl;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object;
            DataInputStream dataInputStream;
            MessageDigest messageDigest = null;
            CertificateFactory certificateFactory = null;
            Hashtable<String, CertificateFactory> hashtable2 = null;
            ByteArrayInputStream byteArrayInputStream = null;
            byte[] byArray = null;
            if (inputStream == null) {
                Object var4_9 = null;
                return;
            }
            if (cArray != null) {
                messageDigest = this.getPreKeyedHash(cArray);
                dataInputStream = new DataInputStream(new DigestInputStream(inputStream, messageDigest));
            } else {
                dataInputStream = new DataInputStream(inputStream);
            }
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            if (n != -825307442 && n != -17957139 || n2 != 1 && n2 != 2) {
                throw new IOException("Invalid keystore format");
            }
            if (n2 == 1) {
                certificateFactory = CertificateFactory.getInstance("X509");
            } else {
                hashtable2 = new Hashtable<String, CertificateFactory>(3);
            }
            this.entries.clear();
            int n3 = dataInputStream.readInt();
            int n4 = 0;
            while (n4 < n3) {
                Object object2;
                int n5 = dataInputStream.readInt();
                if (n5 == 1) {
                    object2 = new PrivateKeyEntry();
                    object = dataInputStream.readUTF();
                    ((PrivateKeyEntry)object2).date = new Date(dataInputStream.readLong());
                    try {
                        ((PrivateKeyEntry)object2).protectedKey = new byte[dataInputStream.readInt()];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Keysize too big");
                    }
                    dataInputStream.readFully(((PrivateKeyEntry)object2).protectedKey);
                    try {
                        ((PrivateKeyEntry)object2).chain = new Certificate[dataInputStream.readInt()];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Too many certificates in chain");
                    }
                    int n6 = 0;
                    while (n6 < ((PrivateKeyEntry)object2).chain.length) {
                        if (n2 == 2) {
                            String string = dataInputStream.readUTF();
                            if (hashtable2.containsKey(string)) {
                                certificateFactory = (CertificateFactory)hashtable2.get(string);
                            } else {
                                certificateFactory = CertificateFactory.getInstance(string);
                                hashtable2.put(string, certificateFactory);
                            }
                        }
                        try {
                            byArray = new byte[dataInputStream.readInt()];
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            throw new IOException("Certificate too big");
                        }
                        dataInputStream.readFully(byArray);
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        ((PrivateKeyEntry)object2).chain[n6] = certificateFactory.generateCertificate(byteArrayInputStream);
                        byteArrayInputStream.close();
                        ++n6;
                    }
                    this.entries.put(object, object2);
                } else if (n5 == 2) {
                    object2 = new TrustedCertEntry();
                    object = dataInputStream.readUTF();
                    ((TrustedCertEntry)object2).date = new Date(dataInputStream.readLong());
                    if (n2 == 2) {
                        String string = dataInputStream.readUTF();
                        if (hashtable2.containsKey(string)) {
                            certificateFactory = (CertificateFactory)hashtable2.get(string);
                        } else {
                            certificateFactory = CertificateFactory.getInstance(string);
                            hashtable2.put(string, certificateFactory);
                        }
                    }
                    try {
                        byArray = new byte[dataInputStream.readInt()];
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new IOException("Certificate too big");
                    }
                    dataInputStream.readFully(byArray);
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    ((TrustedCertEntry)object2).cert = certificateFactory.generateCertificate(byteArrayInputStream);
                    byteArrayInputStream.close();
                    this.entries.put(object, object2);
                } else if (n5 == 3) {
                    object2 = new SecretKeyEntry();
                    object = dataInputStream.readUTF();
                    ((SecretKeyEntry)object2).date = new Date(dataInputStream.readLong());
                    ObjectInputStream objectInputStream = new ObjectInputStream(dataInputStream);
                    try {
                        ((SecretKeyEntry)object2).sealedKey = (SealedObject)objectInputStream.readObject();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IOException(classNotFoundException.getMessage());
                    }
                    this.entries.put(object, object2);
                } else {
                    throw new IOException("Unrecognized keystore entry");
                }
                ++n4;
            }
            if (cArray != null) {
                byte[] byArray2 = messageDigest.digest();
                object = new byte[byArray2.length];
                dataInputStream.readFully((byte[])object);
                int n7 = 0;
                while (n7 < byArray2.length) {
                    if (byArray2[n7] != object[n7]) {
                        throw new IOException("Keystore was tampered with, or password was incorrect");
                    }
                    ++n7;
                }
            }
        }
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object v = this.entries.get(string.toLowerCase());
            if (v != null) {
                if (v instanceof PrivateKeyEntry) {
                    throw new KeyStoreException("Cannot overwrite own certificate");
                }
                if (v instanceof SecretKeyEntry) {
                    throw new KeyStoreException("Cannot overwrite secret key");
                }
            }
            TrustedCertEntry trustedCertEntry = new TrustedCertEntry();
            trustedCertEntry.cert = certificate;
            trustedCertEntry.date = new Date();
            this.entries.put(string.toLowerCase(), trustedCertEntry);
        }
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            try {
                KeyProtector keyProtector = new KeyProtector(cArray);
                if (key instanceof PrivateKey) {
                    PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry();
                    privateKeyEntry.date = new Date();
                    privateKeyEntry.protectedKey = keyProtector.protect((PrivateKey)key);
                    if (certificateArray != null) {
                        privateKeyEntry.chain = (Certificate[])certificateArray.clone();
                    }
                    this.entries.put(string.toLowerCase(), privateKeyEntry);
                } else {
                    SecretKeyEntry secretKeyEntry = new SecretKeyEntry();
                    secretKeyEntry.date = new Date();
                    secretKeyEntry.sealedKey = keyProtector.seal(key);
                    this.entries.put(string.toLowerCase(), secretKeyEntry);
                }
            }
            catch (Exception exception) {
                throw new KeyStoreException(exception.getMessage());
            }
        }
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            PrivateKeyEntry privateKeyEntry = new PrivateKeyEntry();
            privateKeyEntry.date = new Date();
            privateKeyEntry.protectedKey = (byte[])byArray.clone();
            if (certificateArray != null) {
                privateKeyEntry.chain = (Certificate[])certificateArray.clone();
            }
            this.entries.put(string.toLowerCase(), privateKeyEntry);
        }
    }

    public int engineSize() {
        return this.entries.size();
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.entries;
        synchronized (hashtable) {
            Object object;
            if (cArray == null) {
                throw new IllegalArgumentException("password can't be null");
            }
            MessageDigest messageDigest = this.getPreKeyedHash(cArray);
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(outputStream, messageDigest));
            dataOutputStream.writeInt(-825307442);
            dataOutputStream.writeInt(2);
            dataOutputStream.writeInt(this.entries.size());
            Enumeration enumeration = this.entries.keys();
            while (enumeration.hasMoreElements()) {
                byte[] byArray;
                Object object2;
                object = (String)enumeration.nextElement();
                Object v = this.entries.get(object);
                if (v instanceof PrivateKeyEntry) {
                    object2 = (PrivateKeyEntry)v;
                    dataOutputStream.writeInt(1);
                    dataOutputStream.writeUTF((String)object);
                    dataOutputStream.writeLong(((PrivateKeyEntry)object2).date.getTime());
                    dataOutputStream.writeInt(((PrivateKeyEntry)object2).protectedKey.length);
                    dataOutputStream.write(((PrivateKeyEntry)object2).protectedKey);
                    int n = ((PrivateKeyEntry)object2).chain == null ? 0 : ((PrivateKeyEntry)object2).chain.length;
                    dataOutputStream.writeInt(n);
                    int n2 = 0;
                    while (n2 < n) {
                        byArray = ((PrivateKeyEntry)object2).chain[n2].getEncoded();
                        dataOutputStream.writeUTF(((PrivateKeyEntry)object2).chain[n2].getType());
                        dataOutputStream.writeInt(byArray.length);
                        dataOutputStream.write(byArray);
                        ++n2;
                    }
                    continue;
                }
                if (v instanceof TrustedCertEntry) {
                    dataOutputStream.writeInt(2);
                    dataOutputStream.writeUTF((String)object);
                    dataOutputStream.writeLong(((TrustedCertEntry)v).date.getTime());
                    byArray = ((TrustedCertEntry)v).cert.getEncoded();
                    dataOutputStream.writeUTF(((TrustedCertEntry)v).cert.getType());
                    dataOutputStream.writeInt(byArray.length);
                    dataOutputStream.write(byArray);
                    continue;
                }
                dataOutputStream.writeInt(3);
                dataOutputStream.writeUTF((String)object);
                dataOutputStream.writeLong(((SecretKeyEntry)v).date.getTime());
                object2 = new ObjectOutputStream(dataOutputStream);
                ((ObjectOutputStream)object2).writeObject(((SecretKeyEntry)v).sealedKey);
            }
            object = messageDigest.digest();
            dataOutputStream.write((byte[])object);
            dataOutputStream.flush();
        }
    }

    private MessageDigest getPreKeyedHash(char[] cArray) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA");
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            byArray[n2++] = (byte)(cArray[n] >> 8);
            byArray[n2++] = (byte)cArray[n];
            ++n;
        }
        messageDigest.update(byArray);
        n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
        messageDigest.update("Mighty Aphrodite".getBytes("UTF8"));
        return messageDigest;
    }

    class PrivateKeyEntry {
        Date date;
        byte[] protectedKey;
        Certificate[] chain;

        PrivateKeyEntry() {
        }
    }

    class SecretKeyEntry {
        Date date;
        SealedObject sealedKey;

        SecretKeyEntry() {
        }
    }

    class TrustedCertEntry {
        Date date;
        Certificate cert;

        TrustedCertEntry() {
        }
    }
}

