/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

public final class HmacSHA1
extends MacSpi
implements Cloneable {
    private MessageDigest sha1 = MessageDigest.getInstance("SHA1");
    private byte[] k_ipad = new byte[64];
    private byte[] k_opad = new byte[64];
    private boolean first = true;
    private static final int SHA1_LENGTH = 20;
    private static final int SHA1_BLOCK_LENGTH = 64;

    public Object clone() {
        HmacSHA1 hmacSHA1 = null;
        try {
            hmacSHA1 = (HmacSHA1)super.clone();
            hmacSHA1.sha1 = (MessageDigest)this.sha1.clone();
            hmacSHA1.k_ipad = (byte[])this.k_ipad.clone();
            hmacSHA1.k_opad = (byte[])this.k_opad.clone();
            hmacSHA1.first = this.first;
            return hmacSHA1;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return hmacSHA1;
        }
    }

    protected byte[] engineDoFinal() {
        if (this.first) {
            this.sha1.update(this.k_ipad);
        } else {
            this.first = true;
        }
        byte[] byArray = this.sha1.digest();
        this.sha1.update(this.k_opad);
        return this.sha1.digest(byArray);
    }

    protected int engineGetMacLength() {
        return this.sha1.getDigestLength();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null || !(key instanceof SecretKey)) {
            throw new InvalidKeyException("Secret key expected");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Missing key data");
        }
        if (byArray.length > 64) {
            byArray = this.sha1.digest(byArray);
        }
        byte[] byArray2 = new byte[64];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n = 64 - byArray.length;
        while (n < 64) {
            byArray2[n] = 0;
            ++n;
        }
        n = 0;
        while (n < 64) {
            this.k_ipad[n] = (byte)(byArray2[n] ^ 0x36);
            this.k_opad[n] = (byte)(byArray2[n] ^ 0x5C);
            ++n;
        }
        n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
        n = 0;
        while (n < byArray2.length) {
            byArray2[n] = 0;
            ++n;
        }
        byArray = null;
        byArray2 = null;
    }

    protected void engineReset() {
        this.sha1.reset();
        this.first = true;
    }

    protected void engineUpdate(byte by) {
        if (this.first) {
            this.sha1.update(this.k_ipad);
            this.first = false;
        }
        this.sha1.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (this.first) {
            this.sha1.update(this.k_ipad);
            this.first = false;
        }
        this.sha1.update(byArray, n, n2);
    }
}

