/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ExemptionMechanismSpi;
import javax.crypto.ShortBufferException;
import javax.crypto.b;
import javax.crypto.u;

public class ExemptionMechanism {
    private Provider provider;
    private ExemptionMechanismSpi exmechSpi;
    private String mechanism;
    private boolean done = false;
    private boolean initialized = false;
    private Key keyStored = null;

    protected ExemptionMechanism(ExemptionMechanismSpi exemptionMechanismSpi, Provider provider, String string) {
        this.exmechSpi = exemptionMechanismSpi;
        this.provider = provider;
        this.mechanism = string;
    }

    protected void finalize() {
        this.keyStored = null;
    }

    public final byte[] genExemptionBlob() throws IllegalStateException, u {
        if (!this.initialized) {
            throw new IllegalStateException("ExemptionMechanism not initialized");
        }
        byte[] byArray = this.exmechSpi.engineGenExemptionBlob();
        this.done = true;
        return byArray;
    }

    public final int genExemptionBlob(byte[] byArray) throws IllegalStateException, ShortBufferException, u {
        if (!this.initialized) {
            throw new IllegalStateException("ExemptionMechanism not initialized");
        }
        int n2 = this.exmechSpi.engineGenExemptionBlob(byArray, 0);
        this.done = true;
        return n2;
    }

    public final int genExemptionBlob(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException, u {
        if (!this.initialized) {
            throw new IllegalStateException("ExemptionMechanism not initialized");
        }
        int n3 = this.exmechSpi.engineGenExemptionBlob(byArray, n2);
        this.done = true;
        return n3;
    }

    public static final ExemptionMechanism getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = b.a(string, "ExemptionMechanism", null);
            return new ExemptionMechanism((ExemptionMechanismSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
        }
    }

    public static final ExemptionMechanism getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = b.a(string, "ExemptionMechanism", string2);
        return new ExemptionMechanism((ExemptionMechanismSpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public final String getName() {
        return this.mechanism;
    }

    public final int getOutputSize(int n2) throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("ExemptionMechanism not initialized");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Input size must be equal to or greater than zero");
        }
        return this.exmechSpi.engineGetOutputSize(n2);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException, u {
        this.done = false;
        this.initialized = false;
        this.keyStored = key;
        this.exmechSpi.engineInit(key);
        this.initialized = true;
    }

    public final void init(Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException, u {
        this.done = false;
        this.initialized = false;
        this.keyStored = key;
        this.exmechSpi.engineInit(key, algorithmParameters);
        this.initialized = true;
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException, u {
        this.done = false;
        this.initialized = false;
        this.keyStored = key;
        this.exmechSpi.engineInit(key, algorithmParameterSpec);
        this.initialized = true;
    }

    public final boolean isCryptoAllowed(Key key) throws u {
        boolean bl = false;
        if (this.done && key != null) {
            bl = this.keyStored.equals(key);
        }
        return bl;
    }
}

