/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;

public class SecretKeySpec
implements KeySpec,
SecretKey {
    private byte[] a;
    private String b;

    public SecretKeySpec(byte[] byArray, int n2, int n3, String string) {
        if (byArray == null || string == null) {
            throw new IllegalArgumentException("Missing argument");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Empty key");
        }
        if (byArray.length - n2 < n3) {
            throw new IllegalArgumentException("Invalid offset/length combination");
        }
        this.a = new byte[n3];
        System.arraycopy(byArray, n2, this.a, 0, n3);
        this.b = string;
    }

    public SecretKeySpec(byte[] byArray, String string) {
        if (byArray == null || string == null) {
            throw new IllegalArgumentException("Missing argument");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Empty key");
        }
        this.a = (byte[])byArray.clone();
        this.b = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        String string = ((SecretKey)object).getAlgorithm();
        if (!(string.equalsIgnoreCase(this.b) || string.equalsIgnoreCase("DESede") && this.b.equalsIgnoreCase("TripleDES") || string.equalsIgnoreCase("TripleDES") && this.b.equalsIgnoreCase("DESede"))) {
            return false;
        }
        byte[] byArray = ((SecretKey)object).getEncoded();
        return Arrays.equals(this.a, byArray);
    }

    public String getAlgorithm() {
        return this.b;
    }

    public byte[] getEncoded() {
        return (byte[])this.a.clone();
    }

    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 1;
        while (n3 < this.a.length) {
            n2 += this.a[n3] * n3;
            ++n3;
        }
        if (this.b.equalsIgnoreCase("TripleDES")) {
            return n2 ^= "desede".hashCode();
        }
        return n2 ^= this.b.toLowerCase().hashCode();
    }
}

