/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.ClientDiffieHellmanPublic;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.ak;
import com.sun.net.ssl.internal.ssl.g;
import com.sun.net.ssl.internal.ssl.h;
import com.sun.net.ssl.internal.ssl.i;
import com.sun.net.ssl.internal.ssl.k;
import com.sun.net.ssl.internal.ssl.m;
import com.sun.net.ssl.internal.ssl.n;
import com.sun.net.ssl.internal.ssl.o;
import com.sun.net.ssl.internal.ssl.q;
import com.sun.net.ssl.internal.ssl.s;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;

final class ServerHandshaker
extends Handshaker {
    private boolean a;
    private boolean b = false;
    private X509Certificate[] c;
    private PrivateKey d;
    private PrivateKey e;
    private RSAPublicKey f;
    private s g;

    ServerHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, boolean bl2) throws NoSuchAlgorithmException {
        super(sSLSocketImpl, sSLContextImpl, bl2);
        this.a = bl2;
    }

    boolean a(int n2, boolean bl2) {
        if (this.k) {
            return true;
        }
        X509KeyManager x509KeyManager = ((Handshaker)this).g.d();
        if (n2 == 1 || n2 == 2 || n2 == 5) {
            String string = x509KeyManager.chooseServerAlias("RSA", null);
            if (string == null) {
                return false;
            }
            this.d = x509KeyManager.getPrivateKey(string);
            if (this.d == null) {
                return false;
            }
            this.c = x509KeyManager.getCertificateChain(string);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)this.c[0].getPublicKey();
            if (n2 == 2 && rSAPublicKey.getModulus().bitLength() > 512 && !this.b(bl2)) {
                return false;
            }
            if (n2 == 5) {
                this.a(bl2);
            }
            return this.d != null && this.d instanceof RSAPrivateKey;
        }
        if (n2 == 6) {
            String string = x509KeyManager.chooseServerAlias("DSA", null);
            if (string == null) {
                return false;
            }
            this.d = x509KeyManager.getPrivateKey(string);
            if (this.d == null) {
                return false;
            }
            this.c = x509KeyManager.getCertificateChain(string);
            this.a(bl2);
            return this.d != null;
        }
        if (n2 == 7) {
            this.a(bl2);
            return true;
        }
        return false;
    }

    protected boolean canUseCipherSuite(String string) {
        if (string.startsWith("SSL_RSA_")) {
            return this.a(1, false);
        }
        if (string.startsWith("SSL_DH_anon_")) {
            return this.a(7, false);
        }
        if (string.startsWith("SSL_DHE_DSS_")) {
            return this.a(6, false);
        }
        return false;
    }

    private boolean a(h h2, byte[] byArray) {
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < h2.e.length) {
            if (byArray[0] == h2.e[n2] && byArray[1] == h2.e[n2 + 1]) break;
            n2 += 2;
        }
        if (n2 < h2.e.length) {
            bl2 = this.a(byArray[0], byArray[1]);
        }
        return bl2;
    }

    private void a(h h2) throws IOException {
        int n2 = 0;
        while (n2 < h2.e.length) {
            if (this.a(h2.e[n2], h2.e[n2 + 1]) && (!this.a || this.o != 7)) break;
            n2 += 2;
        }
        if (n2 >= h2.e.length) {
            ((Handshaker)this).a.a((byte)40, "no cipher suites in common");
        }
    }

    private void a(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509TrustManager x509TrustManager;
        X509Certificate[] x509CertificateArray;
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            certificateMsg.a(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            ((Handshaker)this).a.a((byte)42, "null cert chain");
        }
        if ((x509TrustManager = ((Handshaker)this).g.e()).isClientTrusted(x509CertificateArray)) {
            this.j.a(x509CertificateArray);
        } else {
            ((Handshaker)this).a.a((byte)46, "untrusted client cert chain");
        }
    }

    private void a(o o2) throws IOException {
        boolean bl2 = false;
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            o2.a(System.out);
        }
        try {
            PublicKey publicKey = this.j.getPeerCertificateChain()[0].getPublicKey();
            try {
                bl2 = o2.a(((CipherSpec)this).b, publicKey, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), this.j.c());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                bl2 = o2.a(((CipherSpec)this).b, publicKey, ((Handshaker)this).b[2], ((Handshaker)this).c[2], this.j.c());
                ((Handshaker)this).b[2] = null;
                ((Handshaker)this).c[2] = null;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ((Handshaker)this).a.a((byte)43, "client cert type is unsupported");
        }
        catch (SignatureException signatureException) {
        }
        catch (InvalidKeyException invalidKeyException) {}
        if (!bl2) {
            ((Handshaker)this).a.a((byte)42, "client cert didn't verify");
        }
    }

    private void a(HandshakeMessage.Finished finished) throws IOException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            finished.a(System.out);
        }
        boolean bl2 = false;
        try {
            bl2 = ((CipherSpec)this).b == 0 ? finished.verify((MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), HandshakeMessage.Finished.c, this.j.c()) : finished.verify((MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), "client finished", this.j.c());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            bl2 = ((CipherSpec)this).b == 0 ? finished.verify(((Handshaker)this).b[1], ((Handshaker)this).c[1], HandshakeMessage.Finished.c, this.j.c()) : finished.verify(((Handshaker)this).b[1], ((Handshaker)this).c[1], "client finished", this.j.c());
            ((Handshaker)this).b[1] = null;
            ((Handshaker)this).c[1] = null;
        }
        if (!bl2) {
            ((Handshaker)this).a.a((byte)40, "client 'finished' message doesn't verify");
        }
        if (!this.k) {
            ((Handshaker)this).d.digestNow();
            this.c(false);
        }
        if (!this.k && this.j.e()) {
            ((Handshaker)this).g.c().a(this.j);
            if (Handshaker.m != null && Debug.isOn("session")) {
                System.out.println("%% Cached server session: " + this.j);
            }
        } else if (Handshaker.m != null && Debug.isOn("session")) {
            System.out.println("%% Didn't cache non-resumable server session: " + this.j);
        }
    }

    private void b(h h2) throws IOException {
        Object object;
        Object object2;
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            h2.a(System.out);
        }
        ((Handshaker)this).d.digestNow();
        i i2 = new i();
        if (h2.a != 3) {
            throw new SSLProtocolException("version mismatch, client is v" + h2.a + "." + h2.b);
        }
        i2.a = (byte)3;
        ((CipherSpec)this).a = h2.a;
        i2.b = h2.b > 1 ? (byte)1 : h2.b;
        ((CipherSpec)this).b = i2.b;
        ((Handshaker)this).a.a(((CipherSpec)this).a, ((CipherSpec)this).b);
        ((Handshaker)this).e.r.a(((CipherSpec)this).a, ((CipherSpec)this).b);
        this.h = h2.c;
        i2.c = this.i = new q(((Handshaker)this).g.b());
        if (h2.d.b() != 0) {
            if (this.j != null && !this.b && !h2.d.equals(this.j.d())) {
                throw new SSLException("Client cannot change existing session");
            }
            this.j = null;
            object2 = ((Handshaker)this).g.c().a(h2.d.a());
            if (object2 != null) {
                object = ((SSLSessionImpl)object2).a().getCipherSuite();
                this.k = ((SSLSessionImpl)object2).e();
                if (this.k) {
                    this.k = this.a(h2, (byte[])object);
                }
                if (this.k && this.a) {
                    try {
                        ((SSLSessionImpl)object2).getPeerCertificateChain();
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        this.k = false;
                    }
                }
                if (this.k) {
                    this.j = object2;
                    if (Handshaker.m != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                        System.out.println("%% Resuming " + this.j);
                    }
                }
            }
        } else {
            if (this.j != null && !this.b) {
                throw new SSLException("Client cannot change existing session");
            }
            this.j = null;
        }
        if (this.j == null) {
            if (!this.l) {
                throw new SSLException("Client did not resume a session");
            }
            this.j = new SSLSessionImpl((CipherSpec)this, ((Handshaker)this).g.b(), ((Handshaker)this).a.getInetAddress().getHostAddress(), ((Handshaker)this).a.getPort());
            this.a(h2);
        }
        i2.e = this.j.a().getCipherSuite();
        i2.d = this.j.d();
        i2.f = this.j.b();
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            i2.a(System.out);
            System.out.println("Cipher suite:  " + this.j.a());
        }
        i2.write(((Handshaker)this).e);
        if (this.k) {
            try {
                this.a(this.j.c());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SSLException("Missing algorithm: " + noSuchAlgorithmException.getMessage());
            }
            this.c(true);
            return;
        }
        if (this.o != 7) {
            if (this.c == null) {
                throw new SSLException("internal error, no certs!");
            }
            object2 = new HandshakeMessage.CertificateMsg(this.c);
            if (Handshaker.m != null && Debug.isOn("handshake")) {
                ((HandshakeMessage.CertificateMsg)object2).a(System.out);
            }
            ((HandshakeMessage)object2).write(((Handshaker)this).e);
        }
        boolean bl2 = false;
        if (this.c == null) {
            bl2 = true;
        } else {
            switch (this.o) {
                case 1: 
                case 2: {
                    if (this.o != 2 || ((RSAPrivateKey)this.d).getModulus().bitLength() <= 512) break;
                    bl2 = true;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    bl2 = true;
                    break;
                }
                default: {
                    throw new SSLException("unsupported server key exchange " + this.o);
                }
                case 3: 
                case 4: 
            }
        }
        if (bl2) {
            switch (this.o) {
                case 1: 
                case 2: {
                    try {
                        if (this.c == null) {
                            throw new SSLException("Anonymous RSA not supported");
                        }
                        object = new k(this.f, this.d, this.h, this.i);
                        this.d = this.e;
                        break;
                    }
                    catch (SignatureException signatureException) {
                        throw new SSLException("Internal error, " + signatureException);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new SSLException("Algorithm missing, " + noSuchAlgorithmException);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw new SSLException("Bad RSA key, " + invalidKeyException);
                    }
                }
                case 7: {
                    object = new HandshakeMessage.DH_ServerKeyExchange(this.g);
                    break;
                }
                case 5: 
                case 6: {
                    try {
                        object = new HandshakeMessage.DH_ServerKeyExchange(this.g, this.d, this.h.a, this.i.a);
                        break;
                    }
                    catch (SignatureException signatureException) {
                        throw new SSLException("Internal error, " + signatureException);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw new SSLException("Bad RSA or DSS key, " + invalidKeyException);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new SSLException("Algorithm missing, " + noSuchAlgorithmException);
                    }
                }
                default: {
                    throw new SSLException("unsupported server key exchange " + this.o);
                }
            }
            if (Handshaker.m != null && Debug.isOn("handshake")) {
                ((HandshakeMessage)object).a(System.out);
            }
            ((HandshakeMessage)object).write(((Handshaker)this).e);
        }
        if (this.a) {
            X509Certificate[] x509CertificateArray = ((Handshaker)this).g.e().getAcceptedIssuers();
            object = new m(x509CertificateArray, this.o);
            if (Handshaker.m != null && Debug.isOn("handshake")) {
                ((m)object).a(System.out);
            }
            ((HandshakeMessage)object).write(((Handshaker)this).e);
        }
        object = new n();
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            ((n)object).a(System.out);
        }
        ((HandshakeMessage)object).write(((Handshaker)this).e);
        ((Handshaker)this).e.flush();
    }

    private byte[] a(ClientDiffieHellmanPublic clientDiffieHellmanPublic) throws IOException, NoSuchAlgorithmException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            clientDiffieHellmanPublic.a(System.out);
        }
        return this.g.a(clientDiffieHellmanPublic.getClientPublicKey());
    }

    private byte[] a(ak ak2) throws IOException, NoSuchAlgorithmException {
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            ak2.a(System.out);
        }
        if (ak2.a != ((CipherSpec)this).a || ak2.b != ((CipherSpec)this).b) {
            throw new SSLProtocolException("Incorrect RSA Key Exchange");
        }
        return ak2.c;
    }

    private void a(boolean bl2) {
        if (!bl2) {
            this.g = new s();
            this.g.a(((Handshaker)this).g.b(), 768);
        } else {
            this.g = new s(com.sun.net.ssl.internal.ssl.s.i, com.sun.net.ssl.internal.ssl.s.j);
            this.g.a(((Handshaker)this).g.b(), 512);
        }
    }

    private boolean b(boolean bl2) {
        Object var2_2 = null;
        try {
            int n2 = !bl2 ? 1024 : 512;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(n2, ((Handshaker)this).g.b());
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            this.f = (RSAPublicKey)keyPair.getPublic();
            this.e = keyPair.getPrivate();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected HandshakeMessage getKickstartMessage() {
        return new g();
    }

    void a(byte by2) throws SSLProtocolException {
        String string = SSLSocketImpl.b(by2);
        if (Handshaker.m != null && Debug.isOn("handshake")) {
            System.out.println("SSL -- handshake alert:  " + string);
        }
        throw new SSLProtocolException("handshake alert:  " + string);
    }

    protected void processMessage(byte by2, int n2) throws IOException, NoSuchAlgorithmException {
        if (((Handshaker)this).f > by2 && ((Handshaker)this).f != 16 && by2 != 15) {
            throw new SSLProtocolException("Handshake message sequence violation, state = " + ((Handshaker)this).f + ", type = " + by2);
        }
        switch (by2) {
            case 1: {
                this.b(new h(((Handshaker)this).d));
                break;
            }
            case 11: {
                if (!this.a) {
                    ((Handshaker)this).a.a((byte)10, "client sent unsolicited cert chain");
                }
                this.a(new HandshakeMessage.CertificateMsg(((Handshaker)this).d));
                break;
            }
            case 16: {
                byte[] byArray;
                switch (this.o) {
                    case 1: 
                    case 2: {
                        byArray = this.a(new ak(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).g.b(), ((Handshaker)this).d, n2, this.d));
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        byArray = this.a(new ClientDiffieHellmanPublic(((Handshaker)this).d));
                        break;
                    }
                    default: {
                        throw new SSLProtocolException("unsupported key exchange algorithm = " + this.o);
                    }
                }
                this.b(byArray);
                int n3 = 0;
                while (n3 < byArray.length) {
                    byArray[n3] = 0;
                    ++n3;
                }
                break;
            }
            case 15: {
                this.a(new o(((Handshaker)this).d));
                break;
            }
            case 20: {
                this.a(new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).d));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal server handshake msg, " + by2);
            }
        }
        if (((Handshaker)this).f < by2 && by2 != 15) {
            ((Handshaker)this).f = by2;
        }
    }

    private void c(boolean bl2) throws IOException {
        HandshakeMessage.Finished finished;
        block3: {
            ((Handshaker)this).e.flush();
            try {
                finished = ((CipherSpec)this).b == 0 ? new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), HandshakeMessage.Finished.d, this.j.c()) : new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), "server finished", this.j.c());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                finished = ((CipherSpec)this).b == 0 ? new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).b[0], ((Handshaker)this).c[0], HandshakeMessage.Finished.d, this.j.c()) : new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).b[0], ((Handshaker)this).c[0], "server finished", this.j.c());
                if (bl2 && this.k) break block3;
                ((Handshaker)this).b[0] = null;
                ((Handshaker)this).c[0] = null;
            }
        }
        this.sendChangeCipherSpec(finished);
        if (!bl2 || !this.k) {
            ((Handshaker)this).f = 20;
        }
    }
}

