/**
   SSLContext.c

   Copyright (C) 1999, RTFM, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Tue Jun  8 20:52:21 1999
 */


static char *RCSSTRING="$Id: SSLContext.c,v 1.1.1.1 1999/06/17 18:49:02 ekr Exp $";

#include "COM_claymore_sslg_openssl_SSLContext.h"
#include <stdio.h>
#include <openssl/ssl.h>
#include <native_common.h>

#define DH_PARAM "server.pem"

static char *password=0;
static int initialized=0;
static DH *dh;
BIO *bio_err;


static void destroy_c_SSLContext(c_SSLContext *ctx);
static int password_cb(char *buf,int num,int rwflag);
static void set_passwd_cb(JNIEnv *env,jstring pass,c_SSLContext *ctx);

JNIEXPORT void JNICALL Java_COM_claymore_sslg_openssl_SSLContext_loadRootCertificates
(JNIEnv *env, jobject thisObj, jstring path)
  {
    STACK_OF(X509_NAME) *certs;
    char *utf_string;
    jboolean isCopy;
    c_SSLContext *ctx;
    EXCEPT_DECL;

    if(!(ctx=get_context(env,thisObj)))
      return;

    utf_string=(*env)->GetStringUTFChars(env,path,&isCopy);

    certs=SSL_load_client_CA_file(utf_string);

    if(!certs)
      THROW("java/io/FileNotFoundException","CA file not found");
    SSL_CTX_set_client_CA_list(ctx->ctx,certs);
    
  thrown:
    if(isCopy)
      free(utf_string);
    EXCEPT_HANDLE;
  }

JNIEXPORT void JNICALL Java_COM_claymore_sslg_openssl_SSLContext_loadPKCS12File
  (JNIEnv *env, jobject thisObj, jstring path, jstring pass)
  {
    printf("Called loadPKCS12File\n");
  }

JNIEXPORT void JNICALL Java_COM_claymore_sslg_openssl_SSLContext_loadEAYKeyFile
  (JNIEnv *env, jobject thisObj, jstring path, jstring pass)
  {
    char *utf_string;
    jboolean isCopy;
    c_SSLContext *ctx;
    EXCEPT_DECL;
    int sid_ctx=1;
    
    if(!(ctx=get_context(env,thisObj)))
      return;

    set_passwd_cb(env,pass,ctx);
    utf_string=(*env)->GetStringUTFChars(env,path,&isCopy);

    if(SSL_CTX_use_certificate_file(ctx->ctx,utf_string,
      SSL_FILETYPE_PEM)<=0)
      THROW("java/io/FileNotFoundException","Couldn't read cert file");
    if(SSL_CTX_use_PrivateKey_file(ctx->ctx,utf_string,
      SSL_FILETYPE_PEM)<=0)
      THROW("java/io/FileNotFoundException","Couldn't read cert file");
    if(!SSL_CTX_check_private_key(ctx->ctx))
      THROW("java/lang/InternalError","Private key doesn't match cert");

    /* This is wacky*/
    SSL_CTX_set_session_id_context(ctx->ctx,(void*)&sid_ctx,sizeof sid_ctx);
    
  thrown:
    if(isCopy)
      free(utf_string);
    EXCEPT_HANDLE;
  }

JNIEXPORT jlong JNICALL Java_COM_claymore_sslg_openssl_SSLContext_createSSLContext
(JNIEnv *env, jobject thisObj)
  {
    c_SSLContext *cctx=0;
    SSL_METHOD *meth;
    
    if(!(cctx=(c_SSLContext *)calloc(sizeof(c_SSLContext),1))){
      fprintf(stderr,"Out of memory!\n");
      return(0);
    }
    meth=TLSv1_server_method();
    if(!initialized) {
      initialized=1;
      SSL_load_error_strings();
      SSL_library_init();
      dh=get_dh512();
      bio_err=BIO_new_fp(stderr,BIO_NOCLOSE);
    }
    
    if(!(cctx->ctx=SSL_CTX_new(meth))){
      destroy_c_SSLContext(cctx);
      fprintf(stderr,"Couldn't create SSL context\n");
      return(0);
    }

    SSL_CTX_set_options(cctx->ctx,0);
    SSL_CTX_sess_set_cache_size(cctx->ctx,128);
    SSL_CTX_set_tmp_dh(cctx->ctx,dh);
    SSL_CTX_set_cipher_list(cctx->ctx,"EDH-DSS-DES-CBC-SHA:EDH-DSS-DES-CBC3-SHA");
    
    return ((jlong)cctx);
  }

JNIEXPORT void JNICALL Java_COM_claymore_sslg_openssl_SSLContext_destroySSLContext
(JNIEnv *env, jobject thisObj, jlong _ctx)
  {
    destroy_c_SSLContext((c_SSLContext *)_ctx);
  }

/*This is all pretty grotty. Lookup the cipher by cipher number, cons up
  a string, and call SSL_CTX_set_cipher_list() on the whole mess*/
JNIEXPORT void JNICALL Java_COM_claymore_sslg_openssl_SSLContext_setCipherSuites
  (JNIEnv *env, jobject thisObj, jshortArray cs)
  {
    char buf[2048];
    int left=2047;
    char c_bytes[2];
    SSL_CIPHER *cipher;
    jshort *csp;
    char *name;
    int len,i;
    jboolean isCopy=JNI_FALSE;
    EXCEPT_DECL;
    
    c_SSLContext *ctx;
    
    if(!(ctx=get_context(env,thisObj)))
      return;

    buf[0]=0;
    
    csp=(jshort *)(*env)->GetShortArrayElements(env,cs,&isCopy);
    len=(*env)->GetArrayLength(env,cs);

    for(i=0;i<len;i++){
      if(buf[0]){
	if(left>=1){
	  strcat(buf,":");
	  left--;
	}
	else{
	  THROW("java/lang/InternalError","Cipher list too long");
	}
      }
      
      c_bytes[0]=(csp[i] >> 8) & 0xff;
      c_bytes[1]=csp[i] & 0xff;
      
      if(!(cipher=ssl3_get_cipher_by_char(c_bytes)))
	continue;
      name=SSL_CIPHER_get_name(cipher);
      if(strlen(name)>left)
	THROW("java/lang/InternalError","Cipher list too long");
      strcat(buf,name);
      left-=strlen(name);
    }

    printf("Cipher list %s\n",buf);
    
    SSL_CTX_set_cipher_list(ctx->ctx,buf);
      
  thrown:
    if(isCopy==JNI_TRUE)
      (*env)->ReleaseShortArrayElements(env,cs,csp,JNI_ABORT);
    EXCEPT_HANDLE;
  }

/* We check this stuff later*/
static int verify_cb(int ok, X509_STORE_CTX *ctx){
  return(1);
}
       
JNIEXPORT void JNICALL Java_COM_claymore_sslg_openssl_SSLContext_setClientAuth
  (JNIEnv *env, jobject thisObj, jboolean set)
  {
    c_SSLContext *ctx;
    
    if(!(ctx=get_context(env,thisObj)))
      return;
    if(set == JNI_TRUE){
      SSL_CTX_set_verify(ctx->ctx,SSL_VERIFY_PEER|
	SSL_VERIFY_FAIL_IF_NO_PEER_CERT|
	SSL_VERIFY_CLIENT_ONCE,verify_cb);
      SSL_CTX_set_verify_depth(ctx->ctx,-1);
    }
  }
  

/* Internals*/
static void destroy_c_SSLContext(c_SSLContext *ctx)
  {
    if(!ctx)
      return;
    if(ctx->ctx)
      SSL_CTX_free(ctx->ctx);
  }

/*The password code is not thread safe*/
static int password_cb(char *buf,int num,int rwflag)
  {
/*    printf("Password callback pass='%s'\n",password);*/
    
    if(num<strlen(password)+1)
      return(0);

    strcpy(buf,password);
    return(strlen(password));
  }

static void set_passwd_cb(JNIEnv *env,jstring pass,c_SSLContext *ctx)
  {
    char *utf_string;
    jboolean isCopy;
    
    utf_string=(*env)->GetStringUTFChars(env,pass,&isCopy);

    if(!password||strcmp(password,utf_string)){
      if(password) free(password);
      password=(char *)strdup(utf_string);
    }

    if(isCopy)
      free(utf_string);

    SSL_CTX_set_default_passwd_cb(ctx->ctx,password_cb);
  }

#ifndef NO_DH
static unsigned char dh512_p[]={
	0xDA,0x58,0x3C,0x16,0xD9,0x85,0x22,0x89,0xD0,0xE4,0xAF,0x75,
	0x6F,0x4C,0xCA,0x92,0xDD,0x4B,0xE5,0x33,0xB8,0x04,0xFB,0x0F,
	0xED,0x94,0xEF,0x9C,0x8A,0x44,0x03,0xED,0x57,0x46,0x50,0xD3,
	0x69,0x99,0xDB,0x29,0xD7,0x76,0x27,0x6B,0xA2,0xD3,0xD4,0x12,
	0xE2,0x18,0xF4,0xDD,0x1E,0x08,0x4C,0xF6,0xD8,0x00,0x3E,0x7C,
	0x47,0x74,0xE8,0x33,
	};
static unsigned char dh512_g[]={
	0x02,
	};

static DH *get_dh512(void)
	{
	DH *dh=NULL;

	if ((dh=DH_new()) == NULL) return(NULL);
	dh->p=BN_bin2bn(dh512_p,sizeof(dh512_p),NULL);
	dh->g=BN_bin2bn(dh512_g,sizeof(dh512_g),NULL);
	if ((dh->p == NULL) || (dh->g == NULL))
		return(NULL);
	return(dh);
	}
#endif
