/**
   EAYEncryptedPrivateKey.java

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Thu Jun  3 21:03:14 1999

   This package is a SSLv3/TLS implementation written by Eric Rescorla
   <ekr@rtfm.com> and licensed by Claymore Systems, Inc.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. All advertising materials mentioning features or use of this software
      must display the following acknowledgement:
      This product includes software developed by Claymore Systems, Inc.
   4. Neither the name of Claymore Systems, Inc. nor the name of Eric
      Rescorla may be used to endorse or promote products derived from this
      software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.

   $Id: EAYEncryptedPrivateKey.java,v 1.8 1999/10/08 00:17:01 ekr Exp $

*/


package COM.claymoresystems.crypto;
import COM.claymoresystems.cert.EAYDSAPrivateKey;
import COM.claymoresystems.cert.EAYRSAPrivateKey;

import java.security.PrivateKey;

import java.io.*;


public class EAYEncryptedPrivateKey {
     private static final String DSA_STRING="DSA";
     private static final String RSA_STRING="RSA";     
     
     public static PrivateKey createPrivateKey(BufferedReader in,String type,
       byte[] password)
       throws IOException,IllegalArgumentException {

       byte[] plainKey=PEMData.readPEMObject(in,password);

       // TODO: table to look up key types
       if(type.equals(DSA_STRING))
	 return new EAYDSAPrivateKey(plainKey);
       else if(type.equals(RSA_STRING))
	 return new EAYRSAPrivateKey(plainKey);
       else
	 throw new InternalError("Couldn't find key type" + type);

       
     }

     public static void writePrivateKey(PrivateKey priv,byte[] password,
       BufferedWriter out)
       throws IOException {
       String keyType=priv.getAlgorithm();

       // Extract the encoding of the key using getEncoded()
       byte[] rawPrivate=priv.getEncoded();

       String type=keyType + " PRIVATE KEY";
       PEMData.writePEMObject(rawPrivate,password,type,out);
     }
}
	 

       
       
	 
	 
       


       


       
