

/**
   ClientBench.java -- client benchmark code

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Thu Sep  9 11:33:58 1999
*/

package COM.claymoresystems.ptls.benchmark;
import COM.claymoresystems.ptls.*;
import COM.claymoresystems.cert.*;
import COM.claymoresystems.sslg.*;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.security.SecureRandom;
import java.io.*;
import java.util.Vector;
import java.net.Socket;

class ClientBench extends SockBench{
     private void testConn(Socket s)
       throws IOException {
       try {
	 byte buf[]=new byte[4096];

	 BufferedInputStream br=new BufferedInputStream(s.getInputStream());
	 BufferedOutputStream bw=new BufferedOutputStream(s.getOutputStream());	 

	 for(int i=0;i<msgCount;i++){
	   writeMessage(bw);
	   readMessage(br);
	 }
	   
	 if(exitForClose)
	   return;
	 
	 if(verbose)
	   System.out.println("Closing");
	 s.close();
       }       
       catch (SSLAlertException e){
	 throw new Error(e.toString());
       }
     }
     
     public ClientBench (String []args)
	  throws IOException {
       super("Client",args);

       try {
	 if(verbose)
	   System.out.println("Creating SSLContext");
	 SSLContext ctx=new SSLContext();
	 if(verbose)
	   System.out.println("Created SSLContext");
	 
	 ctx.loadRootCertificates(rootfile);

	 ctx.loadEAYKeyFile(keyfile,password);

	 ctx.seedRNG(null);

	 while(iterate--!=0){
//	   System.out.println("Time: "+System.currentTimeMillis());
	   Socket s;

	   if(verbose)
	     System.out.println("Connecting");
	   
	   if(useNormalSockets){
	     s=new Socket(host,port);
	   }
	   else {
	     s=new SSLSocket(ctx,host,port);
	   }
	   if(verbose)
	     System.out.println("Connected");
	   
	   testConn(s);
	   
	 }
       } catch (Exception e){
	 e.printStackTrace();
       }
     }

     public static void main(String args[])
       throws IOException {
       ClientBench cb=new ClientBench(args);

       dump();
     }
}

