/**
   ServerBench.java  -- server benchmark code

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Thu Sep  9 11:21:00 1999
*/

package COM.claymoresystems.ptls.benchmark;
import COM.claymoresystems.ptls.*;
import COM.claymoresystems.cert.*;
import COM.claymoresystems.sslg.*;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.security.SecureRandom;
import java.io.*;
import java.util.Vector;
import java.net.Socket;
import java.net.ServerSocket;


class ServerBench extends SockBench {
     
     private void webServe(Socket s)
       throws IOException {
       BufferedInputStream br=new BufferedInputStream(s.getInputStream());
       BufferedOutputStream bw=new BufferedOutputStream(s.getOutputStream());	 
       while(true){
	 byte[] buf=readMessage(br);

	 if(buf==null)
	   break;
	 writeMessage(bw);
       }
       
       s.close();
     }

     
     public ServerBench(String[] args)
       throws IOException {
       super("Server",args);

       msgSize=2048;
       
       SSLContext ctx=new SSLContext();
       
       //seed the RNG with fake randomness
       ctx.seedRNG(null);

       ctx.loadDHParams("dh1024.pem");

       ServerSocket sock;
       
//       ctx.loadRootCertificates(rootfile);
       ctx.loadEAYKeyFile(keyfile,password);

       if(useNormalSockets){
	 sock=new ServerSocket(port);
       }
       else{
	 sock=new SSLServerSocket(ctx,port);
       }

       SSLPolicyInt policy=new SSLPolicyInt();

       short[] algs=new short[1];
       algs[0]=(short)(algorithm & 0xffff);
       policy.setCipherSuites(algs);
       policy.requireClientAuth(clientauth);
       ctx.setPolicy(policy);

       while(iterate--!=0){
	 Socket s=sock.accept();
	 webServe(s);
       }
       
     }

     public static void main(String[] args) throws IOException {
       ServerBench sb=new ServerBench(args);
     }
}
