

/**
   SocketBench.java

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Thu Sep  9 11:46:34 1999
*/
package COM.claymoresystems.ptls.benchmark;
import COM.claymoresystems.util.*;
import COM.claymoresystems.sslg.*;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import sun.misc.VM;
import java.io.*;

class SockBench extends Bench {
     protected String host="localhost";
     protected int port=4433;
     protected String keyfile="server.pem";
     protected String rootfile="root.pem";
     protected String password="password";
     protected int iterate=5;
     protected boolean useNormalSockets=false;
     protected boolean clientauth=false;
     protected boolean profile=false;
     protected int msgSize=1024;
     protected int msgCount=20;
     protected byte[] msg=null;
     protected boolean verbose=false;
     protected boolean exitForClose;
     protected int algorithm=SSLPolicyInt.TLS_DHE_DSS_WITH_DES_CBC_SHA;
     
     SockBench(String prog,String[] args){
       int c;
       
       Getopt g=new Getopt(prog,args,"psi:m:M:vna:",null);

       while((c=g.getopt())!=-1)
	 switch(c){
	   case 'v':
	     verbose=true;
	     break;
	   case 'i':
	     iterate=Integer.parseInt(g.getOptarg());
	     break;
	   case 's':
	     useNormalSockets=true;
	     break;
	   case 'm':
	     msgSize=Integer.parseInt(g.getOptarg());
	     break;
	   case 'M':
	     msgCount=Integer.parseInt(g.getOptarg());
	     break;
	   case 'n':
	     exitForClose=true;
	     iterate=1;
	     break;
	   case 'a':
	     algorithm=Integer.parseInt(g.getOptarg());
	     break;
	   default:
	     System.out.println("Bad argument "+c);
	     throw new InternalError();
	 }

       register("socketWrite");
       register("ourWrite");
     }
     
     protected byte[] getMessage(){
       if(msg!=null)
	 return msg;

       msg=new byte[msgSize];
       msg[0]=(byte)((msgSize >> 8) & 0xff);
       msg[1]=(byte)(msgSize & 0xff);

       for(int i=2;i<msgSize;i++){
	 msg[i]=(byte)(i&0xff);
       }

       return msg;
     }

     protected byte[] readMessage(BufferedInputStream s)
       throws IOException {
       byte[] len=new byte[2];
       int r;
       
       r=s.read(len);

       if(r==-1)
	 return null;

       if(r!=2)
	 throw new InternalError("Short read "+r);

       int l=(len[0]<<8) | (len[1]);

       byte[] buf=new byte[l];

       int left=l-2;
       int off=0;

       if(verbose)
	 System.out.println("Length="+l);
       while(left>0){
	 r=s.read(buf,off,left);
	 left-=r;
	 off+=r;

	 if(verbose)
	   System.out.println("Read "+r+"bytes (partial)");
	 if(r==0)
	   throw new InternalError();
       }

       if(verbose)
	 System.out.println("Read "+l+"bytes");
       return buf;
     }

     protected void writeMessage(BufferedOutputStream s)
       throws IOException{
       byte[] message=getMessage();

       start(2);
       s.write(message);
       s.flush();
       end(2);
       if(verbose)
	 System.out.println("Wrote "+message.length+" bytes");
     }
}
     
     
