#!/usr/local/bin/perl
require 'getopts.pl';
$PWD=`pwd`;
chop($PWD);
$GONATIVEVER="1b1";
$GONATIVEDIR="$PWD/../../gnp-${GONATIVEVER}/gnp-$GONATIVEVER";
$CP=".:./puretls.jar:/usr/local/jdk1.1.8/lib:/users/ekr/src/java/Cryptix/build/classes:/users/ekr/src/java/Cryptix/src";

&Getopts("IN:");
	
$GONATIVEDIR=$opt_N if $opt_N;
$CP.=":/users/ekr/java" if $opt_I;

$CLIENT_AUTH=1;
$CLIENT_NATIVE=2;
$SERVER_NATIVE=4;
$USE_DH=8;

$MAX=15;

$ENV{'LD_LIBRARY_PATH'}.=":$GONATIVEDIR";

$STOP=0;

for($i=0;$i<=$MAX;$i++){
  # Exclusions
  if (($i & $CLIENT_AUTH) && !($i & USE_DH)) {
    print "Don't generate DH and do client auth\n";
    next;
  }
  if($i & ($SERVER_NATIVE | $CLIENT_NATIVE)){
    if(!(-f "$GONATIVEDIR/gonative.jar")){
      print "GoNative provider not found\n";
      next;
    }
  }
  print "\nRun $i\n";
  &run_server($i);
  sleep(10);
  &run_client($i);
  die("Error") if $STOP;

  &check_server();
}

sub run_client {
  print("Running client\n");
  &set_path($i & $CLIENT_NATIVE);
						
  print "Client classpath=$ENV{'CLASSPATH'}\n";
  $command="java COM.claymoresystems.ptls.demo.SSLClient -f -i 2";

  open(IN,"$command 2>&1 |");
  while(<IN>){
    if(/Exception/ || /Error/){
      $STOP=1;
    }

    print "C: $_";
  }

  die("Error!") if ($except);
}

sub run_server {
  &set_path($i & $SERVER_NATIVE);

  print "Server classpath=$ENV{'CLASSPATH'}\n";
  local($command)="java COM.claymoresystems.ptls.demo.SSLServer -f -i 2";
  $command.=" -D dh1024.pem" if ($i & $USE_DH);
  $command.=" -c" if ($i & $CLIENT_AUTH);
  print "Server	command $command\n";
  open(SERVER,"$command |");
}

sub set_path {
  local($native)=@_;
  local($path)=$CP;

  if($native){
    $path.=":$GONATIVEDIR/gonative.jar"
  }

  $ENV{'CLASSPATH'}=$path;
}

sub check_server {
  while(<SERVER>){
    if(/Exception/ || /Error/){
      $STOP=1;
    }

    print "S: $_";
  }

  die("Error!") if $except;
}
