
#ifdef LINUX2
#define HAVE_DAEMON
#define HAVE_GETRUSAGE
#define PATH_TMP	"/tmp"
#define PATH_VAR_TMP	"/var/tmp"
#define PATH_PASSWD	"/etc/passwd"
#define PATH_WTMP	"/var/log/wtmp"
#define PATH_UTMP	"/var/run/utmp"
#define PATH_SYSLOG	"/var/log/messages"
#define PATH_MAILLOG	"/var/log/mail"
#endif

#ifdef HPUX10
#define HAVE_GETRUSAGE
#define PATH_TMP	"/tmp"
#define PATH_VAR_TMP	"/var/tmp"
#define PATH_PASSWD	"/etc/passwd"
#define PATH_WTMP	"/var/adm/wtmp"
#define PATH_UTMP	"/etc/utmp"
#define PATH_SYSLOG	"/var/adm/syslog/syslog.log"
#define PATH_MAILLOG	"/var/adm/syslog/mail.log"
#endif

#ifdef TRU64
#define HAVE_GETRUSAGE
#define SIZEOF_IS_LONG_INT
#define PATH_TMP	"/tmp"
#define PATH_VAR_TMP	"/var/tmp"
#define PATH_PASSWD	"/etc/passwd"
#define PATH_WTMP	"/var/adm/wtmp"
#define PATH_UTMP	"/var/adm/utmp"
#define PATH_SYSLOG	"/var/adm/syslog.dated/current/daemon.log"
#define PATH_MAILLOG	"/var/adm/syslog.dated/current/mail.log"
#endif

#ifdef SUNOS
#define HAVE_GETRUSAGE
#define PID_T_IS_LONG_INT
#define PATH_TMP        "/tmp"
#define PATH_VAR_TMP    "/var/tmp"
#define PATH_PASSWD     "/etc/passwd"
#define PATH_WTMP       "/var/adm/wtmp"
#define PATH_UTMP       "/etc/utmp"
#define PATH_SYSLOG     "/var/log/syslog"
#endif

#ifdef NEXTSTEP3
/* not supported */
#define SA_RESTART 0
#define O_RSYNC 0
#ifdef NEXTSTEP3_HPPA
/* replace with corresponding bsd call */
#define setsid() setpgrp(0, getpid())
#else /* NEXTSTEP3_HPPA */
/* select, ftruncate, fchmod */
#include <libc.h>
#endif /* NEXTSTEP3_HPPA */
/* in ansi string.h but undefined in -posix */
#define bzero(b,len) memset(b,0,len)
#ifndef FD_CLOEXEC
#define FD_CLOEXEC	1
#endif
#define SIZEOF_IS_LONG_INT
#define HAVE_GETRUSAGE
#define PATH_TMP        "/private/tmp"
#define PATH_PASSWD     "/etc/passwd"
#define PATH_WTMP       "/private/adm/wtmp"
#define PATH_UTMP       "/private/etc/utmp"
#define PATH_SYSLOG     "/private/adm/messages"
#endif

#ifdef IRIX62
#define HAVE_GETRUSAGE
#define PID_T_IS_LONG_INT
#define PATH_TMP        "/tmp"
#define PATH_VAR_TMP	"/var/tmp"
#define PATH_PASSWD     "/etc/passwd"
#define PATH_WTMP       "/var/adm/wtmpx"
#define PATH_UTMP       "/var/adm/utmpx"
#define PATH_SYSLOG     "/var/adm/SYSLOG"
#endif

#ifdef AIX43
#if defined(__64BIT_KERNEL) && defined(_KERNEL)
#define PID_T_IS_LONG_INT
#endif /* __64BIT_KERNEL && _KERNEL */
#define SIZEOF_IS_LONG_INT
#define HAVE_GETRUSAGE
#define PATH_TMP	"/tmp"
#define PATH_VAR_TMP	"/var/tmp"
#define PATH_PASSWD	"/etc/passwd"
#define PATH_WTMP	"/var/adm/wtmp"
#define PATH_UTMP	"/etc/utmp"
#define PATH_SYSLOG	"/var/adm/messages"
#define PATH_MAILLOG	"/var/spool/mqueue/syslog"
#endif

#ifdef UNIXWARE7
#define HAVE_GETRUSAGE
#define PID_T_IS_LONG_INT
#define O_RSYNC		0
#define PATH_TMP        "/tmp"
#define PATH_VAR_TMP    "/var/tmp"
#define PATH_PASSWD     "/etc/passwd"
#define PATH_WTMP       "/var/adm/wtmp"
#define PATH_UTMP       "/etc/utmp"
#define PATH_SYSLOG     "/var/adm/syslog"
/*
 * Strange thing on Unixware 7, sockets manifest itself as FIFOs
 * John Hughes <john@Calva.COM>
 */
#ifdef S_ISSOCK
#undef S_ISSOCK
#define	S_ISSOCK	S_ISFIFO
#endif
#endif

#ifndef RANDSAVENAME
#define RANDSAVENAME	"/etc/prngd-seed"
#endif
#ifndef CONFIGFILE
#define CONFIGFILE	"/etc/prngd.conf"
#endif

#define BITS_PER_BYTE	8

/*
 * If not available, we cannot perform the check and will always succeed.
 */
#ifndef S_ISSOCK
#define S_ISSOCK(m)	(1)
#endif

/*
 * Some platforms don't have the SHUT_* macros
 */
#ifndef SHUT_RDWR
#define SHUT_RDWR	2
#endif

/*
 * The pool size of the OpenSSL PRNG
 */
#define PRNGD_STATE_SIZE	(1024 * 4)

#ifndef SEED_STAT_INTERVAL
#define SEED_STAT_INTERVAL	17
#endif
#ifndef SEED_EXT_INTERVAL
#define SEED_EXT_INTERVAL	49
#endif

#define MAX_GATHERER_BYTES	100000

/*
 * Define the minimum ENTROPY_NEEDED to be 256, as one can retrieve 255 bytes
 * with on egd-query.
 */
#ifndef ENTROPY_NEEDED
#define ENTROPY_NEEDED		256
#endif

/*
 * Define the minimum of entropy we want to have in the pool on a regular
 * basis. If we come below this threshold, the gatherer processes are fired
 * up continously until we come back over the threshold.
 */
#ifndef THRESHOLD
#define THRESHOLD		4
#endif
#define ENTROPY_THRESHOLD	(ENTROPY_NEEDED * BITS_PER_BYTE * THRESHOLD)
