/*
 * STAN - Stream Analyser
 * Copyright (c) 2001 Konrad Rieck <kr@r0q.cx>
 * The Roqefellaz, http://www.r0q.cx/stan
 *
 * $Id: bintree.h,v 1.2 2001/02/28 18:25:58 kr Exp $
 */
typedef struct bnode bnode_t;

struct bnode {
    size_t run;
    size_t count_false, count_true;
    bnode_t *left, *right, *parent;
};

void bfree(bnode_t * bnode);
void btraverse(bnode_t ** bnode, void (*func) (bnode_t *), int order);
void init_bintree();
void free_bintree();
bnode_t **blocate(bnode_t ** bnode, size_t run);
size_t bhigh(bnode_t ** bnode);
void bprint(bnode_t * bnode);
void binsert(bnode_t ** bnode, size_t run, int bit);
size_t bdepth(bnode_t ** bnode);
bnode_t **bmax(bnode_t ** bnode);
bnode_t **bmin(bnode_t ** bnode);
bnode_t **bsuccessor(bnode_t ** bnode);
bnode_t **bpredecessor(bnode_t ** bnode);
size_t bsize_total(bnode_t ** bnode, int bit);
size_t bsize_bnodes(bnode_t ** bnode, int bit);
