/*
 * STAN - Stream Analyser
 * Copyright (c) 2001 Konrad Rieck <kr@r0q.cx>
 * The Roqefellaz, http://www.r0q.cx/stan
 *
 * $Id: stan.h,v 1.12 2001/03/01 00:19:08 kr Exp $
 */

#define TRUE 1
#define FALSE 0

/*
 * I rather referer to byte_t instead of unsigned char or u_char. 
 */
typedef unsigned char byte_t;
#define BYTE_MAX 255

#ifdef DEBUG
#define NORMAL 0
#define STRONG 1
#ifndef LEVEL
#define LEVEL 0
#endif
#define dprintf(X,Y) if(X<=LEVEL) printf Y
#else
#define dprintf(X,Y)		/* nothing */
#endif

enum order {
    preorder,
    inorder,
    postorder
};

void print_error(const char *txt);
void print_progress();
