#include "rc4.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <pwd.h>


int main(int argc,char **argv) {
		char buf[256];
		char key[128];
		char *keyptr=NULL;
		rc4_key rc4k;
		int fd;
		long unsigned int offset;
		int done,len;
		
		if (argc !=2) {
					fprintf(stderr,"usage: %s filename\n",argv[0]);
					exit(1);
		}
		
		if((fd=open(argv[1],O_RDWR|O_EXCL))==-1) {
				fprintf(stderr,"error opening file %s! Exiting.. \n",
									argv[1]);
		}
		
		done=0;
		while(!done) {
				if(keyptr)
					   	fprintf(stderr,
								"passwords don't match, try again!\n");
				keyptr =
					getpass("\nEnter en/decryption key (up to 128 symbols):");
				bcopy(keyptr,key,128);
				keyptr = getpass("\nEnter the same key again:");
				done = !strcmp(keyptr,key);
		}
		fprintf(stderr,"\nKey accepted\nCiphering .. ");
		
		offset=0;
		prepare_key(key,strlen(key),&rc4k);
		while((len=read(fd,buf,256))!=0) {
				rc4(buf,len,&rc4k);
				lseek(fd,offset,SEEK_SET);
				write(fd,buf,len);
				offset+=len;
		}
				
		fprintf(stderr,"done\n");
		close(fd);
return 0;
}
