/* useful hex manipulation routines */
/* Copyright C Qualcomm Inc 1997 */
/* %W% (AHAG) %E% */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "hexlib.h"

int	nerrors;

static char	*hex = "0123456789abcdef";
#define HEX(c) (strchr(hex, (c)) - hex)

void
hexprint(const char *s, unsigned char *p, int n)
{
    printf("%14s:", s);
    while (--n >= 0) {
	printf(" %02x", *p++);
    }
    printf("\n");
}

void
hexread(unsigned char *buf, char *p, int n)
{
    int		i;

    while (--n >= 0) {
	i = HEX(*p++) << 4;
	i += HEX(*p++);
	*buf++ = i;
    }
}

void
hexcheck(unsigned char *buf, char *p, int n)
{
    int		i;

    while (--n >= 0) {
	i = HEX(*p++) << 4;
	i += HEX(*p++);
	if (*buf++ != i) {
	    printf("Expected %02x, got %02x.\n", i, buf[-1]);
	    ++nerrors;
	}
    }
}

void
hexbulk(unsigned char *buf, int n)
{
    int		i;

    for (i = 0; i < n; ++i)
	printf("%02x%c", buf[i], (i%16 == 15 ? '\n' : ' '));
    if (i % 16 != 0)
	putchar('\n');
}
