/* @(#)sober.h	1.6 (QUALCOMM) 97/12/23 */

#ifndef SOBER_DEFINED
#define SOBER_DEFINED	1

/* Header for Seventeen Octet Byte Enabled Register stream cipher. */

/*
Copyright C 1997 QUALCOMM Incorporated.
This software is free for commercial and non-commercial use in
non-embedded applications subject to the following conditions.

Copyright remains vested in QUALCOMM Incorporated, and Copyright
notices in the code are not to be removed.  If this package is used in
a product, QUALCOMM should be given attribution as the author of the
SOBER encryption algorithm. This can be in the form of a textual
message at program startup or in documentation (online or textual)
provided with the package.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

1. Redistributions of source code must retain the copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the
   distribution.

3. All advertising materials mentioning features or use of this
   software must display the following acknowledgement:  This product
   includes software developed by QUALCOMM Incorporated.

4. The software is not embedded in a device intended for a specific
   application, for example but not limited to communication devices
   (including mobile telephones), smart cards, cash registers, teller
   machines, network routers.

THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

The license and distribution terms for any publically available version
or derivative of this code cannot be changed, that is, this code cannot
simply be copied and put under another distribution license including
the GNU Public License.
*/

#define N 17

typedef unsigned char uchar;
typedef unsigned long word32;

typedef struct {
    uchar	Initial[N]; /* Initial contents of the shift register
					-- key schedule */
    uchar	R[2*N];	/* Working storage for the shift register */
    uchar	stcnt;	/* stutter control -- when == 0 next output stored */
    uchar	stctrl; /* used 2 bits at a time */
    uchar	r;	/* current offset in sliding window buffer */
} sober_ctx;

void sober_key(sober_ctx *s, uchar key[], int keylen);
void sober_frame(sober_ctx *s, word32 frame);
void sober_genbytes(sober_ctx *s, uchar buf[], int nbytes);

#endif /* SOBER_DEFINED */
