/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.MyRecordStore;
import app.SessionSpec;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;

public class SessionManager
extends MyRecordStore {
    private static final String RMS_NAME = "sessions";
    private static Vector sessions;
    private static SessionManager me;

    protected int compare(Object object, Object object2) {
        return ((SessionSpec)object).alias.compareTo(((SessionSpec)object2).alias);
    }

    public static Vector getSessions() {
        if (sessions == null) {
            sessions = me.load(RMS_NAME, true);
        }
        return sessions;
    }

    private static void saveSessions() {
        me.save(RMS_NAME, sessions);
    }

    public static void addSession(SessionSpec sessionSpec) {
        Vector vector = SessionManager.getSessions();
        vector.addElement(sessionSpec);
        SessionManager.saveSessions();
    }

    public static SessionSpec getSession(int n) {
        Vector vector = SessionManager.getSessions();
        return n >= vector.size() ? null : (SessionSpec)vector.elementAt(n);
    }

    public static void deleteSession(int n) {
        Vector vector = SessionManager.getSessions();
        if (n < vector.size()) {
            vector.removeElementAt(n);
            SessionManager.saveSessions();
        }
    }

    public static void replaceSession(int n, SessionSpec sessionSpec) {
        Vector vector = SessionManager.getSessions();
        if (n >= vector.size()) {
            vector.addElement(sessionSpec);
        } else {
            vector.setElementAt(sessionSpec, n);
        }
        SessionManager.saveSessions();
    }

    protected Object read(DataInputStream dataInputStream) throws IOException {
        SessionSpec sessionSpec = new SessionSpec();
        try {
            sessionSpec.read(dataInputStream);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return sessionSpec;
    }

    protected void write(DataOutputStream dataOutputStream, Object object) throws IOException {
        SessionSpec sessionSpec = (SessionSpec)object;
        sessionSpec.write(dataOutputStream);
    }

    static {
        me = new SessionManager();
    }
}

