/*
 * Decompiled with CFR 0.152.
 */
package app.session;

import app.SessionSpec;
import app.Settings;
import app.session.SessionIOHandler;
import gui.Activatable;
import gui.MainMenu;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import terminal.Terminal;
import terminal.VT320;

public abstract class Session
implements Activatable {
    public static int keepAliveTime = 60000;
    protected VT320 emulation;
    protected SessionIOHandler filter;
    private Terminal terminal;
    private boolean disconnecting;
    private boolean erroredDisconnect;
    private boolean forcedDisconnect;
    private boolean pollingIO;
    private StreamConnection socket;
    private InputStream in;
    private OutputStream out;
    private SessionSpec spec;
    private Thread reader;
    private Thread writer;
    private byte[] outputBuffer = new byte[16];
    private Object writerMutex = new Object();
    private int outputCount = 0;
    private int bytesWritten = 0;
    private int bytesRead = 0;

    public Session() {
        this.emulation = new VT320(){

            public void sendData(byte[] byArray, int n, int n2) throws IOException {
                Session.this.filter.handleSendData(byArray, n, n2);
            }
        };
        this.pollingIO = Settings.pollingIO;
        this.terminal = new Terminal(this.emulation, this);
        this.reader = new Reader();
        this.writer = new Writer();
    }

    protected void connect(SessionSpec sessionSpec, SessionIOHandler sessionIOHandler) {
        this.spec = sessionSpec;
        this.filter = sessionIOHandler;
        this.writer.start();
    }

    protected abstract int defaultPort();

    protected void receiveData(byte[] byArray, int n, int n2) throws IOException {
        if (byArray != null && n2 > 0) {
            try {
                this.emulation.putString(new String(byArray, n, n2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendData(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.writerMutex;
        synchronized (object) {
            if (this.outputCount + n2 > this.outputBuffer.length) {
                byte[] byArray2 = new byte[this.outputCount + n2];
                System.arraycopy(this.outputBuffer, 0, byArray2, 0, this.outputCount);
                this.outputBuffer = byArray2;
            }
            System.arraycopy(byArray, n, this.outputBuffer, this.outputCount, n2);
            this.outputCount += n2;
            this.writerMutex.notify();
        }
    }

    public void typeString(String string) {
        this.emulation.stringTyped(string);
    }

    public void typeChar(char c, int n) {
        this.emulation.keyTyped(0, c, n);
    }

    public void typeKey(int n, int n2) {
        this.emulation.keyPressed(n, n2);
    }

    private boolean connect() throws IOException {
        String string = this.spec.host;
        this.emulation.putString("Connecting to " + string + "...");
        StringBuffer stringBuffer = new StringBuffer("socket://");
        stringBuffer.append(string);
        if (string.indexOf(58) == -1) {
            stringBuffer.append(':');
            stringBuffer.append(this.defaultPort());
        }
        this.socket = (StreamConnection)Connector.open((String)stringBuffer.toString(), (int)3, (boolean)false);
        this.in = this.socket.openDataInputStream();
        this.out = this.socket.openDataOutputStream();
        this.emulation.putString("OK\r\n");
        return true;
    }

    private void read() throws IOException {
        byte[] byArray = new byte[512];
        int n = 0;
        while (n != -1) {
            this.bytesRead += n;
            this.filter.handleReceiveData(byArray, 0, n);
            int n2 = this.in.available();
            if (this.pollingIO) {
                while (n2 == 0 && !this.disconnecting) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    n2 = this.in.available();
                }
            }
            n = this.in.read(byArray, 0, Math.max(1, Math.min(n2, byArray.length)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() throws IOException {
        byte[] byArray = new byte[]{};
        while (!this.disconnecting) {
            Object object = this.writerMutex;
            synchronized (object) {
                while (this.outputCount == 0 && !this.disconnecting) {
                    try {
                        this.writerMutex.wait(keepAliveTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.outputCount != 0 || this.disconnecting) continue;
                    this.filter.handleSendData(byArray, 0, 0);
                }
                if (!this.disconnecting) {
                    this.bytesWritten += this.outputCount;
                    this.out.write(this.outputBuffer, 0, this.outputCount);
                    this.out.flush();
                    this.outputCount = 0;
                }
            }
        }
    }

    private void handleException(String string, Throwable throwable) {
        if (!this.disconnecting) {
            Alert alert = new Alert("Session Error");
            alert.setType(AlertType.ERROR);
            String string2 = throwable.getMessage();
            if (string2 == null) {
                string2 = throwable.toString();
            }
            alert.setString(string + ": " + string2);
            MainMenu.setDisplay((Displayable)alert);
        }
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public void disconnect() {
        this.forcedDisconnect = true;
        this.doDisconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDisconnect() {
        if (!this.disconnecting) {
            Object object = this.writerMutex;
            synchronized (object) {
                this.disconnecting = true;
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                    if (this.out != null) {
                        this.out.close();
                    }
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (IOException iOException) {
                    this.handleException("Disconnect", iOException);
                }
                this.writerMutex.notify();
            }
        }
    }

    private String bytesToString(int n) {
        if (n < 1024) {
            return n + " bytes";
        }
        if (n < 0x100000) {
            return this.to2dp(n * 100 / 1024) + " KB";
        }
        return this.to2dp(n * 100 / 0x100000) + " MB";
    }

    private String to2dp(int n) {
        String string = "" + n;
        return string.substring(0, string.length() - 2) + "." + string.substring(string.length() - 2);
    }

    private void sessionReport() {
        if (!this.erroredDisconnect) {
            String string = "IN: " + this.bytesToString(this.bytesRead) + "\nOUT: " + this.bytesToString(this.bytesWritten) + "\nTOTAL: " + this.bytesToString(this.bytesRead + this.bytesWritten);
            Alert alert = new Alert("Session Report");
            alert.setType(AlertType.INFO);
            alert.setString(string);
            alert.setTimeout(-2);
            if (this.forcedDisconnect) {
                MainMenu.alertBackToMain(alert);
            } else {
                MainMenu.alert(alert, (Displayable)this.terminal);
            }
        }
    }

    public void goMainMenu() {
        MainMenu.goMainMenu();
    }

    public void activate() {
        this.terminal.activate();
    }

    public void activate(Activatable activatable) {
        this.activate();
    }

    private class Writer
    extends Thread {
        private Writer() {
        }

        public void run() {
            try {
                Session.this.connect();
                Session.this.terminal.connected();
                Session.this.reader.start();
                Session.this.write();
                Session.this.doDisconnect();
                Session.this.terminal.disconnected();
                Session.this.sessionReport();
            }
            catch (Exception exception) {
                Session.this.handleException("Writer", exception);
                Session.this.erroredDisconnect = true;
                Session.this.doDisconnect();
                Session.this.terminal.disconnected();
            }
        }
    }

    private class Reader
    extends Thread {
        private Reader() {
        }

        public void run() {
            try {
                Session.this.read();
                Session.this.doDisconnect();
            }
            catch (Exception exception) {
                Session.this.handleException("Reader", exception);
                Session.this.erroredDisconnect = true;
                Session.this.doDisconnect();
            }
        }
    }
}

