/*
 * Decompiled with CFR 0.152.
 */
package gui;

import app.Main;
import app.session.Session;
import gui.Activatable;
import gui.SessionsMenu;
import gui.session.macros.MacrosMenu;
import gui.settings.SettingsMenu;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;

public class MainMenu
extends List
implements CommandListener,
Activatable {
    public static final Command okCommand = new Command("OK", 4, 1);
    public static final Command backCommand = new Command("Back", 2, 99);
    private static Command quitCommand = new Command("Quit", 7, 2);
    private static MainMenu instance;
    public static boolean useColors;
    private static Session currentSession;
    private SessionsMenu sessionsMenu;
    private static MacrosMenu macrosMenu;
    private static Activatable settingsMenu;
    private static final String ITEM_SESSIONS = "Sessions";
    private static final String ITEM_MACROS = "Macros";
    private static final String ITEM_SETTINGS = "Settings";
    private static final String ITEM_ABOUT = "About MidpSSH";
    private static final String ITEM_HELP = "Help";
    private static final String ITEM_QUIT = "Quit";

    public MainMenu() {
        super("MidpSSH", 3);
        instance = this;
        useColors = MainMenu.getDisplay().isColor();
        this.append(ITEM_SESSIONS, null);
        this.append(ITEM_MACROS, null);
        this.append(ITEM_SETTINGS, null);
        this.append(ITEM_ABOUT, null);
        this.append(ITEM_HELP, null);
        this.append(ITEM_QUIT, null);
        this.addCommand(quitCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND) {
            String string = this.getString(this.getSelectedIndex());
            if (string.equals(ITEM_SESSIONS)) {
                this.doSessions();
            } else if (string.equals(ITEM_MACROS)) {
                MainMenu.doMacros(this);
            } else if (string.equals(ITEM_SETTINGS)) {
                this.doSettings();
            } else if (string.equals(ITEM_ABOUT)) {
                this.doAbout();
            } else if (string.equals(ITEM_HELP)) {
                this.doHelp();
            } else if (string.equals(ITEM_QUIT)) {
                Main.quitApp();
            }
        } else if (command == okCommand) {
            MainMenu.goMainMenu();
        } else if (command == quitCommand) {
            Main.quitApp();
        }
    }

    private void doSessions() {
        if (this.sessionsMenu == null) {
            this.sessionsMenu = new SessionsMenu();
        }
        this.sessionsMenu.activate(this);
    }

    public static void doMacros(Activatable activatable) {
        if (macrosMenu == null) {
            macrosMenu = new MacrosMenu();
        }
        macrosMenu.activate(activatable);
    }

    private void doSettings() {
        if (settingsMenu == null) {
            settingsMenu = new SettingsMenu();
        }
        settingsMenu.activate(this);
    }

    public static Form showMessage(String string, String string2, CommandListener commandListener) {
        Form form = new Form(string);
        form.append((Item)new StringItem(null, string2));
        form.addCommand(okCommand);
        form.setCommandListener(commandListener);
        MainMenu.setDisplay((Displayable)form);
        return form;
    }

    private void doAbout() {
        MainMenu.showMessage(ITEM_ABOUT, "Version 1.4.20\n\nMidpSSH is a Telnet and SSH application for Java compatible phones and other mobile devices.\n\nPlease visit the project website for more information:\nhttp://www.xk72.com/midpssh/\n\nMidpSSH is developed by Karl von Randow. MidpSSH is based upon FloydSSH and Telnet Floyd by Radek Polak.\n\nMidpSSH is distributed under the GPL licence. For more information please visit the website.", this);
    }

    private void doHelp() {
        MainMenu.showMessage("MidpSSH Help", "Connecting\n\nTo connect to a remote server choose the Sessions option from the main menu - create a new session, entering in the host and other details. You can then connect to that server by choosing the new session.\n\nMore Information\n\nFor more information please visit the project website http://www.xk72.com/midpssh/", this);
    }

    public void activate() {
        MainMenu.setDisplay((Displayable)this);
    }

    public void activate(Activatable activatable) {
        this.activate();
    }

    public static void setDisplay(Displayable displayable) {
        MainMenu.getDisplay().setCurrent(displayable);
    }

    public static void alert(Alert alert, Displayable displayable) {
        MainMenu.getDisplay().setCurrent(alert, displayable);
    }

    public static Display getDisplay() {
        return Display.getDisplay((MIDlet)Main.instance);
    }

    public static void goMainMenu() {
        MainMenu.setDisplay((Displayable)instance);
    }

    public static void alertBackToMain(Alert alert) {
        MainMenu.getDisplay().setCurrent(alert, (Displayable)instance);
    }

    public static void openSession(Session session) {
        currentSession = session;
        session.activate();
    }

    public static Session currentSession() {
        return currentSession;
    }

    public static void showErrorMessage(String string) {
        Alert alert = new Alert("Error");
        alert.setString(string);
        alert.setType(AlertType.ERROR);
        MainMenu.setDisplay((Displayable)alert);
    }
}

