/*
 * Decompiled with CFR 0.152.
 */
package gui;

import app.SessionManager;
import app.SessionSpec;
import app.session.Session;
import app.session.SshSession;
import app.session.TelnetSession;
import gui.EditableMenu;
import gui.ImportSessionsForm;
import gui.MainMenu;
import gui.SessionForm;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class SessionsMenu
extends EditableMenu {
    private static Command connectCommand = new Command("Connect", 8, 1);
    private static SessionForm newConnectionForm = new SessionForm(false);
    private static SessionForm editConnectionForm = new SessionForm(true);
    private static Command importCommand = new Command("Import", 1, 20);
    private ImportSessionsForm importSessionsForm;
    private Form authenticationDialog;
    private TextField usernameField;
    private TextField passwordField;
    private SessionSpec conn;

    public SessionsMenu() {
        super("Sessions");
        this.replaceSelectCommand(connectCommand);
        this.addCommand(importCommand);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.authenticationDialog) {
            if (command == MainMenu.okCommand) {
                SshSession sshSession = new SshSession();
                sshSession.connect(this.conn, this.usernameField.getString(), this.passwordField.getString());
                MainMenu.openSession(sshSession);
            } else {
                this.activate();
            }
        } else if (command == importCommand) {
            if (this.importSessionsForm == null) {
                this.importSessionsForm = new ImportSessionsForm();
            }
            this.importSessionsForm.activate(this);
        } else {
            super.commandAction(command, displayable);
        }
    }

    protected void addItems() {
        this.deleteAll();
        Vector vector = SessionManager.getSessions();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                SessionSpec sessionSpec = (SessionSpec)vector.elementAt(i);
                this.append(sessionSpec.alias, null);
            }
        }
    }

    protected void doSelect(int n) {
        if (n != -1) {
            this.conn = SessionManager.getSession(n);
            if (this.conn != null) {
                Object object;
                if (this.conn.type.equals("ssh")) {
                    object = this.conn.username;
                    String string = this.conn.password;
                    if (((String)object).length() == 0 || string.length() == 0 && !this.conn.usepublickey) {
                        this.authenticationDialog = new Form("Authentication");
                        this.usernameField = new TextField("Username:", (String)object, 255, 0);
                        this.authenticationDialog.append((Item)this.usernameField);
                        if (!this.conn.usepublickey) {
                            this.passwordField = new TextField("Password:", string, 255, 65536);
                            this.authenticationDialog.append((Item)this.passwordField);
                        }
                        this.authenticationDialog.addCommand(MainMenu.okCommand);
                        this.authenticationDialog.addCommand(MainMenu.backCommand);
                        this.authenticationDialog.setCommandListener((CommandListener)this);
                        MainMenu.setDisplay((Displayable)this.authenticationDialog);
                    } else {
                        SshSession sshSession = new SshSession();
                        sshSession.connect(this.conn, null, null);
                        MainMenu.openSession(sshSession);
                    }
                }
                if (this.conn.type.equals("telnet")) {
                    object = new TelnetSession();
                    ((TelnetSession)object).connect(this.conn);
                    MainMenu.openSession((Session)object);
                }
            }
        }
    }

    protected void doEdit(int n) {
        if (n != -1) {
            editConnectionForm.setConnectionIndex(n);
            editConnectionForm.activate(this);
        }
    }

    protected void doDelete(int n) {
        if (n != -1) {
            SessionManager.deleteSession(n);
            this.delete(n);
        }
    }

    protected void doNew() {
        newConnectionForm.activate(this);
    }
}

