/*
 * Decompiled with CFR 0.152.
 */
package gui.session.macros;

import app.session.MacroSetManager;
import app.session.Session;
import gui.EditableMenu;
import gui.MainMenu;
import gui.session.macros.MacroForm;
import gui.session.macros.MacroSet;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;

public class MacrosMenu
extends EditableMenu {
    protected static final Command useCommand = new Command("Use", 8, 1);
    private MacroSet macroSet;
    private int macroSetIndex;
    private boolean isMacroSets;
    private static final char MACRO_CTRL = '^';
    private static final char MACRO_BACKSLASH = '\\';

    public MacrosMenu() {
        super("Macro Sets");
        this.isMacroSets = true;
    }

    public MacrosMenu(MacroSet macroSet, int n) {
        super(macroSet.name);
        this.isMacroSets = false;
        this.macroSet = macroSet;
        this.macroSetIndex = n;
        if (MainMenu.currentSession() != null) {
            this.addCommand(useCommand);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == useCommand) {
            int n = this.getSelectedIndex();
            if (n >= 0 && n < this.size()) {
                Session session = MainMenu.currentSession();
                if (session != null) {
                    MacroSet macroSet = this.macroSet.getMacro(n);
                    if (macroSet != null) {
                        session.getTerminal().doTextInput(macroSet.value.trim());
                    }
                } else {
                    this.doEdit(n);
                }
            }
        } else {
            super.commandAction(command, displayable);
        }
    }

    protected void addItems() {
        this.deleteAll();
        if (this.isMacroSets) {
            Vector vector = MacroSetManager.getMacroSets();
            for (int i = 0; i < vector.size(); ++i) {
                MacroSet macroSet = (MacroSet)vector.elementAt(i);
                this.append(macroSet.name, null);
            }
        } else {
            Vector vector = this.macroSet.macros;
            for (int i = 0; i < vector.size(); ++i) {
                MacroSet macroSet = (MacroSet)vector.elementAt(i);
                String string = macroSet.name;
                if (string.length() == 0) {
                    string = macroSet.value.trim();
                }
                this.append(string, null);
            }
        }
    }

    protected void doDelete(int n) {
        if (n != -1) {
            if (this.isMacroSets) {
                MacroSetManager.deleteMacroSet(n);
            } else {
                this.macroSet.deleteMacro(n);
            }
            this.delete(n);
        }
    }

    protected void doSelect(int n) {
        if (n != -1) {
            if (this.isMacroSets) {
                MacroSet macroSet = MacroSetManager.getMacroSet(n);
                MacrosMenu macrosMenu = new MacrosMenu(macroSet, n);
                macrosMenu.activate(this);
            } else {
                Session session = MainMenu.currentSession();
                if (session != null) {
                    MacroSet macroSet = this.macroSet.getMacro(n);
                    if (macroSet != null) {
                        this.doMacro(session, macroSet);
                        session.activate();
                    }
                } else {
                    this.doEdit(n);
                }
            }
        }
    }

    private int indexOfCommand(String string, int n) {
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '^' && c != '\\') continue;
            return i;
        }
        return -1;
    }

    private void doMacro(Session session, MacroSet macroSet) {
        String string = macroSet.value;
        int n = 0;
        int n2 = this.indexOfCommand(string, 0);
        while (n2 != -1) {
            if (n2 + 1 < string.length()) {
                if (n2 > n) {
                    session.typeString(string.substring(n, n2));
                }
                char c = string.charAt(n2);
                char c2 = string.charAt(n2 + 1);
                if (c2 == c) {
                    session.typeString(string.substring(n2, n2 + 2));
                } else if (c == '^') {
                    session.typeChar(c2, 1);
                } else if (c == '\\') {
                    if (c2 == 'n') {
                        session.typeChar('\n', 0);
                    } else if (c2 == 'r') {
                        session.typeChar('\r', 0);
                    } else if (c2 == 't') {
                        session.typeChar('\t', 0);
                    } else if (c2 == 'e') {
                        session.typeChar('\u001b', 0);
                    } else {
                        session.typeString(string.substring(n2, n2 + 2));
                    }
                }
                n = n2 + 2;
            } else {
                n = n2 + 1;
            }
            n2 = this.indexOfCommand(string, n);
        }
        if (n < string.length()) {
            session.typeString(string.substring(n));
        }
    }

    protected void doEdit(int n) {
        if (n != -1) {
            MacroForm macroForm = new MacroForm(true, this.isMacroSets);
            if (this.isMacroSets) {
                macroForm.setMacroSetIndex(n);
            } else {
                macroForm.setMacroIndices(this.macroSetIndex, n);
            }
            macroForm.activate(this);
        }
    }

    protected void doNew() {
        MacroForm macroForm = new MacroForm(false, this.isMacroSets);
        if (!this.isMacroSets) {
            macroForm.setMacroSetIndex(this.macroSetIndex);
        }
        macroForm.activate(this);
    }
}

