/*
 * Decompiled with CFR 0.152.
 */
package gui.settings;

import app.Settings;
import gui.EditableForm;
import gui.MainMenu;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import ssh.v2.DHKeyExchange;
import ssh.v2.PublicKeyAuthentication;

public class SettingsForm
extends EditableForm {
    public static final int MODE_NETWORK = 1;
    public static final int MODE_INTERFACE = 2;
    public static final int MODE_FONTS = 3;
    public static final int MODE_SSH = 4;
    private int mode;
    protected TextField tfType = new TextField("Terminal Type", "", 20, 0);
    protected TextField tfCols = new TextField("Cols", "", 3, 2);
    protected TextField tfRows = new TextField("Rows", "", 3, 2);
    protected ChoiceGroup cgFont = new ChoiceGroup("Font Size", 1);
    protected ChoiceGroup cgLCDFontMode = new ChoiceGroup("LCD Font Mode", 1);
    protected TextField tfFg = new TextField("Foreground", "", 6, 0);
    protected TextField tfBg = new TextField("Background", "", 6, 0);
    protected ChoiceGroup cgPolling = new ChoiceGroup("Polling I/O", 1);
    protected ChoiceGroup cgSsh = new ChoiceGroup("Prefer", 1);
    protected ChoiceGroup cgSshPublicKey = new ChoiceGroup("Public Key", 1);
    protected ChoiceGroup cgSshKeys = new ChoiceGroup("Store Session Key", 1);
    protected ChoiceGroup cgSshKeySize = new ChoiceGroup("Session Key Size", 1);
    private static final int[] sshKeySizes = new int[]{32, 64, 128, 256, 512, 1024};

    public static void booleanChoiceGroup(ChoiceGroup choiceGroup) {
        choiceGroup.append("On", null);
        choiceGroup.append("Off", null);
    }

    public SettingsForm(String string, int n) {
        super(string);
        this.mode = n;
        switch (n) {
            case 1: {
                this.append((Item)this.tfType);
                SettingsForm.booleanChoiceGroup(this.cgPolling);
                this.append((Item)this.cgPolling);
                break;
            }
            case 2: {
                this.append((Item)new StringItem("Terminal Size", "The default is to use the maximum available screen area."));
                this.append((Item)this.tfCols);
                this.append((Item)this.tfRows);
                break;
            }
            case 3: {
                this.cgFont.append("Tiny", null);
                this.cgFont.append("Device", null);
                this.append((Item)this.cgFont);
                this.append((Item)this.tfFg);
                this.append((Item)this.tfBg);
                break;
            }
            case 4: {
                this.cgSsh.append("SSH1", null);
                this.cgSsh.append("SSH2", null);
                this.append((Item)this.cgSsh);
                SettingsForm.booleanChoiceGroup(this.cgSshPublicKey);
                this.append((Item)this.cgSshPublicKey);
                SettingsForm.booleanChoiceGroup(this.cgSshKeys);
                this.append((Item)this.cgSshKeys);
                for (int i = 0; i < sshKeySizes.length; ++i) {
                    this.cgSshKeySize.append(String.valueOf(sshKeySizes[i]), null);
                }
                this.append((Item)this.cgSshKeySize);
            }
        }
        this.addCommand(MainMenu.okCommand);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable instanceof Alert) {
            byte[][] byArray;
            if (this.cgSshKeys.getSelectedIndex() == 0 && Settings.ssh2x == null) {
                byArray = DHKeyExchange.generateKeyPairBytes(Settings.ssh2KeySize);
                Settings.ssh2x = byArray[0];
                Settings.ssh2y = byArray[1];
            }
            if (this.cgSshPublicKey.getSelectedIndex() == 0 && Settings.x == null) {
                byArray = PublicKeyAuthentication.generateKeyPair();
                Settings.x = byArray[0];
                Settings.y = byArray[1];
            }
            Settings.saveSettings();
            this.doBack();
        } else if (command == MainMenu.okCommand) {
            if (this.doSave()) {
                Settings.saveSettings();
                this.doBack();
            }
        } else {
            super.commandAction(command, displayable);
        }
    }

    public void activate() {
        block0 : switch (this.mode) {
            case 1: {
                this.tfType.setString(Settings.terminalType);
                this.cgPolling.setSelectedIndex(Settings.pollingIO ? 0 : 1, true);
                break;
            }
            case 2: {
                int n = Settings.terminalCols;
                int n2 = Settings.terminalRows;
                if (n > 0) {
                    this.tfCols.setString(String.valueOf(n));
                } else {
                    this.tfCols.setString("");
                }
                if (n2 > 0) {
                    this.tfRows.setString(String.valueOf(n2));
                    break;
                }
                this.tfRows.setString("");
                break;
            }
            case 3: {
                this.cgFont.setSelectedIndex(Settings.fontMode, true);
                this.tfFg.setString(SettingsForm.toHex(Settings.fgcolor));
                this.tfBg.setString(SettingsForm.toHex(Settings.bgcolor));
                break;
            }
            case 4: {
                this.cgSsh.setSelectedIndex(Settings.sshVersionPreferred == 2 ? 1 : 0, true);
                this.cgSshPublicKey.setSelectedIndex(Settings.x != null ? 0 : 1, true);
                this.cgSshKeys.setSelectedIndex(Settings.ssh2StoreKey ? 0 : 1, true);
                for (int i = 0; i < sshKeySizes.length; ++i) {
                    if (Settings.ssh2KeySize != sshKeySizes[i]) continue;
                    this.cgSshKeySize.setSelectedIndex(i, true);
                    break block0;
                }
                break;
            }
        }
        super.activate();
    }

    protected boolean doSave() {
        switch (this.mode) {
            case 1: {
                Settings.terminalType = this.tfType.getString();
                Settings.pollingIO = this.cgPolling.getSelectedIndex() == 0;
                break;
            }
            case 2: {
                try {
                    Settings.terminalCols = Integer.parseInt(this.tfCols.getString());
                }
                catch (NumberFormatException numberFormatException) {
                    Settings.terminalCols = 0;
                }
                try {
                    Settings.terminalRows = Integer.parseInt(this.tfRows.getString());
                }
                catch (NumberFormatException numberFormatException) {
                    Settings.terminalRows = 0;
                }
                break;
            }
            case 3: {
                Settings.fontMode = this.cgFont.getSelectedIndex();
                try {
                    int n;
                    Settings.fgcolor = n = Integer.parseInt(this.tfFg.getString(), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    Settings.fgcolor = 0xFFFFFF;
                }
                try {
                    int n;
                    Settings.bgcolor = n = Integer.parseInt(this.tfBg.getString(), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    Settings.bgcolor = 0;
                }
                break;
            }
            case 4: {
                boolean bl;
                boolean bl2;
                Settings.sshVersionPreferred = this.cgSsh.getSelectedIndex() == 1 ? 2 : 1;
                Settings.ssh2StoreKey = bl2 = this.cgSshKeys.getSelectedIndex() == 0;
                int n = sshKeySizes[this.cgSshKeySize.getSelectedIndex()];
                if (n != Settings.ssh2KeySize || !bl2) {
                    Settings.ssh2KeySize = n;
                    Settings.ssh2x = null;
                    Settings.ssh2y = null;
                }
                boolean bl3 = bl = this.cgSshPublicKey.getSelectedIndex() == 0;
                if (!bl) {
                    Settings.x = null;
                    Settings.y = null;
                }
                if ((!bl2 || Settings.ssh2x != null) && (!bl || Settings.x != null)) break;
                Alert alert = new Alert("MidpSSH");
                alert.setString("Generating keys, please wait...");
                alert.setTimeout(1);
                alert.setCommandListener((CommandListener)this);
                MainMenu.setDisplay((Displayable)alert);
                return false;
            }
        }
        return true;
    }

    private static String toHex(int n) {
        String string = Integer.toHexString(n);
        while (string.length() < 6) {
            string = "0" + string;
        }
        return string;
    }
}

