/*
 * Decompiled with CFR 0.152.
 */
package ssh;

public abstract class SshPacket {
    protected byte[] byteArray = new byte[0];
    protected int offset;
    private boolean finished;
    protected byte packet_type;

    public byte[] getData() {
        return this.byteArray;
    }

    public void putData(byte[] byArray) {
        this.byteArray = byArray;
        this.offset = 0;
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public abstract int addPayload(byte[] var1, int var2, int var3);

    public byte getType() {
        return this.packet_type;
    }

    public abstract void putMpInt(byte[] var1);

    public int getInt32() {
        short s = this.byteArray[this.offset++];
        short s2 = this.byteArray[this.offset++];
        short s3 = this.byteArray[this.offset++];
        short s4 = this.byteArray[this.offset++];
        if (s < 0) {
            s = (short)(256 + s);
        }
        if (s2 < 0) {
            s2 = (short)(256 + s2);
        }
        if (s3 < 0) {
            s3 = (short)(256 + s3);
        }
        if (s4 < 0) {
            s4 = (short)(256 + s4);
        }
        return (s << 24) + (s2 << 16) + (s3 << 8) + s4;
    }

    public int getInt16() {
        short s = this.byteArray[this.offset++];
        short s2 = this.byteArray[this.offset++];
        if (s < 0) {
            s = (short)(256 + s);
        }
        if (s2 < 0) {
            s2 = (short)(256 + s2);
        }
        return (s << 8) + s2;
    }

    public String getString() {
        int n = this.getInt32();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)this.byteArray[this.offset++]);
        }
        return stringBuffer.toString();
    }

    public byte[] getByteString() {
        int n = this.getInt32();
        return this.getBytes(n);
    }

    public byte getByte() {
        return this.byteArray[this.offset++];
    }

    public byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.byteArray, this.offset, byArray, 0, n);
        this.offset += n;
        return byArray;
    }

    private void grow(int n) {
        byte[] byArray = new byte[this.byteArray.length + n];
        System.arraycopy(this.byteArray, 0, byArray, 0, this.byteArray.length);
        this.byteArray = byArray;
    }

    public void putInt16(int n) {
        int n2 = this.byteArray.length;
        this.grow(2);
        this.byteArray[n2 + 1] = (byte)(n & 0xFF);
        this.byteArray[n2] = (byte)(n >> 8 & 0xFF);
    }

    public void putInt32(int n) {
        int n2 = this.byteArray.length;
        this.grow(4);
        this.byteArray[n2 + 3] = (byte)(n & 0xFF);
        this.byteArray[n2 + 2] = (byte)(n >> 8 & 0xFF);
        this.byteArray[n2 + 1] = (byte)(n >> 16 & 0xFF);
        this.byteArray[n2 + 0] = (byte)(n >> 24 & 0xFF);
    }

    public void putByte(byte by) {
        this.grow(1);
        this.byteArray[this.byteArray.length - 1] = by;
    }

    public void putBytes(byte[] byArray) {
        int n = this.byteArray.length;
        this.grow(byArray.length);
        System.arraycopy(byArray, 0, this.byteArray, n, byArray.length);
    }

    public void putBytes(byte[] byArray, int n, int n2) {
        int n3 = this.byteArray.length;
        this.grow(n2);
        System.arraycopy(byArray, n, this.byteArray, n3, n2);
    }

    public void putString(String string) {
        this.putInt32(string.length());
        this.putBytes(string.getBytes());
    }

    public void putString(byte[] byArray) {
        this.putString(byArray, 0, byArray.length);
    }

    public void putString(byte[] byArray, int n, int n2) {
        this.putInt32(n2);
        this.putBytes(byArray, n, n2);
    }
}

