/*
 * Decompiled with CFR 0.152.
 */
package ssh.v1;

import ssh.SshIO;
import ssh.SshPacket;
import ssh.v1.BigInteger;
import ssh.v1.SshCrypto;

public class SshPacket1
extends SshPacket {
    private static final int PHASE_packet_length = 0;
    private static final int PHASE_block = 1;
    private byte[] packet_length_array = new byte[4];
    private int packet_length;
    private byte[] padding;
    private byte[] crc_array = new byte[4];
    private byte[] block;
    private byte[] decryptedBlock;
    private int position;
    private int phase_packet = 0;
    private SshCrypto crypto;
    private static long[] crc32_tab = new long[]{0L, 1996959894L, 3993919788L, 2567524794L, 124634137L, 1886057615L, 3915621685L, 2657392035L, 249268274L, 2044508324L, 3772115230L, 2547177864L, 162941995L, 2125561021L, 3887607047L, 2428444049L, 498536548L, 1789927666L, 4089016648L, 2227061214L, 450548861L, 1843258603L, 4107580753L, 2211677639L, 325883990L, 1684777152L, 4251122042L, 2321926636L, 335633487L, 1661365465L, 4195302755L, 2366115317L, 997073096L, 1281953886L, 3579855332L, 2724688242L, 1006888145L, 1258607687L, 3524101629L, 2768942443L, 901097722L, 1119000684L, 3686517206L, 2898065728L, 853044451L, 1172266101L, 3705015759L, 2882616665L, 651767980L, 1373503546L, 3369554304L, 3218104598L, 565507253L, 1454621731L, 3485111705L, 3099436303L, 671266974L, 1594198024L, 3322730930L, 2970347812L, 795835527L, 1483230225L, 3244367275L, 3060149565L, 1994146192L, 31158534L, 2563907772L, 4023717930L, 1907459465L, 112637215L, 2680153253L, 3904427059L, 2013776290L, 251722036L, 2517215374L, 3775830040L, 2137656763L, 141376813L, 2439277719L, 3865271297L, 1802195444L, 476864866L, 2238001368L, 4066508878L, 1812370925L, 453092731L, 2181625025L, 4111451223L, 1706088902L, 314042704L, 2344532202L, 4240017532L, 1658658271L, 366619977L, 2362670323L, 4224994405L, 1303535960L, 984961486L, 2747007092L, 3569037538L, 1256170817L, 1037604311L, 2765210733L, 3554079995L, 1131014506L, 879679996L, 2909243462L, 3663771856L, 1141124467L, 855842277L, 2852801631L, 3708648649L, 1342533948L, 654459306L, 3188396048L, 3373015174L, 1466479909L, 544179635L, 3110523913L, 3462522015L, 1591671054L, 702138776L, 2966460450L, 3352799412L, 1504918807L, 783551873L, 3082640443L, 3233442989L, 3988292384L, 2596254646L, 62317068L, 1957810842L, 3939845945L, 2647816111L, 81470997L, 1943803523L, 3814918930L, 2489596804L, 225274430L, 2053790376L, 3826175755L, 2466906013L, 167816743L, 2097651377L, 4027552580L, 2265490386L, 503444072L, 1762050814L, 4150417245L, 2154129355L, 426522225L, 1852507879L, 4275313526L, 2312317920L, 282753626L, 1742555852L, 4189708143L, 2394877945L, 397917763L, 1622183637L, 3604390888L, 2714866558L, 953729732L, 1340076626L, 3518719985L, 2797360999L, 1068828381L, 1219638859L, 3624741850L, 2936675148L, 906185462L, 1090812512L, 3747672003L, 2825379669L, 829329135L, 1181335161L, 3412177804L, 3160834842L, 628085408L, 1382605366L, 3423369109L, 3138078467L, 570562233L, 1426400815L, 3317316542L, 2998733608L, 733239954L, 1555261956L, 3268935591L, 3050360625L, 752459403L, 1541320221L, 2607071920L, 3965973030L, 1969922972L, 40735498L, 2617837225L, 3943577151L, 1913087877L, 83908371L, 2512341634L, 3803740692L, 2075208622L, 213261112L, 2463272603L, 3855990285L, 2094854071L, 198958881L, 2262029012L, 4057260610L, 1759359992L, 534414190L, 2176718541L, 4139329115L, 1873836001L, 414664567L, 2282248934L, 4279200368L, 1711684554L, 285281116L, 2405801727L, 4167216745L, 1634467795L, 376229701L, 2685067896L, 3608007406L, 1308918612L, 956543938L, 2808555105L, 3495958263L, 1231636301L, 1047427035L, 2932959818L, 3654703836L, 1088359270L, 936918000L, 2847714899L, 3736837829L, 1202900863L, 817233897L, 3183342108L, 3401237130L, 1404277552L, 615818150L, 3134207493L, 3453421203L, 1423857449L, 601450431L, 3009837614L, 3294710456L, 1567103746L, 711928724L, 3020668471L, 3272380065L, 1510334235L, 755167117L};

    public SshPacket1() {
    }

    public SshPacket1(SshCrypto sshCrypto) {
        this.crypto = sshCrypto;
    }

    public SshPacket1(byte by) {
        this.packet_type = by;
    }

    public byte[] getMpInt() {
        return this.getBytes((this.getInt16() + 7) / 8);
    }

    public void putMpInt(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length && byArray[n] == 0; ++n) {
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        this.putInt16(byArray2.length * 8);
        this.putBytes(byArray2);
    }

    public void putMpInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        this.putMpInt(byArray);
    }

    public byte[] getPayLoad(SshCrypto sshCrypto) {
        int n;
        byte[] byArray = this.getData();
        this.packet_length = byArray != null ? byArray.length + 5 : 5;
        this.packet_length_array[3] = (byte)(this.packet_length & 0xFF);
        this.packet_length_array[2] = (byte)(this.packet_length >> 8 & 0xFF);
        this.packet_length_array[1] = (byte)(this.packet_length >> 16 & 0xFF);
        this.packet_length_array[0] = (byte)(this.packet_length >> 24 & 0xFF);
        this.padding = new byte[8 - this.packet_length % 8];
        if (sshCrypto == null) {
            for (n = 0; n < this.padding.length; ++n) {
                this.padding[n] = 0;
            }
        } else {
            for (n = 0; n < this.padding.length; ++n) {
                this.padding[n] = SshIO.getNotZeroRandomByte();
            }
        }
        this.block = new byte[this.packet_length + this.padding.length];
        System.arraycopy(this.padding, 0, this.block, 0, this.padding.length);
        n = this.padding.length;
        this.block[n++] = this.getType();
        if (this.packet_length > 5) {
            System.arraycopy(byArray, 0, this.block, n, byArray.length);
            n += byArray.length;
        }
        long l = SshPacket1.crc32(this.block, n);
        this.crc_array[3] = (byte)(l & 0xFFL);
        this.crc_array[2] = (byte)(l >> 8 & 0xFFL);
        this.crc_array[1] = (byte)(l >> 16 & 0xFFL);
        this.crc_array[0] = (byte)(l >> 24 & 0xFFL);
        System.arraycopy(this.crc_array, 0, this.block, n, 4);
        if (sshCrypto != null) {
            this.block = sshCrypto.encrypt(this.block);
        }
        byte[] byArray2 = new byte[this.block.length + 4];
        System.arraycopy(this.packet_length_array, 0, byArray2, 0, 4);
        System.arraycopy(this.block, 0, byArray2, 4, this.block.length);
        return byArray2;
    }

    public int addPayload(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            switch (this.phase_packet) {
                case 0: {
                    this.packet_length_array[this.position++] = byArray[n++];
                    if (this.position < 4) break;
                    this.packet_length = (this.packet_length_array[3] & 0xFF) + ((this.packet_length_array[2] & 0xFF) << 8) + ((this.packet_length_array[1] & 0xFF) << 16) + ((this.packet_length_array[0] & 0xFF) << 24);
                    this.position = 0;
                    ++this.phase_packet;
                    if (this.packet_length > 262144) {
                        throw new IllegalStateException("SshPacket1: Invalid packet_length " + this.packet_length);
                    }
                    int n4 = 8 * (this.packet_length / 8 + 1);
                    this.block = new byte[n4];
                    break;
                }
                case 1: {
                    byte[] byArray2;
                    int n4;
                    if (this.block.length > this.position && n < n3) {
                        n4 = n3 - n;
                        if (n4 > this.block.length - this.position) {
                            n4 = this.block.length - this.position;
                        }
                        System.arraycopy(byArray, n, this.block, this.position, n4);
                        n += n4;
                        this.position += n4;
                    }
                    if (this.position != this.block.length) break;
                    n4 = 0;
                    int n5 = 8 - this.packet_length % 8;
                    this.padding = new byte[n5];
                    this.decryptedBlock = this.crypto != null ? this.crypto.decrypt(this.block) : this.block;
                    if (this.decryptedBlock.length != n5 + this.packet_length) {
                        throw new IllegalStateException("SshPacket1: invalid decrypted packet length");
                    }
                    for (int i = 0; i < this.padding.length; ++i) {
                        this.padding[i] = this.decryptedBlock[n4++];
                    }
                    this.packet_type = this.decryptedBlock[n4++];
                    if (this.packet_length > 5) {
                        byArray2 = new byte[this.packet_length - 5];
                        System.arraycopy(this.decryptedBlock, n4, byArray2, 0, this.packet_length - 5);
                        n4 += this.packet_length - 5;
                    } else {
                        byArray2 = null;
                    }
                    this.putData(byArray2);
                    for (int i = 0; i < this.crc_array.length; ++i) {
                        this.crc_array[i] = this.decryptedBlock[n4++];
                    }
                    if (!this.checkCrc()) {
                        throw new IllegalStateException("SshPacket1: CRC wrong in received packet!");
                    }
                    return n;
                }
            }
        }
        return n;
    }

    private boolean checkCrc() {
        byte[] byArray = new byte[4];
        long l = SshPacket1.crc32(this.decryptedBlock, this.decryptedBlock.length - 4);
        byArray[3] = (byte)(l & 0xFFL);
        byArray[2] = (byte)(l >> 8 & 0xFFL);
        byArray[1] = (byte)(l >> 16 & 0xFFL);
        byArray[0] = (byte)(l >> 24 & 0xFFL);
        if (byArray[3] != this.crc_array[3]) {
            return false;
        }
        if (byArray[2] != this.crc_array[2]) {
            return false;
        }
        if (byArray[1] != this.crc_array[1]) {
            return false;
        }
        return byArray[0] == this.crc_array[0];
    }

    public static long crc32(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l = crc32_tab[(int)((l ^ (long)byArray[i]) & 0xFFL)] ^ l >> 8;
        }
        return l;
    }
}

