/*
 * Decompiled with CFR 0.152.
 */
package ssh.v2;

import java.util.Random;
import java.util.Stack;

public class BigInteger {
    private int sign;
    private int[] magnitude;
    private int nBits = -1;
    private int nBitLength = -1;
    private static final long IMASK = 0xFFFFFFFFL;
    private long mQuote = -1L;
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTES_PER_INT = 4;
    private static final byte[] rndMask = new byte[]{-1, 127, 63, 31, 15, 7, 3, 1};
    private static final byte[] bitCounts = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    public static final BigInteger ZERO = new BigInteger(0, new byte[0]);
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    public static final BigInteger TWO = BigInteger.valueOf(2L);

    private BigInteger() {
    }

    private BigInteger(int n, int[] nArray) {
        this.sign = n;
        if (nArray.length > 0) {
            int n2;
            for (n2 = 0; n2 < nArray.length && nArray[n2] == 0; ++n2) {
            }
            if (n2 == 0) {
                this.magnitude = nArray;
            } else {
                int[] nArray2 = new int[nArray.length - n2];
                System.arraycopy(nArray, n2, nArray2, 0, nArray2.length);
                this.magnitude = nArray2;
                if (nArray2.length == 0) {
                    this.sign = 0;
                }
            }
        } else {
            this.magnitude = nArray;
            this.sign = 0;
        }
    }

    public BigInteger(String string) throws NumberFormatException {
        this(string, 10);
    }

    public BigInteger(String string, int n) throws NumberFormatException {
        if (string.length() == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (n < 2 || n > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        int n2 = 0;
        this.sign = 1;
        if (string.charAt(0) == '-') {
            if (string.length() == 1) {
                throw new NumberFormatException("Zero length BigInteger");
            }
            this.sign = -1;
            n2 = 1;
        }
        while (n2 < string.length() && Character.digit(string.charAt(n2), n) == 0) {
            ++n2;
        }
        if (n2 >= string.length()) {
            this.sign = 0;
            this.magnitude = new int[0];
            return;
        }
        BigInteger bigInteger = ZERO;
        BigInteger bigInteger2 = BigInteger.valueOf(n);
        while (n2 < string.length()) {
            bigInteger = bigInteger.multiply(bigInteger2).add(BigInteger.valueOf(Character.digit(string.charAt(n2), n)));
            ++n2;
        }
        this.magnitude = bigInteger.magnitude;
    }

    public BigInteger(byte[] byArray) throws NumberFormatException {
        if (byArray.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        this.sign = 1;
        if (byArray[0] < 0) {
            int n;
            this.sign = -1;
            for (n = 0; n < byArray.length && byArray[n] == -1; ++n) {
            }
            this.magnitude = new int[(byArray.length - n) / 2 + 1];
        } else {
            this.magnitude = this.makeMagnitude(byArray);
        }
    }

    private int[] makeMagnitude(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length && byArray[n] == 0; ++n) {
        }
        if (n >= byArray.length) {
            return new int[0];
        }
        int n2 = (byArray.length - n + 3) / 4;
        int n3 = (byArray.length - n) % 4;
        if (n3 == 0) {
            n3 = 4;
        }
        int[] nArray = new int[n2];
        int n4 = 0;
        int n5 = 0;
        for (int i = n; i < byArray.length; ++i) {
            n4 <<= 8;
            n4 |= byArray[i] & 0xFF;
            if (--n3 > 0) continue;
            nArray[n5] = n4;
            ++n5;
            n3 = 4;
            n4 = 0;
        }
        if (n5 < nArray.length) {
            nArray[n5] = n4;
        }
        return nArray;
    }

    public BigInteger(int n, byte[] byArray) throws NumberFormatException {
        if (n < -1 || n > 1) {
            throw new NumberFormatException("Invalid sign value");
        }
        if (n == 0) {
            this.sign = 0;
            this.magnitude = new int[0];
            return;
        }
        this.magnitude = this.makeMagnitude(byArray);
        this.sign = n;
    }

    public BigInteger(int n, Random random) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("numBits must be non-negative");
        }
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        if (n2 > 0) {
            this.nextRndBytes(random, byArray);
            byArray[0] = (byte)(byArray[0] & rndMask[8 * n2 - n]);
        }
        this.magnitude = this.makeMagnitude(byArray);
        this.sign = 1;
        this.nBits = -1;
        this.nBitLength = -1;
    }

    private void nextRndBytes(Random random, byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        block0: while (true) {
            int n4 = 0;
            while (true) {
                if (n4 >= 4) continue block0;
                if (n2 == n) {
                    return;
                }
                n3 = n4 == 0 ? random.nextInt() : n3 >> 8;
                byArray[n2++] = (byte)n3;
                ++n4;
            }
            break;
        }
    }

    public BigInteger(int n, int n2, Random random) throws ArithmeticException {
        int n3 = (n + 7) / 8;
        byte[] byArray = new byte[n3];
        do {
            if (n3 > 0) {
                this.nextRndBytes(random, byArray);
                byArray[0] = (byte)(byArray[0] & rndMask[8 * n3 - n]);
            }
            this.magnitude = this.makeMagnitude(byArray);
            this.sign = 1;
            this.nBits = -1;
            this.nBitLength = -1;
            this.mQuote = -1L;
            if (n2 <= 0 || n <= 2) continue;
            int n4 = this.magnitude.length - 1;
            this.magnitude[n4] = this.magnitude[n4] | 1;
        } while (this.bitLength() != n || !this.isProbablePrime(n2));
    }

    public BigInteger abs() {
        return this.sign >= 0 ? this : this.negate();
    }

    private int[] add(int[] nArray, int[] nArray2) {
        int n = nArray.length - 1;
        int n2 = nArray2.length - 1;
        long l = 0L;
        while (n2 >= 0) {
            nArray[n--] = (int)(l += ((long)nArray[n] & 0xFFFFFFFFL) + ((long)nArray2[n2--] & 0xFFFFFFFFL));
            l >>>= 32;
        }
        while (n >= 0 && l != 0L) {
            nArray[n--] = (int)(l += (long)nArray[n] & 0xFFFFFFFFL);
            l >>>= 32;
        }
        return nArray;
    }

    public BigInteger add(BigInteger bigInteger) throws ArithmeticException {
        int[] nArray;
        int[] nArray2;
        if (bigInteger.sign == 0 || bigInteger.magnitude.length == 0) {
            return this;
        }
        if (this.sign == 0 || this.magnitude.length == 0) {
            return bigInteger;
        }
        if (bigInteger.sign < 0) {
            if (this.sign > 0) {
                return this.subtract(bigInteger.negate());
            }
        } else if (this.sign < 0) {
            return bigInteger.subtract(this.negate());
        }
        if (this.magnitude.length < bigInteger.magnitude.length) {
            nArray2 = new int[bigInteger.magnitude.length + 1];
            System.arraycopy(bigInteger.magnitude, 0, nArray2, 1, bigInteger.magnitude.length);
            nArray = this.magnitude;
        } else {
            nArray2 = new int[this.magnitude.length + 1];
            System.arraycopy(this.magnitude, 0, nArray2, 1, this.magnitude.length);
            nArray = bigInteger.magnitude;
        }
        return new BigInteger(this.sign, this.add(nArray2, nArray));
    }

    public int bitCount() {
        if (this.nBits == -1) {
            this.nBits = 0;
            for (int i = 0; i < this.magnitude.length; ++i) {
                this.nBits += bitCounts[this.magnitude[i] & 0xFF];
                this.nBits += bitCounts[this.magnitude[i] >> 8 & 0xFF];
                this.nBits += bitCounts[this.magnitude[i] >> 16 & 0xFF];
                this.nBits += bitCounts[this.magnitude[i] >> 24 & 0xFF];
            }
        }
        return this.nBits;
    }

    private int bitLength(int n, int[] nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        while (n != nArray.length && nArray[n] == 0) {
            ++n;
        }
        if (n == nArray.length) {
            return 0;
        }
        int n2 = 32 * (nArray.length - n - 1);
        n2 += BigInteger.bitLen(nArray[n]);
        if (this.sign < 0) {
            boolean bl = bitCounts[nArray[n] & 0xFF] + bitCounts[nArray[n] >> 8 & 0xFF] + bitCounts[nArray[n] >> 16 & 0xFF] + bitCounts[nArray[n] >> 24 & 0xFF] == 1;
            for (int i = n + 1; i < nArray.length && bl; ++i) {
                bl = nArray[i] == 0;
            }
            n2 -= bl ? 1 : 0;
        }
        return n2;
    }

    public int bitLength() {
        if (this.nBitLength == -1) {
            this.nBitLength = this.sign == 0 ? 0 : this.bitLength(0, this.magnitude);
        }
        return this.nBitLength;
    }

    static int bitLen(int n) {
        return n < 32768 ? (n < 128 ? (n < 8 ? (n < 2 ? (n < 1 ? (n < 0 ? 32 : 0) : 1) : (n < 4 ? 2 : 3)) : (n < 32 ? (n < 16 ? 4 : 5) : (n < 64 ? 6 : 7))) : (n < 2048 ? (n < 512 ? (n < 256 ? 8 : 9) : (n < 1024 ? 10 : 11)) : (n < 8192 ? (n < 4096 ? 12 : 13) : (n < 16384 ? 14 : 15)))) : (n < 0x800000 ? (n < 524288 ? (n < 131072 ? (n < 65536 ? 16 : 17) : (n < 262144 ? 18 : 19)) : (n < 0x200000 ? (n < 0x100000 ? 20 : 21) : (n < 0x400000 ? 22 : 23))) : (n < 0x8000000 ? (n < 0x2000000 ? (n < 0x1000000 ? 24 : 25) : (n < 0x4000000 ? 26 : 27)) : (n < 0x20000000 ? (n < 0x10000000 ? 28 : 29) : (n < 0x40000000 ? 30 : 31))));
    }

    public int compareTo(Object object) {
        return this.compareTo((BigInteger)object);
    }

    private int compareTo(int n, int[] nArray, int n2, int[] nArray2) {
        while (n != nArray.length && nArray[n] == 0) {
            ++n;
        }
        while (n2 != nArray2.length && nArray2[n2] == 0) {
            ++n2;
        }
        if (nArray.length - n < nArray2.length - n2) {
            return -1;
        }
        if (nArray.length - n > nArray2.length - n2) {
            return 1;
        }
        while (n < nArray.length) {
            long l;
            long l2;
            if ((l2 = (long)nArray[n++] & 0xFFFFFFFFL) < (l = (long)nArray2[n2++] & 0xFFFFFFFFL)) {
                return -1;
            }
            if (l2 <= l) continue;
            return 1;
        }
        return 0;
    }

    public int compareTo(BigInteger bigInteger) {
        if (this.sign < bigInteger.sign) {
            return -1;
        }
        if (this.sign > bigInteger.sign) {
            return 1;
        }
        return this.compareTo(0, this.magnitude, 0, bigInteger.magnitude);
    }

    private int[] divide(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int n = this.compareTo(0, nArray, 0, nArray2);
        if (n > 0) {
            int[] nArray4;
            int[] nArray5;
            int n2 = this.bitLength(0, nArray) - this.bitLength(0, nArray2);
            if (n2 > 1) {
                nArray5 = this.shiftLeft(nArray2, n2 - 1);
                nArray3 = this.shiftLeft(BigInteger.ONE.magnitude, n2 - 1);
                if (n2 % 32 == 0) {
                    nArray4 = new int[n2 / 32 + 1];
                    System.arraycopy(nArray3, 0, nArray4, 1, nArray4.length - 1);
                    nArray4[0] = 0;
                    nArray3 = nArray4;
                }
            } else {
                nArray5 = new int[nArray.length];
                nArray3 = new int[1];
                System.arraycopy(nArray2, 0, nArray5, nArray5.length - nArray2.length, nArray2.length);
                nArray3[0] = 1;
            }
            nArray4 = new int[nArray3.length];
            this.subtract(0, nArray, 0, nArray5);
            System.arraycopy(nArray3, 0, nArray4, 0, nArray3.length);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (true) {
                int n6 = this.compareTo(n3, nArray, n4, nArray5);
                while (n6 >= 0) {
                    this.subtract(n3, nArray, n4, nArray5);
                    this.add(nArray3, nArray4);
                    n6 = this.compareTo(n3, nArray, n4, nArray5);
                }
                n = this.compareTo(n3, nArray, 0, nArray2);
                if (n <= 0) break;
                if (nArray[n3] == 0) {
                    ++n3;
                }
                if ((n2 = this.bitLength(n4, nArray5) - this.bitLength(n3, nArray)) == 0) {
                    nArray5 = this.shiftRightOne(n4, nArray5);
                    nArray4 = this.shiftRightOne(n5, nArray4);
                } else {
                    nArray5 = this.shiftRight(n4, nArray5, n2);
                    nArray4 = this.shiftRight(n5, nArray4, n2);
                }
                if (nArray5[n4] == 0) {
                    ++n4;
                }
                if (nArray4[n5] != 0) continue;
                ++n5;
            }
            if (n == 0) {
                this.add(nArray3, BigInteger.ONE.magnitude);
                for (int i = n3; i != nArray.length; ++i) {
                    nArray[i] = 0;
                }
            }
        } else {
            nArray3 = n == 0 ? new int[]{1} : new int[]{0};
        }
        return nArray3;
    }

    public BigInteger divide(BigInteger bigInteger) throws ArithmeticException {
        if (bigInteger.sign == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        if (this.sign == 0) {
            return ZERO;
        }
        if (bigInteger.compareTo(ONE) == 0) {
            return this;
        }
        int[] nArray = new int[this.magnitude.length];
        System.arraycopy(this.magnitude, 0, nArray, 0, nArray.length);
        return new BigInteger(this.sign * bigInteger.sign, this.divide(nArray, bigInteger.magnitude));
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) throws ArithmeticException {
        if (bigInteger.sign == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        BigInteger[] bigIntegerArray = new BigInteger[2];
        if (this.sign == 0) {
            bigIntegerArray[0] = bigIntegerArray[1] = ZERO;
            return bigIntegerArray;
        }
        if (bigInteger.compareTo(ONE) == 0) {
            bigIntegerArray[0] = this;
            bigIntegerArray[1] = ZERO;
            return bigIntegerArray;
        }
        int[] nArray = new int[this.magnitude.length];
        System.arraycopy(this.magnitude, 0, nArray, 0, nArray.length);
        int[] nArray2 = this.divide(nArray, bigInteger.magnitude);
        bigIntegerArray[0] = new BigInteger(this.sign * bigInteger.sign, nArray2);
        bigIntegerArray[1] = new BigInteger(this.sign, nArray);
        return bigIntegerArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BigInteger)) {
            return false;
        }
        BigInteger bigInteger = (BigInteger)object;
        if (bigInteger.sign != this.sign || bigInteger.magnitude.length != this.magnitude.length) {
            return false;
        }
        for (int i = 0; i < this.magnitude.length; ++i) {
            if (bigInteger.magnitude[i] == this.magnitude[i]) continue;
            return false;
        }
        return true;
    }

    public BigInteger gcd(BigInteger bigInteger) {
        if (bigInteger.sign == 0) {
            return this.abs();
        }
        if (this.sign == 0) {
            return bigInteger.abs();
        }
        BigInteger bigInteger2 = this;
        BigInteger bigInteger3 = bigInteger;
        while (bigInteger3.sign != 0) {
            BigInteger bigInteger4 = bigInteger2.mod(bigInteger3);
            bigInteger2 = bigInteger3;
            bigInteger3 = bigInteger4;
        }
        return bigInteger2;
    }

    public int hashCode() {
        return 0;
    }

    public int intValue() {
        if (this.magnitude.length == 0) {
            return 0;
        }
        if (this.sign < 0) {
            return -this.magnitude[this.magnitude.length - 1];
        }
        return this.magnitude[this.magnitude.length - 1];
    }

    public boolean isProbablePrime(int n) {
        if (n == 0) {
            return true;
        }
        BigInteger bigInteger = this.abs();
        if (bigInteger.equals(TWO)) {
            return true;
        }
        if (bigInteger.equals(ONE) || !bigInteger.testBit(0)) {
            return false;
        }
        n = (n & 1) == 1 ? n / 2 + 1 : (n /= 2);
        BigInteger bigInteger2 = bigInteger.subtract(ONE);
        int n2 = bigInteger2.getLowestSetBit();
        bigInteger2 = bigInteger2.shiftRight(n2);
        Random random = new Random();
        for (int i = 0; i <= n; ++i) {
            BigInteger bigInteger3;
            while ((bigInteger3 = new BigInteger(bigInteger.bitLength(), random)).compareTo(ONE) <= 0 || bigInteger3.compareTo(bigInteger) >= 0) {
            }
            int n3 = 0;
            BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
            while (!(n3 == 0 && bigInteger4.equals(ONE) || bigInteger4.equals(bigInteger.subtract(ONE)))) {
                if (n3 > 0 && bigInteger4.equals(ONE)) {
                    return false;
                }
                if (++n3 == n2) {
                    return false;
                }
                bigInteger4 = bigInteger4.modPow(TWO, bigInteger);
            }
        }
        return true;
    }

    public long longValue() {
        long l = 0L;
        if (this.magnitude.length == 0) {
            return 0L;
        }
        l = this.magnitude.length > 1 ? (long)this.magnitude[this.magnitude.length - 2] << 32 | (long)this.magnitude[this.magnitude.length - 1] & 0xFFFFFFFFL : (long)this.magnitude[this.magnitude.length - 1] & 0xFFFFFFFFL;
        if (this.sign < 0) {
            return -l;
        }
        return l;
    }

    public BigInteger max(BigInteger bigInteger) {
        return this.compareTo(bigInteger) > 0 ? this : bigInteger;
    }

    public BigInteger min(BigInteger bigInteger) {
        return this.compareTo(bigInteger) < 0 ? this : bigInteger;
    }

    public BigInteger mod(BigInteger bigInteger) throws ArithmeticException {
        if (bigInteger.sign <= 0) {
            throw new ArithmeticException("BigInteger: modulus is not positive");
        }
        BigInteger bigInteger2 = this.remainder(bigInteger);
        return bigInteger2.sign >= 0 ? bigInteger2 : bigInteger2.add(bigInteger);
    }

    public BigInteger modInverse(BigInteger bigInteger) throws ArithmeticException {
        if (bigInteger.sign != 1) {
            throw new ArithmeticException("Modulus must be positive");
        }
        BigInteger bigInteger2 = new BigInteger();
        BigInteger bigInteger3 = new BigInteger();
        BigInteger bigInteger4 = BigInteger.extEuclid(this, bigInteger, bigInteger2, bigInteger3);
        if (!bigInteger4.equals(ONE)) {
            throw new ArithmeticException("Numbers not relatively prime.");
        }
        if (bigInteger2.compareTo(ZERO) < 0) {
            bigInteger2 = bigInteger2.add(bigInteger);
        }
        return bigInteger2;
    }

    private static BigInteger extEuclid(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        BigInteger bigInteger5 = ONE;
        BigInteger bigInteger6 = bigInteger;
        BigInteger bigInteger7 = ZERO;
        BigInteger bigInteger8 = bigInteger2;
        while (bigInteger8.compareTo(ZERO) > 0) {
            BigInteger bigInteger9 = bigInteger6.divide(bigInteger8);
            BigInteger bigInteger10 = bigInteger5.subtract(bigInteger7.multiply(bigInteger9));
            bigInteger5 = bigInteger7;
            bigInteger7 = bigInteger10;
            bigInteger10 = bigInteger6.subtract(bigInteger8.multiply(bigInteger9));
            bigInteger6 = bigInteger8;
            bigInteger8 = bigInteger10;
        }
        bigInteger3.sign = bigInteger5.sign;
        bigInteger3.magnitude = bigInteger5.magnitude;
        BigInteger bigInteger11 = bigInteger6.subtract(bigInteger5.multiply(bigInteger)).divide(bigInteger2);
        bigInteger4.sign = bigInteger11.sign;
        bigInteger4.magnitude = bigInteger11.magnitude;
        return bigInteger6;
    }

    private void zero(int[] nArray) {
        for (int i = 0; i != nArray.length; ++i) {
            nArray[i] = 0;
        }
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) throws ArithmeticException {
        BigInteger bigInteger3;
        int[] nArray = null;
        int[] nArray2 = null;
        boolean bl = (bigInteger2.magnitude[bigInteger2.magnitude.length - 1] & 1) == 1;
        long l = 0L;
        if (bl) {
            l = bigInteger2.getMQuote();
            bigInteger3 = this.shiftLeft(32 * bigInteger2.magnitude.length).mod(bigInteger2);
            nArray = bigInteger3.magnitude;
            boolean bl2 = bl = nArray.length <= bigInteger2.magnitude.length;
            if (bl) {
                nArray2 = new int[bigInteger2.magnitude.length + 1];
                if (nArray.length < bigInteger2.magnitude.length) {
                    int[] nArray3 = new int[bigInteger2.magnitude.length];
                    System.arraycopy(nArray, 0, nArray3, nArray3.length - nArray.length, nArray.length);
                    nArray = nArray3;
                }
            }
        }
        if (!bl) {
            if (this.magnitude.length <= bigInteger2.magnitude.length) {
                nArray = new int[bigInteger2.magnitude.length];
                System.arraycopy(this.magnitude, 0, nArray, nArray.length - this.magnitude.length, this.magnitude.length);
            } else {
                bigInteger3 = this.remainder(bigInteger2);
                nArray = new int[bigInteger2.magnitude.length];
                System.arraycopy(bigInteger3.magnitude, 0, nArray, nArray.length - bigInteger3.magnitude.length, bigInteger3.magnitude.length);
            }
            nArray2 = new int[bigInteger2.magnitude.length * 2];
        }
        int[] nArray4 = new int[bigInteger2.magnitude.length];
        for (int i = 0; i < bigInteger.magnitude.length; ++i) {
            int n = bigInteger.magnitude[i];
            int n2 = 0;
            if (i == 0) {
                while (n > 0) {
                    n <<= 1;
                    ++n2;
                }
                System.arraycopy(nArray, 0, nArray4, 0, nArray.length);
                n <<= 1;
                ++n2;
            }
            while (n != 0) {
                if (bl) {
                    this.multiplyMonty(nArray2, nArray4, nArray4, bigInteger2.magnitude, l);
                } else {
                    this.square(nArray2, nArray4);
                    this.remainder(nArray2, bigInteger2.magnitude);
                    System.arraycopy(nArray2, nArray2.length - nArray4.length, nArray4, 0, nArray4.length);
                    this.zero(nArray2);
                }
                ++n2;
                if (n < 0) {
                    if (bl) {
                        this.multiplyMonty(nArray2, nArray4, nArray, bigInteger2.magnitude, l);
                    } else {
                        this.multiply(nArray2, nArray4, nArray);
                        this.remainder(nArray2, bigInteger2.magnitude);
                        System.arraycopy(nArray2, nArray2.length - nArray4.length, nArray4, 0, nArray4.length);
                        this.zero(nArray2);
                    }
                }
                n <<= 1;
            }
            while (n2 < 32) {
                if (bl) {
                    this.multiplyMonty(nArray2, nArray4, nArray4, bigInteger2.magnitude, l);
                } else {
                    this.square(nArray2, nArray4);
                    this.remainder(nArray2, bigInteger2.magnitude);
                    System.arraycopy(nArray2, nArray2.length - nArray4.length, nArray4, 0, nArray4.length);
                    this.zero(nArray2);
                }
                ++n2;
            }
        }
        if (bl) {
            this.zero(nArray);
            nArray[nArray.length - 1] = 1;
            this.multiplyMonty(nArray2, nArray4, nArray, bigInteger2.magnitude, l);
        }
        return new BigInteger(1, nArray4);
    }

    private int[] square(int[] nArray, int[] nArray2) {
        long l;
        long l2;
        if (nArray.length != 2 * nArray2.length) {
            throw new IllegalArgumentException("no I don't think so...");
        }
        for (int i = nArray2.length - 1; i != 0; --i) {
            long l3 = (long)nArray2[i] & 0xFFFFFFFFL;
            l2 = l3 * l3;
            l = l2 >>> 32;
            l2 &= 0xFFFFFFFFL;
            nArray[2 * i + 1] = (int)(l2 += (long)nArray[2 * i + 1] & 0xFFFFFFFFL);
            long l4 = l + (l2 >> 32);
            for (int j = i - 1; j >= 0; --j) {
                l2 = ((long)nArray2[j] & 0xFFFFFFFFL) * l3;
                l = l2 >>> 31;
                l2 = (l2 & Integer.MAX_VALUE) << 1;
                nArray[i + j + 1] = (int)(l2 += ((long)nArray[i + j + 1] & 0xFFFFFFFFL) + l4);
                l4 = l + (l2 >>> 32);
            }
            nArray[i] = (int)(l4 += (long)nArray[i] & 0xFFFFFFFFL);
            nArray[i - 1] = (int)(l4 >> 32);
        }
        l2 = (long)nArray2[0] & 0xFFFFFFFFL;
        l2 *= l2;
        l = l2 >>> 32;
        l2 &= 0xFFFFFFFFL;
        nArray[1] = (int)(l2 += (long)nArray[1] & 0xFFFFFFFFL);
        nArray[0] = (int)(l + (l2 >> 32) + (long)nArray[0]);
        return nArray;
    }

    private int[] multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i = nArray3.length - 1; i >= 0; --i) {
            long l = (long)nArray3[i] & 0xFFFFFFFFL;
            long l2 = 0L;
            for (int j = nArray2.length - 1; j >= 0; --j) {
                nArray[i + j + 1] = (int)(l2 += l * ((long)nArray2[j] & 0xFFFFFFFFL) + ((long)nArray[i + j + 1] & 0xFFFFFFFFL));
                l2 >>>= 32;
            }
            nArray[i] = (int)l2;
        }
        return nArray;
    }

    private long getMQuote() {
        if (this.mQuote != -1L) {
            return this.mQuote;
        }
        if ((this.magnitude[this.magnitude.length - 1] & 1) == 0) {
            return -1L;
        }
        byte[] byArray = new byte[]{1, 0, 0, 0, 0};
        BigInteger bigInteger = new BigInteger(1, byArray);
        this.mQuote = this.negate().mod(bigInteger).modInverse(bigInteger).longValue();
        return this.mQuote;
    }

    public void multiplyMonty(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, long l) {
        int n;
        int n2 = nArray4.length;
        int n3 = n2 - 1;
        long l2 = (long)nArray3[n2 - 1] & 0xFFFFFFFFL;
        for (n = 0; n <= n2; ++n) {
            nArray[n] = 0;
        }
        for (n = n2; n > 0; --n) {
            long l3 = (long)nArray2[n - 1] & 0xFFFFFFFFL;
            long l4 = (((long)nArray[n2] & 0xFFFFFFFFL) + (l3 * l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL) * l & 0xFFFFFFFFL;
            long l5 = l3 * l2;
            long l6 = l4 * ((long)nArray4[n2 - 1] & 0xFFFFFFFFL);
            long l7 = ((long)nArray[n2] & 0xFFFFFFFFL) + (l5 & 0xFFFFFFFFL) + (l6 & 0xFFFFFFFFL);
            long l8 = (l5 >>> 32) + (l6 >>> 32) + (l7 >>> 32);
            for (int i = n3; i > 0; --i) {
                l5 = l3 * ((long)nArray3[i - 1] & 0xFFFFFFFFL);
                l6 = l4 * ((long)nArray4[i - 1] & 0xFFFFFFFFL);
                l7 = ((long)nArray[i] & 0xFFFFFFFFL) + (l5 & 0xFFFFFFFFL) + (l6 & 0xFFFFFFFFL) + (l8 & 0xFFFFFFFFL);
                l8 = (l8 >>> 32) + (l5 >>> 32) + (l6 >>> 32) + (l7 >>> 32);
                nArray[i + 1] = (int)l7;
            }
            nArray[1] = (int)(l8 += (long)nArray[0] & 0xFFFFFFFFL);
            nArray[0] = (int)(l8 >>> 32);
        }
        if (this.compareTo(0, nArray, 0, nArray4) >= 0) {
            this.subtract(0, nArray, 0, nArray4);
        }
        for (n = 0; n < n2; ++n) {
            nArray2[n] = nArray[n + 1];
        }
    }

    public BigInteger multiply(BigInteger bigInteger) {
        if (this.sign == 0 || bigInteger.sign == 0) {
            return ZERO;
        }
        int[] nArray = new int[this.magnitude.length + bigInteger.magnitude.length];
        return new BigInteger(this.sign * bigInteger.sign, this.multiply(nArray, this.magnitude, bigInteger.magnitude));
    }

    public BigInteger negate() {
        return new BigInteger(-this.sign, this.magnitude);
    }

    public BigInteger pow(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (this.sign == 0) {
            return n == 0 ? ONE : this;
        }
        BigInteger bigInteger = ONE;
        BigInteger bigInteger2 = this;
        while (n != 0) {
            if ((n & 1) == 1) {
                bigInteger = bigInteger.multiply(bigInteger2);
            }
            if ((n >>= 1) == 0) continue;
            bigInteger2 = bigInteger2.multiply(bigInteger2);
        }
        return bigInteger;
    }

    private int[] remainder(int[] nArray, int[] nArray2) {
        block9: {
            int n;
            block8: {
                int[] nArray3;
                n = this.compareTo(0, nArray, 0, nArray2);
                if (n <= 0) break block8;
                int n2 = this.bitLength(0, nArray) - this.bitLength(0, nArray2);
                if (n2 > 1) {
                    nArray3 = this.shiftLeft(nArray2, n2 - 1);
                } else {
                    nArray3 = new int[nArray.length];
                    System.arraycopy(nArray2, 0, nArray3, nArray3.length - nArray2.length, nArray2.length);
                }
                this.subtract(0, nArray, 0, nArray3);
                int n3 = 0;
                int n4 = 0;
                while (true) {
                    int n5 = this.compareTo(n3, nArray, n4, nArray3);
                    while (n5 >= 0) {
                        this.subtract(n3, nArray, n4, nArray3);
                        n5 = this.compareTo(n3, nArray, n4, nArray3);
                    }
                    n = this.compareTo(n3, nArray, 0, nArray2);
                    if (n <= 0) break;
                    if (nArray[n3] == 0) {
                        ++n3;
                    }
                    if ((nArray3 = (n2 = this.bitLength(n4, nArray3) - this.bitLength(n3, nArray)) == 0 ? this.shiftRightOne(n4, nArray3) : this.shiftRight(n4, nArray3, n2))[n4] != 0) continue;
                    ++n4;
                }
                if (n != 0) break block9;
                for (int i = n3; i != nArray.length; ++i) {
                    nArray[i] = 0;
                }
                break block9;
            }
            if (n == 0) {
                for (int i = 0; i != nArray.length; ++i) {
                    nArray[i] = 0;
                }
            }
        }
        return nArray;
    }

    public BigInteger remainder(BigInteger bigInteger) throws ArithmeticException {
        if (bigInteger.sign == 0) {
            throw new ArithmeticException("BigInteger: Divide by zero");
        }
        if (this.sign == 0) {
            return ZERO;
        }
        int[] nArray = new int[this.magnitude.length];
        System.arraycopy(this.magnitude, 0, nArray, 0, nArray.length);
        return new BigInteger(this.sign, this.remainder(nArray, bigInteger.magnitude));
    }

    private int[] shiftLeft(int[] nArray, int n) {
        int n2 = n >>> 5;
        int n3 = n & 0x1F;
        int n4 = nArray.length;
        int[] nArray2 = null;
        if (n3 == 0) {
            nArray2 = new int[n4 + n2];
            for (int i = 0; i < n4; ++i) {
                nArray2[i] = nArray[i];
            }
        } else {
            int n5 = 0;
            int n6 = 32 - n3;
            int n7 = nArray[0] >>> n6;
            if (n7 != 0) {
                nArray2 = new int[n4 + n2 + 1];
                nArray2[n5++] = n7;
            } else {
                nArray2 = new int[n4 + n2];
            }
            int n8 = nArray[0];
            for (int i = 0; i < n4 - 1; ++i) {
                int n9 = nArray[i + 1];
                nArray2[n5++] = n8 << n3 | n9 >>> n6;
                n8 = n9;
            }
            nArray2[n5] = nArray[n4 - 1] << n3;
        }
        return nArray2;
    }

    public BigInteger shiftLeft(int n) {
        if (this.sign == 0 || this.magnitude.length == 0) {
            return ZERO;
        }
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftRight(-n);
        }
        return new BigInteger(this.sign, this.shiftLeft(this.magnitude, n));
    }

    private int[] shiftRight(int n, int[] nArray, int n2) {
        int n3;
        int n4;
        int n5 = (n2 >>> 5) + n;
        int n6 = n2 & 0x1F;
        int n7 = nArray.length;
        if (n5 != n) {
            n4 = n5 - n;
            for (n3 = n7 - 1; n3 >= n5; --n3) {
                nArray[n3] = nArray[n3 - n4];
            }
            for (n3 = n5 - 1; n3 >= n; --n3) {
                nArray[n3] = 0;
            }
        }
        if (n6 != 0) {
            n4 = 32 - n6;
            n3 = nArray[n7 - 1];
            for (int i = n7 - 1; i >= n5 + 1; --i) {
                int n8 = nArray[i - 1];
                nArray[i] = n3 >>> n6 | n8 << n4;
                n3 = n8;
            }
            int n9 = n5;
            nArray[n9] = nArray[n9] >>> n6;
        }
        return nArray;
    }

    private int[] shiftRightOne(int n, int[] nArray) {
        int n2 = nArray.length;
        int n3 = nArray[n2 - 1];
        for (int i = n2 - 1; i >= n + 1; --i) {
            int n4 = nArray[i - 1];
            nArray[i] = n3 >>> 1 | n4 << 31;
            n3 = n4;
        }
        int n5 = n;
        nArray[n5] = nArray[n5] >>> 1;
        return nArray;
    }

    public BigInteger shiftRight(int n) {
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftLeft(-n);
        }
        if (n >= this.bitLength()) {
            return this.sign < 0 ? BigInteger.valueOf(-1L) : ZERO;
        }
        int[] nArray = new int[this.magnitude.length];
        System.arraycopy(this.magnitude, 0, nArray, 0, nArray.length);
        return new BigInteger(this.sign, this.shiftRight(0, nArray, n));
    }

    public int signum() {
        return this.sign;
    }

    private int[] subtract(int n, int[] nArray, int n2, int[] nArray2) {
        long l;
        int n3 = nArray.length - 1;
        int n4 = nArray2.length - 1;
        int n5 = 0;
        do {
            l = ((long)nArray[n3] & 0xFFFFFFFFL) - ((long)nArray2[n4--] & 0xFFFFFFFFL) + (long)n5;
            nArray[n3--] = (int)l;
            n5 = l < 0L ? -1 : 0;
        } while (n4 >= n2);
        while (n3 >= n) {
            l = ((long)nArray[n3] & 0xFFFFFFFFL) + (long)n5;
            nArray[n3--] = (int)l;
            if (l >= 0L) break;
            n5 = -1;
        }
        return nArray;
    }

    public BigInteger subtract(BigInteger bigInteger) {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        if (bigInteger.sign == 0 || bigInteger.magnitude.length == 0) {
            return this;
        }
        if (this.sign == 0 || this.magnitude.length == 0) {
            return bigInteger.negate();
        }
        if (bigInteger.sign < 0 ? this.sign > 0 : this.sign < 0) {
            return this.add(bigInteger.negate());
        }
        int n = this.compareTo(bigInteger);
        if (n == 0) {
            return ZERO;
        }
        if (n < 0) {
            bigInteger3 = bigInteger;
            bigInteger2 = this;
        } else {
            bigInteger3 = this;
            bigInteger2 = bigInteger;
        }
        int[] nArray = new int[bigInteger3.magnitude.length];
        System.arraycopy(bigInteger3.magnitude, 0, nArray, 0, nArray.length);
        return new BigInteger(this.sign * n, this.subtract(0, nArray, 0, bigInteger2.magnitude));
    }

    public byte[] toByteArray() {
        int n = this.bitLength();
        byte[] byArray = new byte[n / 8 + 1];
        int n2 = 4;
        int n3 = 0;
        int n4 = this.magnitude.length - 1;
        int n5 = 1;
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (n2 == 4 && n4 >= 0) {
                if (this.sign < 0) {
                    long l = (long)(~this.magnitude[n4--]) & 0xFFFFFFFFL;
                    n5 = ((l += (long)n5) & 0xFFFFFFFF00000000L) != 0L ? 1 : 0;
                    n3 = (int)(l & 0xFFFFFFFFL);
                } else {
                    n3 = this.magnitude[n4--];
                }
                n2 = 1;
            } else {
                n3 >>>= 8;
                ++n2;
            }
            byArray[i] = (byte)n3;
        }
        return byArray;
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int n) {
        if (this.magnitude == null) {
            return "null";
        }
        if (this.sign == 0) {
            return "0";
        }
        String string = new String();
        if (n == 16) {
            for (int i = 0; i < this.magnitude.length; ++i) {
                String string2 = "0000000" + Integer.toHexString(this.magnitude[i]);
                string2 = string2.substring(string2.length() - 8);
                string = string + string2;
            }
        } else {
            Stack<String> stack = new Stack<String>();
            BigInteger bigInteger = new BigInteger(Integer.toString(n, n), n);
            BigInteger bigInteger2 = new BigInteger(this.abs().toString(16), 16);
            while (!bigInteger2.equals(ZERO)) {
                BigInteger bigInteger3 = bigInteger2.mod(bigInteger);
                if (bigInteger3.equals(ZERO)) {
                    stack.push("0");
                } else {
                    stack.push(Integer.toString(bigInteger3.magnitude[0], n));
                }
                bigInteger2 = bigInteger2.divide(bigInteger);
            }
            while (!stack.empty()) {
                string = string + stack.pop();
            }
        }
        while (string.length() > 1 && string.charAt(0) == '0') {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            string = "0";
        } else if (this.sign == -1) {
            string = "-" + string;
        }
        return string;
    }

    public static BigInteger valueOf(long l) {
        if (l == 0L) {
            return ZERO;
        }
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[7 - i] = (byte)l;
            l >>= 8;
        }
        return new BigInteger(byArray);
    }

    public int getLowestSetBit() {
        int n;
        int n2;
        if (this.equals(ZERO)) {
            return -1;
        }
        for (n2 = this.magnitude.length - 1; n2 >= 0 && this.magnitude[n2] == 0; --n2) {
        }
        for (n = 31; n > 0 && this.magnitude[n2] << n != Integer.MIN_VALUE; --n) {
        }
        return (this.magnitude.length - 1 - n2) * 32 + (31 - n);
    }

    public boolean testBit(int n) throws ArithmeticException {
        if (n < 0) {
            throw new ArithmeticException("Bit position must not be negative");
        }
        if (n / 32 >= this.magnitude.length) {
            return this.sign < 0;
        }
        return (this.magnitude[this.magnitude.length - 1 - n / 32] >> n % 32 & 1) > 0;
    }
}

