/*
 * Decompiled with CFR 0.152.
 */
package ssh.v2;

import app.Settings;
import java.util.Random;
import ssh.v2.BigInteger;
import ssh.v2.SHA1Digest;
import ssh.v2.SshPacket2;

public class PublicKeyAuthentication {
    public static final BigInteger p = new BigInteger("d1c9009c7f181e9b27ce020e014d72c499f604c8d978a4dd9a8614362b09a74be4004cdd1b6ccf2bb2d2a4d4710be0817a375c85e8b0ce05e92a1f7c0b4886418dc6de84457dfd8dc19efdc0efb5c15bbab7a860b3e95c169d6e8aceef445deddc85ab44a11d5870847b99239011ff7d36a0f52cd11c3a0a33c415cdd58d85a1", 16);
    public static final BigInteger q = new BigInteger("e691d26b30a8b43081b981d96a8189fe78d04f8f", 16);
    public static final BigInteger g = new BigInteger("6ded9dc637ecc98f7ccf5a50839e13354972985cb901ca164fb8174318c84fec50ce84bfef5f4ee4981c239ed7c2bcf0718fcc0f30382df782221f64bfd09c9dc8e098ad10f296eadd9f5650f17414a77d3ff5ca8d103235e2de14a392c9a1156b2a5652d135111858af96d531688d80e962c52c75738f3d48aa09d59ca064a6", 16);
    public BigInteger x = new BigInteger(Settings.x);
    public BigInteger y = new BigInteger(Settings.y);
    private static final byte[] b64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".getBytes();

    public byte[] sign(byte[] byArray, byte[] byArray2) {
        SshPacket2 sshPacket2 = new SshPacket2();
        sshPacket2.putString(byArray);
        sshPacket2.putByte((byte)50);
        sshPacket2.putBytes(byArray2);
        byArray2 = sshPacket2.getData();
        SHA1Digest sHA1Digest = new SHA1Digest();
        sHA1Digest.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray3, 0);
        BigInteger[] bigIntegerArray = this.generateSignature(byArray3);
        sshPacket2 = new SshPacket2();
        sshPacket2.putString("ssh-dss");
        byte[] byArray4 = bigIntegerArray[0].toByteArray();
        byte[] byArray5 = bigIntegerArray[1].toByteArray();
        byte[] byArray6 = new byte[40];
        System.arraycopy(byArray4, byArray4.length > 20 ? 1 : 0, byArray6, byArray4.length > 20 ? 0 : 20 - byArray4.length, byArray4.length > 20 ? 20 : byArray4.length);
        System.arraycopy(byArray5, byArray5.length > 20 ? 1 : 0, byArray6, byArray5.length > 20 ? 20 : 40 - byArray5.length, byArray5.length > 20 ? 20 : byArray5.length);
        sshPacket2.putString(byArray6);
        return sshPacket2.getData();
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        int n = q.bitLength();
        while ((bigInteger = new BigInteger(n, new Random())).compareTo(q) >= 0) {
        }
        BigInteger bigInteger3 = g.modPow(bigInteger, p).mod(q);
        bigInteger = bigInteger.modInverse(q).multiply(bigInteger2.add(this.x.multiply(bigInteger3)));
        BigInteger bigInteger4 = bigInteger.mod(q);
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger4};
        return bigIntegerArray;
    }

    public String getPublicKeyText() {
        byte[] byArray = this.getPublicKeyBlob();
        byte[] byArray2 = PublicKeyAuthentication.toBase64(byArray, 0, byArray.length);
        return "ssh-dss " + new String(byArray2);
    }

    public byte[] getPublicKeyBlob() {
        SshPacket2 sshPacket2 = new SshPacket2();
        sshPacket2.putString("ssh-dss");
        sshPacket2.putMpInt(p.toByteArray());
        sshPacket2.putMpInt(q.toByteArray());
        sshPacket2.putMpInt(g.toByteArray());
        sshPacket2.putMpInt(this.y.toByteArray());
        return sshPacket2.getData();
    }

    public static byte[][] generateKeyPair() {
        BigInteger bigInteger;
        while ((bigInteger = new BigInteger(160, new Random())).equals(BigInteger.ZERO) || bigInteger.compareTo(q) >= 0) {
        }
        BigInteger bigInteger2 = g.modPow(bigInteger, p);
        byte[][] byArrayArray = new byte[][]{bigInteger.toByteArray(), bigInteger2.toByteArray()};
        return byArrayArray;
    }

    private static byte[] toBase64(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        byte[] byArray2 = new byte[n2 * 2];
        int n5 = n2 / 3 * 3 + n;
        int n6 = 0;
        for (n4 = n; n4 < n5; n4 += 3) {
            n3 = byArray[n4] >>> 2 & 0x3F;
            byArray2[n6++] = b64[n3];
            n3 = (byArray[n4] & 3) << 4 | byArray[n4 + 1] >>> 4 & 0xF;
            byArray2[n6++] = b64[n3];
            n3 = (byArray[n4 + 1] & 0xF) << 2 | byArray[n4 + 2] >>> 6 & 3;
            byArray2[n6++] = b64[n3];
            n3 = byArray[n4 + 2] & 0x3F;
            byArray2[n6++] = b64[n3];
        }
        if ((n5 = n + n2 - n5) == 1) {
            n3 = byArray[n4] >>> 2 & 0x3F;
            byArray2[n6++] = b64[n3];
            n3 = (byArray[n4] & 3) << 4 & 0x3F;
            byArray2[n6++] = b64[n3];
            byArray2[n6++] = 61;
            byArray2[n6++] = 61;
        } else if (n5 == 2) {
            n3 = byArray[n4] >>> 2 & 0x3F;
            byArray2[n6++] = b64[n3];
            n3 = (byArray[n4] & 3) << 4 | byArray[n4 + 1] >>> 4 & 0xF;
            byArray2[n6++] = b64[n3];
            n3 = (byArray[n4 + 1] & 0xF) << 2 & 0x3F;
            byArray2[n6++] = b64[n3];
            byArray2[n6++] = 61;
        }
        byte[] byArray3 = new byte[n6];
        System.arraycopy(byArray2, 0, byArray3, 0, n6);
        return byArray3;
    }
}

