/*
 * Decompiled with CFR 0.152.
 */
package ssh.v2;

public class SHA1Digest {
    private static final int DIGEST_LENGTH = 20;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int[] X = new int[80];
    private int xOff;
    private byte[] xBuf = new byte[4];
    private int xBufOff = 0;
    private long byteCount;
    private static final int Y1 = 1518500249;
    private static final int Y2 = 1859775393;
    private static final int Y3 = -1894007588;
    private static final int Y4 = -899497514;

    public SHA1Digest() {
        this.reset();
    }

    public String getAlgorithmName() {
        return "SHA-1";
    }

    public int getDigestSize() {
        return 20;
    }

    protected void processWord(byte[] byArray, int n) {
        this.X[this.xOff++] = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        if (this.xOff == 16) {
            this.processBlock();
        }
    }

    private void unpackWord(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
    }

    protected void processLength(long l) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(l >>> 32);
        this.X[15] = (int)(l & 0xFFFFFFFFFFFFFFFFL);
    }

    public int doFinal(byte[] byArray, int n) {
        this.finish();
        this.unpackWord(this.H1, byArray, n);
        this.unpackWord(this.H2, byArray, n + 4);
        this.unpackWord(this.H3, byArray, n + 8);
        this.unpackWord(this.H4, byArray, n + 12);
        this.unpackWord(this.H5, byArray, n + 16);
        this.reset();
        return 20;
    }

    public void reset() {
        int n;
        this.byteCount = 0L;
        this.xBufOff = 0;
        for (n = 0; n < this.xBuf.length; ++n) {
            this.xBuf[n] = 0;
        }
        this.H1 = 1732584193;
        this.H2 = -271733879;
        this.H3 = -1732584194;
        this.H4 = 271733878;
        this.H5 = -1009589776;
        this.xOff = 0;
        for (n = 0; n != this.X.length; ++n) {
            this.X[n] = 0;
        }
    }

    public void update(byte by) {
        this.xBuf[this.xBufOff++] = by;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    public void update(byte[] byArray, int n, int n2) {
        while (this.xBufOff != 0 && n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
        while (n2 > this.xBuf.length) {
            this.processWord(byArray, n);
            n += this.xBuf.length;
            n2 -= this.xBuf.length;
            this.byteCount += (long)this.xBuf.length;
        }
        while (n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
    }

    public void finish() {
        long l = this.byteCount << 3;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(l);
        this.processBlock();
    }

    private int f(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private int h(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private int g(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    private int rotateLeft(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    protected void processBlock() {
        int n;
        int n2;
        int n3;
        for (n3 = 16; n3 <= 79; ++n3) {
            this.X[n3] = this.rotateLeft(this.X[n3 - 3] ^ this.X[n3 - 8] ^ this.X[n3 - 14] ^ this.X[n3 - 16], 1);
        }
        n3 = this.H1;
        int n4 = this.H2;
        int n5 = this.H3;
        int n6 = this.H4;
        int n7 = this.H5;
        for (n2 = 0; n2 <= 19; ++n2) {
            n = this.rotateLeft(n3, 5) + this.f(n4, n5, n6) + n7 + this.X[n2] + 1518500249;
            n7 = n6;
            n6 = n5;
            n5 = this.rotateLeft(n4, 30);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 20; n2 <= 39; ++n2) {
            n = this.rotateLeft(n3, 5) + this.h(n4, n5, n6) + n7 + this.X[n2] + 1859775393;
            n7 = n6;
            n6 = n5;
            n5 = this.rotateLeft(n4, 30);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 40; n2 <= 59; ++n2) {
            n = this.rotateLeft(n3, 5) + this.g(n4, n5, n6) + n7 + this.X[n2] + -1894007588;
            n7 = n6;
            n6 = n5;
            n5 = this.rotateLeft(n4, 30);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 60; n2 <= 79; ++n2) {
            n = this.rotateLeft(n3, 5) + this.h(n4, n5, n6) + n7 + this.X[n2] + -899497514;
            n7 = n6;
            n6 = n5;
            n5 = this.rotateLeft(n4, 30);
            n4 = n3;
            n3 = n;
        }
        this.H1 += n3;
        this.H2 += n4;
        this.H3 += n5;
        this.H4 += n6;
        this.H5 += n7;
        this.xOff = 0;
        for (n2 = 0; n2 != this.X.length; ++n2) {
            this.X[n2] = 0;
        }
    }
}

