/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.SocketRequest;
import de.mud.jta.plugin.MudConnector$1;
import de.mud.jta.plugin.MudConnector$2;
import de.mud.jta.plugin.MudConnector$3;
import de.mud.jta.plugin.MudConnector$4;
import de.mud.jta.plugin.MudConnector$ProgressBar;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Hashtable;

public class MudConnector
extends Plugin
implements VisualPlugin,
Runnable,
ActionListener {
    protected URL listURL = null;
    protected int step;
    protected Hashtable mudList = null;
    protected List mudListSelector = new List();
    protected TextField mudName;
    protected TextField mudAddr;
    protected TextField mudPort;
    protected Button connect;
    protected Panel mudListPanel;
    protected CardLayout layouter;
    protected MudConnector$ProgressBar progress;
    protected Label errorLabel;
    protected Menu MCMenu;

    public MudConnector(PluginBus pluginBus, String string) {
        super(pluginBus, string);
        pluginBus.registerPluginListener(new MudConnector$1(this, string));
        pluginBus.registerPluginListener(new MudConnector$2(this));
        this.layouter = new CardLayout();
        this.mudListPanel = new MudConnector$3(this, this.layouter);
        this.errorLabel = new Label("Loading ...");
        this.mudListPanel.add("ERROR", this.errorLabel);
        Panel panel = new Panel(new BorderLayout());
        panel.add("North", new Label("Loading mud list ... please wait"));
        this.progress = new MudConnector$ProgressBar(this);
        panel.add("Center", this.progress);
        this.mudListPanel.add("PROGRESS", panel);
        panel = new Panel(new BorderLayout());
        panel.add("Center", this.mudListSelector);
        this.mudListPanel.add("MUDLIST", panel);
        Panel panel2 = panel;
        panel = new Panel(new GridLayout(3, 1));
        panel2.add("East", panel);
        this.mudName = new TextField(20);
        panel.add(this.mudName);
        this.mudName.setEditable(false);
        Panel panel3 = new Panel(new BorderLayout());
        this.mudAddr = new TextField(20);
        panel3.add("Center", this.mudAddr);
        this.mudAddr.setEditable(false);
        this.mudPort = new TextField(6);
        panel3.add("East", this.mudPort);
        this.mudPort.setEditable(false);
        panel.add(panel3);
        this.connect = new Button("Connect");
        panel.add(this.connect);
        this.connect.addActionListener(this);
        this.mudListSelector.addActionListener(this);
        this.mudListSelector.addItemListener(new MudConnector$4(this));
        this.layouter.show(this.mudListPanel, "PROGRESS");
        this.MCMenu = new Menu("MudConnector");
    }

    private void m1() {
        if (this.mudList == null && this.listURL != null) {
            new Thread(this).start();
        }
    }

    public void run() {
        try {
            Hashtable<String, Menu> hashtable = new Hashtable<String, Menu>();
            this.mudList = new Hashtable();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.listURL.openStream()));
            String string = bufferedReader.readLine();
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.error("number of muds: " + numberFormatException);
            }
            System.out.println("MudConnector: expecting " + n + " mud entries");
            this.progress.setMax(n);
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.resetSyntax();
            streamTokenizer.whitespaceChars(0, 9);
            streamTokenizer.ordinaryChars(32, 255);
            streamTokenizer.wordChars(32, 255);
            int n2 = 0;
            int n3 = 0;
            while (streamTokenizer.nextToken() != -1) {
                String string2 = streamTokenizer.sval;
                int n4 = streamTokenizer.nextToken();
                if (n4 != -1) {
                    if (n4 == 10) {
                        this.error(string2 + ": unexpected end of line" + ", missing host and port");
                    }
                    String string3 = streamTokenizer.sval;
                    Integer n5 = new Integer(23);
                    n4 = streamTokenizer.nextToken();
                    if (n4 != -1) {
                        try {
                            if (n4 == 10) {
                                this.error(string2 + ": default port 23");
                            }
                            n5 = new Integer(streamTokenizer.sval);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.error("port for " + string2 + ": " + numberFormatException);
                        }
                    }
                    this.mudList.put(string2, new Object[]{string3, n5, new Integer(n3++)});
                    this.mudListSelector.add(string2);
                    this.progress.adjust(++n2, string2);
                    this.mudListPanel.repaint();
                    Menu menu = (Menu)hashtable.get(string2.charAt(0) + "");
                    if (menu == null) {
                        menu = new Menu(string2.charAt(0) + "");
                        this.MCMenu.add(menu);
                        hashtable.put(string2.charAt(0) + "", menu);
                    }
                    MenuItem menuItem = new MenuItem(string2);
                    menuItem.addActionListener(this);
                    menu.add(menuItem);
                }
                while (n4 != -1 && n4 != 10) {
                    n4 = streamTokenizer.nextToken();
                }
            }
            System.out.println("MudConnector: found " + this.mudList.size() + " entries");
        }
        catch (Exception exception) {
            this.error("error: " + exception);
            this.errorLabel.setText("Error: " + exception);
            this.layouter.show(this.mudListPanel, "ERROR");
        }
        this.layouter.show(this.mudListPanel, "MUDLIST");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource() instanceof MenuItem) {
            string = actionEvent.getActionCommand();
            int n = (Integer)((Object[])this.mudList.get(string))[2];
            this.mudListSelector.select(n);
            this.mudListSelector.makeVisible(n);
            this.mudName.setText(string);
            Object[] objectArray = (Object[])this.mudList.get(string);
            this.mudAddr.setText((String)objectArray[0]);
            this.mudPort.setText(((Integer)objectArray[1]).toString());
        }
        string = this.mudAddr.getText();
        String string2 = this.mudPort.getText();
        if (string != null) {
            this.bus.broadcast(new SocketRequest());
            if (string2 == null || string2.length() <= 0) {
                string2 = "23";
            }
            this.bus.broadcast(new SocketRequest(string, Integer.parseInt(string2)));
        }
    }

    public Component getPluginVisual() {
        return this.mudListPanel;
    }

    public Menu getPluginMenu() {
        return this.MCMenu;
    }

    static void access$000(MudConnector mudConnector) {
        mudConnector.m1();
    }
}

